/**
 * File : addUser.js
 *
 * This file contain the validation of add user form
 *
 * Using validation plugin : jquery.validate.js
 *
 * @author Vijayraj Chaudhary
 */


function checkUniqueMail() {

  var email = $("#email").val();
  if (email === '') {
    alert('Email is required');
  } else {
    $.ajax({
      type: 'POST',
      url: baseURL + "checkEmailExists",
      data: {email: email},
      dataType: 'JSON',
      success: function (response) {
        if (response === 'false') {
          alert("Email already in used.");
          $("#email").val('');
        }
      }
    });
  }

}


function checkEmployeeCode(obj) {

  var empcode = $(obj).val();

  if (empcode) {


    $.ajax({
      type: 'POST',
      url: baseURL + "checkEmployeecode",
      async: false,
      data: {emp_code: empcode},
      success: function (response) {
        if (response == 'false') {
          alert('Employee code already exist');
          $(obj).val('');

        }

      }
    })

  } else {

    alert('Employee code is required');

  }


}
function checkEmployeeUsername(obj) {

  var empcode = $(obj).val();

  if (empcode) {


    $.ajax({
      type: 'POST',
      url: baseURL + "checkEmployeeUsername",
      async: false,
      data: {emp_code: empcode},
      success: function (response) {
        if (response == 'false') {
          alert('Username already exist');
          $(obj).val('');

        }

      }
    })

  } else {

    alert('Username is required');

  }


}


function addNewUserForm() {

  var password = $("#password").val();
  var cpassword = $("#cpassword").val();
  if (password !== cpassword) {
    alert("Password does not match");
    return false;
  } else {
    $("#submitBth").attr("disabled", true);
    return true;
  }



}

$(document).ready(function () {

  $('#shift_div').css('display', 'none');

  $('#role').on('change', function () {

    if ($(this).val() === '4') {

      $('#shift_div').css('display', 'block');
    } else {

      $('#shift_div').css('display', 'none');
    }
  });

  var addUserForm = $("#addUser");

  var validator = addUserForm.validate({

    rules: {
      fname: {required: true},
//      email: {required: true, email: true, remote: {url: baseURL + "checkEmailExists", type: "post"}},
//      username: {required: true, remote: {url: baseURL + "checkEmployeeUsername", type: "post"}},
      password: {required: true},
      cpassword: {required: true, equalTo: "#password"},
      mobile: {required: true, digits: true, maxlength: 10, minlength: 10},
      role: {required: true, selected: true},
      department: {required: true},
      subdepartment: {required: true, selected: true},
//      emp_code: {required: true, remote: {url: baseURL + "checkEmployeecode", type: "post"}},
      doj: {required: true},

    },
    messages: {
      fname: {required: "Please enter the full name"},
//      email: {required: "Please enter valid email id", email: "Please enter valid email address", remote: "Email already taken"},
//      username: {required: "Please enter valid Username", remote: "Username already taken"},
      password: {required: "Please enter the password"},
      cpassword: {required: "Please enter the confirm password", equalTo: "Please enter same password"},
      mobile: {required: "Please enter the mobile number", digits: "Please enter numbers only"},
      role: {required: "Please select the role", selected: "Please select atleast one option"},
//      emp_code: {required: "Please enter the employee code", remote: "Employee code already taken"},
      doj: {required: "Please select the date of joining"}

    },
    submitHandler: function () {
      $('body').css('opacity', '0.5');
      $('body').css('pointer-events', 'none');
      $('#addUser').submit();
    }
  });
});
