<div class="content-wrapper">
  <!-- Content Header (Page header) -->
  <section class="content-header">
    <h1>
      <i class="fa fa-users"></i> Warehouse Management
      <small>Add / Edit Warehouse</small>
    </h1>
  </section>

  <section class="content">
    <div class="row">
      <div class="col-md-12">
        <?php
        //pre($locationList);
        $error = $this->session->flashdata('error');
        if ($error) {
          ?>
          <div class="alert alert-danger alert-dismissable">
            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
            <?php echo $this->session->flashdata('error'); ?>
          </div>
        <?php } ?>
        <?php
        $success = $this->session->flashdata('success');
        if ($success) {
          ?>
          <div class="alert alert-success alert-dismissable">
            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
            <?php echo $this->session->flashdata('success'); ?>
          </div>
        <?php } ?>
      </div>
    </div>
    <div class="row">
      <!-- left column -->
      <div class="col-md-6">
        <!-- general form elements -->
        <div class="box box-primary">
          <div class="box-header">
            <h3 class="box-title">Warehouse Details</h3>
          </div><!-- /.box-header -->
          <!-- form start -->
          <?php $this->load->helper("form"); ?>
          <?php if (isset($organizationInfo['id'])) { ?>
            <form role="form" id="addOrganization" action="<?php echo base_url('updateorganization') ?>" method="post" role="form">
            <?php } else { ?>
              <form role="form" id="addOrganization" action="<?php echo base_url('organization') ?>" method="post" role="form">
              <?php } ?>
              <div class="box-body">
                <div class="row">
                  <div class="col-md-12">
                    <div class="form-group">
                      <label for="fname">Location Name</label>
                      <select class="form-control" name="location_id" id="location_id"  onchange="getClient(this)">
                        <option value="">Select Location</option>
                        <?php if (!empty($locationList)) { ?>
                          <?php foreach ($locationList as $loc) { ?>
                            <option <?php
                            if ($organizationInfo['loc_id'] == $loc['loc_id']) {
                              echo 'selected';
                            }
                            ?> value="<?php echo $loc['loc_id'] ?>"><?php echo $loc['loc_name'] ?></option>
                            <?php } ?>
                          <?php } ?>
                      </select>
                    </div>

                    <div class="form-group">
                      <label for="fname">Client Name*</label>
                      <select class="form-control" name="client_id[]" id="client_id" required="" multiple="">
                        <option value="">Select Client</option>
                        <?php if (!empty($clientList)) { ?>
                          <?php foreach ($clientList as $key => $client) { ?>
                            <option  <?php
                            if (in_array($client['id'], explode(',', $organizationInfo['client_id']))) {
                              echo "selected=selected";
                            }
                            ?>  value="<?php echo $client['id'] ?>"> <?php echo $client['client']; ?></option>>
                            <?php } ?>
                          <?php } ?>
                      </select>
                    </div>
                    <div class="form-group">
                      <label for="fname">Warehouse Name</label>
                      <input type="text" value="<?php echo isset($organizationInfo['org_name']) ? $organizationInfo['org_name'] : ''; ?>" class="form-control required" value="<?php echo set_value('orgname'); ?>" id="orgname" name="orgname" maxlength="128">
                    </div>

                    <div class="form-group">
                      <label for="fname">Warehouse Code</label>
                      <input type="text" value="<?php echo isset($organizationInfo['org_code']) ? $organizationInfo['org_code'] : ''; ?>" class="form-control required" value="<?php echo set_value('org_code'); ?>" id="org_code" name="org_code" maxlength="128">
                    </div>

                  </div>

                </div>

              </div><!-- /.box-body -->

              <div class="box-footer">
                <input type="submit" class="btn btn-primary" value="<?php echo isset($organizationInfo['id']) ? 'Update' : 'Add'; ?>" />
                <input type="reset" class="btn btn-default" value="Reset" />
                <input type="hidden" name="organization_id" value="<?php echo isset($organizationInfo['id']) ? $organizationInfo['id'] : ''; ?>">
              </div>
            </form>
        </div>
      </div>
      <div class="col-md-6">
        <div class="box box-primary">
          <table class="table" id="orgtbl">
            <thead>
              <tr>
                <th>Id</th>
                <th>Warehouse Name</th>
                <th>Warehouse Code</th>
                <th>Client Name</th>
                <th>Location Name</th>
                <th>Action</th>
              </tr>
            </thead>
            <tbody>
              <?php if (!empty($organizationList)) { ?>
                <?php foreach ($organizationList as $key => $org) { ?>
                  <tr>
                    <td><?php echo ucfirst($org['id']); ?></td>
                    <td><?php echo ucfirst($org['org_name']); ?></td>
                    <td><?php echo ucfirst($org['org_code']); ?></td>
                    <?php echo clientsList($org['client_id']); ?>
                    <td><?php echo ucfirst($org['loc_name']); ?></td>
                    <td style="width: 20%"><a href="<?php echo site_url('organization/' . $org['id']); ?>" class="btn btn-sm btn-primary"><i class="fa fa-pencil-square-o" aria-hidden="true"></i></a><a onclick="return confirm('Are you sure')" href="<?php echo site_url('delorganization/' . $org['id']); ?>" style="margin-left:5px" class="btn btn-sm btn-danger"><i class="fa fa-trash" aria-hidden="true"></i></a>
    <!--                      <form style="margin: 5px;display: inline;" data-toggle="tooltip" data-placement="right" title="Download ManPower" action="<?php echo base_url(); ?>/downloademployee" method="POST" id="usersearchform"><input type="hidden" name = "organization_id" value="<?php echo $org['id']; ?>"><button type="submit" class="btn btn-warning searchList">Download</button></form>-->
                    </td>
                  </tr>
                <?php } ?>
              <?php } ?>

            </tbody>
          </table>
        </div>
      </div>

    </div>
  </section>

</div>
<script src="<?php echo base_url(); ?>assets/js/addUser.js" type="text/javascript"></script>
<script type="text/javascript">
                  jQuery(document).ready(function () {
//                    $("#orgtbl").DataTable().destroy();
                    $("#orgtbl").DataTable({
                      "columnDefs": [
                        {"className": "dt-center", "targets": "_all"}
                      ],
                      "ordering": false,
                      "processing": true,
                      "serverSide": false,
                      "searching": true,
                    });
                  });

                  $("#client_id").select2({
                    tags: true,
                    placeholder: 'Select Clients',
                    tokenSeparators: [',']
                  });
                  $("#location_id").select2({
                  });

</script>