<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1><i class="fa fa-user-circle"></i> Manpower Report <small>Teams Listing</small></h1>
    </section>
    <form>
        <section class="content">

            <div class="row">               
                <div class="col-lg-12 col-xs-12">
                        <?php if ($this->session->flashdata('message')) { 
                            echo $this->session->flashdata('message');
                        } ?>
                    <table class="table table-striped listingtable" id="manpower_teams_listing_tbl">
                        <thead>
                            <tr class="listingtable-head">
                                <th>Date</th>
                                <th>Department</th>
                                <th>Shift</th>
                                <th>Average Performance</th>
                                <th>Members</th>
                                <th>Action</th>
                            </tr>

                        </thead>
                        <tbody>
                            <?php $index_counter = 0; foreach ($all_teams as $team) { ?>
                            <tr>
                                <td>
                                    <?php echo $team->date; ?>
                                </td>
                                <td>
                                    <?php echo $team->department_name; ?>
                                </td>
                                <td>
                                    <?php echo $team->shift; ?>
                                </td>
                                <td>N</td>
                                <td><button type="button" onclick="get_employees_from_team_id('<?php echo $team->id; ?>');" class="btn btn-success">View Employees</button></td>
                                <td>
                                    <?php if (!$team->performance_already_exists) { ?>
                                        <button type="button" onclick="get_add_performance_form('<?php echo $team->id; ?>');" class="btn btn-success">Add Performance</button>                                       
                                    <?php } ?>

                                    <?php if ($team->performance_already_exists) { ?>
                                        <button type="button" onclick="view_performance_stats('<?php echo $team->id; ?>');" class="btn btn-success">View Performance</button>
                                    <?php } ?>
                                </td>
                            </tr>
                            <?php $index_counter++; } ?>
                        </tbody>
                    </table>
                </div>
            </div>

        </section>
    </form>
</div>

<div class="modal fade" id="employees_modal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title" id="myModalLabel">List of employees in team</h4>
            </div>
            <div class="modal-body" id="employees_modal_table"></div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="add_performance_modal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title" id="myModalLabel">Add Performance</h4>
            </div>
            <div class="modal-body" id="add_performance_body"></div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="view_performance_modal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title" id="myModalLabel">Performance</h4>
                </div>
                <div class="modal-body" id="view_performance_body"></div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>

<script src="<?php echo base_url(); ?>assets/js/manpower_teams_list.js" type="text/javascript"></script>