<div class="content-wrapper">
  <!-- Content Header (Page header) -->
  <section class="content-header">
    <h1>
      <i class="fa fa-users"></i> Location Management
      <small>Add / Edit Location</small>
    </h1>
  </section>

  <section class="content">
    <div class="row">
      <div class="col-md-12">
        <?php
        $error = $this->session->flashdata('error');
        if ($error) {
          ?>
          <div class="alert alert-danger alert-dismissable">
            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
            <?php echo $this->session->flashdata('error'); ?>
          </div>
        <?php } ?>
        <?php
        $success = $this->session->flashdata('success');
        if ($success) {
          ?>
          <div class="alert alert-success alert-dismissable">
            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
            <?php echo $this->session->flashdata('success'); ?>
          </div>
        <?php } ?>
      </div>
    </div>
    <div class="row">
      <!-- left column -->
      <div class="col-md-6">
        <!-- general form elements -->
        <div class="box box-primary">
          <div class="box-header">
            <h3 class="box-title">Location Details</h3>
          </div><!-- /.box-header -->
          <!-- form start -->
          <?php $this->load->helper("form"); ?>
          <?php if (isset($locationInfo['loc_id'])) { ?>
            <form role="form" id="addLocation" action="<?php echo base_url('location/') . $locationInfo['loc_id'] ?>" method="post" role="form">
            <?php } else { ?>
              <form role="form" id="addLocation" action="<?php echo base_url('location') ?>" method="post" role="form">
              <?php } ?>
              <div class="box-body">
                <div class="row">
                  <div class="col-md-6">
                    <!--                                        <div class="form-group">
                                                                <label for="fname">Client Name*</label>
                                                                <select class="form-control" name="client_id" required="">
                                                                    <option value="">Select Client</option>
                    <?php if (!empty($clientList)) { ?>
                      <?php foreach ($clientList as $key => $client) { ?>
                                                                                                                                    <option <?php
                        if (isset($locationInfo['client_id']) && ($locationInfo['client_id'] == $client['id'])) {
                          echo 'selected';
                        }
                        ?> value="<?php echo $client['id'] ?>"> <?php echo $client['client']; ?></option>>
                      <?php } ?>
                    <?php } ?>
                                                                </select>
                                                            </div>-->

                    <div class="form-group">
                      <label for="fname">Location Name</label>
                      <input type="text" value="<?php echo isset($locationInfo['loc_name']) ? $locationInfo['loc_name'] : ''; ?>" class="form-control required" value="<?php echo set_value('loc_name'); ?>" id="loc_name" name="loc_name" maxlength="128">
                    </div>
                    <div class="form-group">
                      <label for="fname">Location Code</label>
                      <input type="text" value="<?php echo isset($locationInfo['loc_code']) ? $locationInfo['loc_code'] : ''; ?>" class="form-control required" value="<?php echo set_value('loc_code'); ?>" id="loc_name" name="loc_code" maxlength="128">
                    </div>

                  </div>

                </div>

              </div><!-- /.box-body -->

              <div class="box-footer">
                <input type="submit" class="btn btn-primary" value="<?php echo isset($locationInfo['loc_id']) ? 'Update' : 'Add'; ?>" />
                <input type="reset" class="btn btn-default" value="Reset" />
                <input type="hidden" name="location_id" value="<?php echo isset($locationInfo['loc_id']) ? $locationInfo['loc_id'] : ''; ?>">
              </div>
            </form>
        </div>
      </div>
      <div class="col-md-6">
        <div class="box box-primary">
          <table class="table" id="locationltbl">
            <thead>
              <tr>
                <th>Location Name</th>
                <th>Location Code</th>
<!--                <th>Client Name</th>-->
                <th>Action</th>
              </tr>
            </thead>
            <tbody>
              <?php if (!empty($locationList)) { ?>
                <?php foreach ($locationList as $key => $loc) { ?>
                  <tr>
                    <td><?php echo ucfirst($loc['loc_name']); ?></td>
                    <td><?php echo ucfirst($loc['loc_code']); ?></td>
                    <!--<td><?php echo ucfirst($loc['client_name']); ?></td>-->
                    <td><a href="<?php echo site_url('location/' . $loc['loc_id']); ?>" class="btn btn-sm btn-primary"><i class="fa fa-pencil-square-o" aria-hidden="true"></i></a><a onclick="return confirm('Are you sure')" href="<?php echo site_url('dellocation/' . $loc['loc_id']); ?>" style="margin-left:5px" class="btn btn-sm btn-danger"><i class="fa fa-trash" aria-hidden="true"></i></a></td>
                  </tr>
                <?php } ?>
              <?php } ?>

            </tbody>
          </table>
        </div>
      </div>

    </div>
  </section>

</div>
<script src="<?php echo base_url(); ?>assets/js/addUser.js" type="text/javascript"></script>
<script src="<?php echo base_url(); ?>assets/js/addUser.js" type="text/javascript"></script>
<script type="text/javascript">
                  jQuery(document).ready(function () {
                    $("#locationltbl").DataTable().destroy();
                    $("#locationltbl").DataTable({
                      "columnDefs": [
                        {"className": "dt-center", "targets": "_all"}
                      ],
                      "ordering": false,
                      "processing": true,
                      "serverSide": false,
                      "searching": true,
                    });
                  });
                  $("#client").select2({
                  });


</script>