<?php

if (!defined('BASEPATH'))
  exit('No direct script access allowed');

/**
 * Class : User_model (User Model)
 * User model class to get to handle user related data
 * @author : Vijayraj Chaudhary
 * @version : 2.1
 * @since : 15 November 2019
 */
class SupervisorMngt_model extends CI_Model {

  function getSubDeptMngtInfo($subDeptMngtId = '') {
    $this->db->select('tbl_sub_dept_mngt.*,tbl_clients.client,tbl_sub_departments.id,tbl_sub_departments.sub_dept_name,tbl_shift.shift_name,shift_mgmt.shift');
    $this->db->from('tbl_sub_dept_mngt');
    $this->db->where('tbl_sub_departments.isDeleted', '0');
    $this->db->where('tbl_sub_departments.id', $subDeptMngtId);
    $this->db->not_like('tbl_sub_departments.sub_dept_name', 'FTU');
    $this->db->join('tbl_sub_departments', 'tbl_sub_departments.id = tbl_sub_dept_mngt.sub_dept_id', 'left');
    $this->db->join('shift_mgmt', 'shift_mgmt.id = tbl_sub_dept_mngt.shift_mngt_id', 'left');
    $this->db->join('tbl_shift', 'tbl_shift.id = shift_mgmt.shift', 'left');
    $this->db->join('tbl_clients', 'tbl_clients.id = tbl_sub_dept_mngt.client_id', 'left');
    $result = $this->db->get()->row_array();
    return $result;
  }

  function getShiftListBySubDeptId($subDeptId = '') {
    $this->db->where('shift_mgmt.isDeleted', '0');
    $this->db->where('shift_mgmt.sub_dept_id', $subDeptId);
    $this->db->select('shift_mgmt.*,tbl_shift.shift_name');
    $this->db->join('tbl_shift', 'tbl_shift.id = shift_mgmt.shift', 'left');
    return $this->db->get('shift_mgmt')->result_array();
  }

}
