<?php

if (!defined('BASEPATH'))
  exit('No direct script access allowed');

require APPPATH . '/libraries/BaseController.php';

/**
 * Class : User (UserController)
 * User Class to control all user related operations.
 * @author : Vijayraj Chaudhary
 * @version : 2.1
 * @since : 15 November 2019
 */
class User extends BaseController {

  /**
   * This is default constructor of the class
   */
  public function __construct() {
    parent::__construct();
    $this->load->model('user_model');
    $this->isLoggedIn();
    date_default_timezone_set('Asia/Kolkata');
  }

  /**
   * This function used to load the first screen of the user
   */
  public function index() {
    $this->global['pageTitle'] = 'Searbird : Dashboard';
    $userId = $this->session->userdata('userId');
    $data['userInfo'] = $this->user_model->getUserInfo($userId);
    if (!empty($data['userInfo'])) {
      $reportingManager = $data['userInfo']->reporting_manager;
      $data['userInfo']->reporting_manager_name = $this->user_model->getUserName($reportingManager);
    }
    if ($this->role == '1') {
      $data['totaluser'] = $this->user_model->userListingCount('', '', '', '');
      $data['visitors'] = $this->user_model->gettotalvisitor();
      $data['supportTickets'] = $this->user_model->getsupporticket();
      $data['warehouse'] = count($this->user_model->getOrganizationList());
      $this->loadViews("admindashboard", $this->global, $data, NULL);
    } else {
      $this->loadViews("dashboard", $this->global, $data, NULL);
    }
  }

  function view($empid = '') {

    $employeeInfo = $this->user_model->getUserInfo($empid);

    if (!empty($employeeInfo)) {
      $employeeInfo->reportingManager = $this->user_model->getUserName($employeeInfo->reporting_manager);
    }
    $data['employeeinfo'] = $employeeInfo;
    $this->global['pageTitle'] = 'Searbird : Employee';
    $this->loadViews("employee_view", $this->global, $data, NULL);
  }

  /**
   * This function is used to load the user list
   */
  function userListing() {
    if (in_array($this->role, ['1', '2', '5', '8', '9', '10', '11', '12'])) {
      $orgId = '';
      if ($this->role == '2' || $this->role == '8') {
        $orgId = $this->organization_id;
      }
      $organizationList = $this->user_model->getOrganizationList($orgId, $withManPowerCount = '1');
      $fOrganizationId = isset($organizationList[0]['id']) ? $organizationList[0]['id'] : '';
      $searchText = $this->security->xss_clean($this->input->post('searchText'));
      $empsearchText = $this->security->xss_clean($this->input->post('emp_id'));
      $empId = '';
      $empCode = '';
      $empName = '';
      $deptId = '';
      if ($this->input->post('organization_id')) {
        $fOrganizationId = $this->security->xss_clean($this->input->post('organization_id'));
      }
      if ($this->input->post('department_id')) {
        $deptId = $this->input->post('department_id');
      }
      $emailId = $this->security->xss_clean($this->input->post('emp_email'));
      if ($empsearchText != '') {
        $emparray = explode('_', $empsearchText);
        $empId = isset($emparray[0]) ? $emparray[0] : '';
        $empCode = isset($emparray[1]) ? $emparray[1] : '';
        $empName = isset($emparray[2]) ? $emparray[2] : '';
      }

      $data['searchText'] = $searchText;

      $data['empsearchText'] = $empsearchText;

      $data['emailId'] = $emailId;

      $data['fOrganizationId'] = $fOrganizationId;

      $data['deptId'] = $deptId;

      $this->load->library('pagination');

      $count = $this->user_model->userListingCount($empName, $empCode, $emailId, $fOrganizationId, $deptId);

      $returns = $this->paginationCompress("userListing/", $count, 10);

      $data['userRecords'] = $this->user_model->userListing($empName, $returns["page"], $returns["segment"], $empCode, $emailId, $fOrganizationId, $deptId);

      $data['organizationList'] = $organizationList;

      $data['departmentlist'] = $this->user_model->getMainDepartmentList($fOrganizationId, '', $withEmpCount = '1');

      $this->global['pageTitle'] = 'Searbird : Employee Listing';

      $this->loadViews("users", $this->global, $data, NULL);
    } else {
      $this->loadThis();
    }
  }

  function users() {
    if ($this->role == '1' || $this->role == '8' || $this->role == '9' || $this->role == '10' || $this->role == '11') {
      $orgId = '';
      if ($this->role == '2') {
        $orgId = $this->organization_id;
      }
      $organizationList = $this->user_model->getOrganizationList($orgId, $withManPowerCount = '1');
      $fOrganizationId = isset($organizationList[0]['id']) ? $organizationList[0]['id'] : '';
      $searchText = $this->security->xss_clean($this->input->post('searchText'));
      $empsearchText = $this->security->xss_clean($this->input->post('emp_id'));
      $empId = '';
      $empCode = '';
      $empName = '';
      $deptId = '';
      if ($this->input->post('organization_id')) {
        $fOrganizationId = $this->security->xss_clean($this->input->post('organization_id'));
      }
      if ($this->input->post('department_id')) {
        $deptId = $this->input->post('department_id');
      }
      $emailId = $this->security->xss_clean($this->input->post('emp_email'));
      if ($empsearchText != '') {
        $emparray = explode('_', $empsearchText);
        $empId = isset($emparray[0]) ? $emparray[0] : '';
        $empCode = isset($emparray[1]) ? $emparray[1] : '';
        $empName = isset($emparray[2]) ? $emparray[2] : '';
      }

      $data['searchText'] = $searchText;

      $data['empsearchText'] = $empsearchText;

      $data['emailId'] = $emailId;

      $data['fOrganizationId'] = $fOrganizationId;

      $data['deptId'] = $deptId;

      $this->load->library('pagination');

      $count = $this->user_model->userListingCount($empName, $empCode, $emailId, $fOrganizationId, $deptId);

      $returns = $this->paginationCompress("userListing/", $count, 10);

      $data['userRecords'] = $this->user_model->userListing($empName, $returns["page"], $returns["segment"], $empCode, $emailId, $fOrganizationId, $deptId, $byRole = '9');

      $data['organizationList'] = $organizationList;

      $this->global['pageTitle'] = 'Searbird : Employee Listing';

      $this->loadViews("user_staff/users_staff", $this->global, $data, NULL);
    } else {
      $this->loadThis();
    }
  }

  function downloadEmployee() {
    $empsearchText = $this->input->post('emp_id');
    $empId = '';
    $empCode = '';
    $empName = '';
    if ($empsearchText != '') {
      $emparray = explode('_', $empsearchText);
      $empId = isset($emparray[0]) ? $emparray[0] : '';
      $empCode = isset($emparray[1]) ? $emparray[1] : '';
      $empName = isset($emparray[2]) ? $emparray[2] : '';
    }

    $emp_email = $this->input->post('emp_email');
    $organization_id = $this->input->post('organization_id');
    $department_id = $this->input->post('department_id');
    $this->db->select('BaseTbl.userId,BaseTbl.emp_id,organization.org_name,dpt.dept_name,BaseTbl.email, BaseTbl.name, BaseTbl.mobile, BaseTbl.createdDtm, Role.role,BaseTbl.emp_id,BaseTbl.designation,BaseTbl.skills,BaseTbl.emp_code,BaseTbl.doj,BaseTbl.reporting_manager,reptmng.name reporting_manager_name');
    $this->db->from('tbl_users as BaseTbl');
    $this->db->join('tbl_roles as Role', 'Role.roleId = BaseTbl.roleId', 'left');
    $this->db->join('tbl_organization as organization', 'organization.id = BaseTbl.organization_id', 'left');
    $this->db->join('tbl_departments as dpt', 'dpt.dept_id = BaseTbl.department_id', 'left');
    $this->db->join('tbl_users as reptmng', 'reptmng.userId = BaseTbl.reporting_manager', 'LEFT');
    if ($this->role != 1) {
      $this->db->where('BaseTbl.organization_id', $this->organization_id);
    }
    if ($organization_id != '') {
      $this->db->where('BaseTbl.organization_id', $organization_id);
    }
    if ($department_id != '') {
      $this->db->where('BaseTbl.department_id', $department_id);
    }
    // echo $this->role;die;
    if ($this->role == 9) {
      $this->db->where('BaseTbl.createdBy', $this->userId);
    }
    if ($emp_email != '') {
      $this->db->like('BaseTbl.email', $emp_email);
    }
    if (!empty($empName)) {
      $likeCriteria = "(BaseTbl.email  LIKE '%" . $empName . "%'
                            OR  BaseTbl.name  LIKE '%" . $empName . "%'
                            OR  BaseTbl.mobile  LIKE '%" . $empName . "%')";
      $this->db->where($likeCriteria);
    }
//    if (!empty($empCode)) {
//      $likeCriteria = "(BaseTbl.emp_id  LIKE '%" . $empCode . "%')";
//      $this->db->or_where($likeCriteria);
//    }
    $this->db->where('BaseTbl.isDeleted', 0);
    $this->db->where('BaseTbl.roleId !=', 1);
    if (!empty($this->input->post('role_id')) && $this->input->post('role_id') != '') {
      $this->db->where('BaseTbl.roleId =', $this->input->post('role_id'));
    } else {
      $this->db->where('BaseTbl.roleId =', 3);
    }

    $this->db->order_by('BaseTbl.userId', 'DESC');
    $query = $this->db->get();
    $results = $query->result();
    $this->load->library('excel');
    $this->excel->setActiveSheetIndex(0);
    $this->excel->getActiveSheet()->setTitle('Employees List');
    $this->excel->getActiveSheet()->setCellValue('A1', 'Reg Number')->getStyle('A1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('B1', 'Employee Code')->getStyle('B1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('C1', 'Name')->getStyle('C1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('D1', 'Email')->getStyle('D1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('E1', 'Mobile')->getStyle('E1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('F1', 'Role')->getStyle('F1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('G1', 'Warehouse')->getStyle('G1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('H1', 'Department')->getStyle('H1')->getFont()->setBold(true);
//    $this->excel->getActiveSheet()->setCellValue('I1', 'Date of joining')->getStyle('I1')->getFont()->setBold(true);
    //$this->excel->getActiveSheet()->setCellValue('J1', 'Report To')->getStyle('J1')->getFont()->setBold(true);

    if (!empty($results)) {
      foreach ($results as $key => $userinfo) {
        $excelrow = $key + 2;
        $this->excel->getActiveSheet()->setCellValue('A' . $excelrow, '#' . sprintf("%'.07d\n", $userinfo->userId));
        $this->excel->getActiveSheet()->setCellValue('B' . $excelrow, $userinfo->emp_code);
        $this->excel->getActiveSheet()->setCellValue('C' . $excelrow, $userinfo->name);
        $this->excel->getActiveSheet()->setCellValue('D' . $excelrow, $userinfo->email);
        $this->excel->getActiveSheet()->setCellValue('E' . $excelrow, $userinfo->mobile);
        $this->excel->getActiveSheet()->setCellValue('F' . $excelrow, $userinfo->role);
        $this->excel->getActiveSheet()->setCellValue('G' . $excelrow, $userinfo->org_name);
        $this->excel->getActiveSheet()->setCellValue('H' . $excelrow, $userinfo->dept_name);

//        if ($userinfo->doj != '0000-00-00') {
//          $$doj = isset($userinfo->doj) ? date('d-m-Y', strtotime($userinfo->doj)) : '';
//          $this->excel->getActiveSheet()->setCellValue('I' . $excelrow, $doj);
//        } else {
//          $this->excel->getActiveSheet()->setCellValue('I' . $excelrow, '');
//        }
        //$manager = isset($userinfo->reporting_manager_name) ? ucfirst($userinfo->reporting_manager_name) : '';
        //$this->excel->getActiveSheet()->setCellValue('J' . $excelrow, $manager);
      }
    }
    $filename = 'Employeeslisting.xls';

    header('Content-Type: application/vnd.ms-excel'); //mime type
    header('Content-Disposition: attachment;filename="' . $filename . '"'); //tell browser what's the file name
    header('Cache-Control: max-age=0'); //no cache
    //save it to Excel5 format (excel 2003 .XLS file), change this to 'Excel2007' (and adjust the filename extension, also the header mime type)
    //if you want to save it as .XLSX Excel 2007 format
    $objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');
    //force user to download the Excel file without writing it to server's HD
    $objWriter->save('php://output');
    exit;
    die;
  }

  function getdeptemployee() {

    error_reporting(-1);
    if (!$this->input->is_ajax_request()) {
      exit('No direct script access allowed');
    }

    $deptId = $this->input->post('deptId');

    $this->db->select('userId,emp_code,name');
    $this->db->where('department_id', $deptId);
    $this->db->where('isDeleted', '0');
    $results = $this->db->get('tbl_users')->result_array();
    echo json_encode($results);
  }

  function getuserajaxlisting() {
    if (!$this->input->is_ajax_request()) {
      exit('No direct script access allowed');
    }
    if ($this->input->post("roleId")) {
      $roleId = intval($this->input->post("roleId"));
    }

    $draw = intval($this->input->post("draw"));
    $start = intval($this->input->post("start"));
    $length = intval($this->input->post("length"));
    $search = $this->input->post('search[value]');


    $empsearchText = $this->input->post('emp_id');
    $empId = '';
    $empCode = '';
    $empName = '';
    if ($empsearchText != '') {
      $emparray = explode('_', $empsearchText);
      $empId = isset($emparray[0]) ? $emparray[0] : '';
      $empCode = isset($emparray[1]) ? $emparray[1] : '';
      $empName = isset($emparray[2]) ? $emparray[2] : '';
    }

    if ($search != '') {
      //$emparray = explode('_', $empsearchText);
      $empId = isset($search) ? $search : '';
      $empCode = isset($search) ? $search : '';
      $empName = isset($search) ? $search : '';
    }

    $emp_email = $this->input->post('emp_email');
    $organization_id = $this->input->post('organization_id');
    $department_id = $this->input->post('department_id');

    $this->db->select('BaseTbl.userId,BaseTbl.emp_id,organization.org_name,dpt.dept_name,BaseTbl.email, BaseTbl.name, BaseTbl.mobile, BaseTbl.createdDtm, Role.role,BaseTbl.emp_id,BaseTbl.designation,BaseTbl.skills,BaseTbl.emp_code,BaseTbl.doj,BaseTbl.reporting_manager,reptmng.name reporting_manager_name');
    $this->db->from('tbl_users as BaseTbl');
    $this->db->where('BaseTbl.isDeleted', 0);
    $this->db->join('tbl_roles as Role', 'Role.roleId = BaseTbl.roleId', 'left');
    $this->db->join('tbl_organization as organization', 'organization.id = BaseTbl.organization_id');
    $this->db->join('tbl_departments as dpt', 'dpt.dept_id = BaseTbl.department_id', 'left');
    $this->db->join('tbl_users as reptmng', 'reptmng.userId = BaseTbl.reporting_manager', 'LEFT');
    if ($this->role != 1) {
      $this->db->where('BaseTbl.organization_id', $this->organization_id);
    }
    if ($this->role == 9) {
    //   pre($this->session->userdata('userId'));
      $this->db->where('BaseTbl.createdBy', $this->session->userdata('userId'));
    }

//    if ($organization_id != '') {
//      $this->db->where('BaseTbl.organization_id', $organization_id);
//    }
    if ($department_id != '') {
      $this->db->where('BaseTbl.main_dept_id ', $department_id);
    }
    if ($emp_email != '') {
      $this->db->like('BaseTbl.email', $emp_email);
    }
    if (!empty($empName)) {
      $likeCriteria = "(BaseTbl.email  LIKE '%" . $empName . "%'
                            OR  BaseTbl.name  LIKE '%" . $empName . "%'
                            OR  BaseTbl.mobile  LIKE '%" . $empName . "%')";
      $this->db->where($likeCriteria);
    }
//    if (!empty($empCode)) {
//      $likeCriteria = "(BaseTbl.emp_id  LIKE '%" . $empCode . "%')";
//      $this->db->or_where($likeCriteria);
//    }

    if ($roleId) {
      $this->db->where('BaseTbl.roleId =', $roleId);
    } else {
      $this->db->where('BaseTbl.roleId =', 3);
    }
    $this->db->where('BaseTbl.isDeleted', 0);
    $this->db->where('BaseTbl.roleId !=', 1);
    $query = $this->db->get();
    $totalrows = $query->num_rows();
    //echo $this->db->last_query();

    $this->db->select('BaseTbl.userId,BaseTbl.emp_id,organization.org_name,BaseTbl.client_id,BaseTbl.main_department,dpt.dept_name,BaseTbl.email,BaseTbl.username, BaseTbl.name, BaseTbl.mobile, BaseTbl.createdDtm, Role.role,BaseTbl.emp_id,BaseTbl.designation,BaseTbl.skills,BaseTbl.emp_code,BaseTbl.doj,BaseTbl.reporting_manager,reptmng.name reporting_manager_name');
    $this->db->from('tbl_users as BaseTbl');
    $this->db->where('BaseTbl.isDeleted', 0);
    $this->db->join('tbl_roles as Role', 'Role.roleId = BaseTbl.roleId', 'left');
    $this->db->join('tbl_organization as organization', 'organization.id = BaseTbl.organization_id', 'left');
    $this->db->join('tbl_departments as dpt', 'dpt.dept_id = BaseTbl.department_id', 'left');
    //$this->db->join('tbl_departments as main_dpt', 'main_dpt.dept_id = BaseTbl.main_dept_id', 'left');
    $this->db->join('tbl_users as reptmng', 'reptmng.userId = BaseTbl.reporting_manager', 'LEFT');
    if ($this->role != 1) {
      $this->db->where('BaseTbl.organization_id', $this->organization_id);
    }
    if ($this->role == 9) {
    //   pre($this->session->userdata('userId'));
      $this->db->where('BaseTbl.createdBy', $this->session->userdata('userId'));
    }
//    if ($organization_id != '') {
//      $this->db->where('BaseTbl.organization_id', $organization_id);
//    }
    if ($department_id != '') {
      $this->db->where('BaseTbl.main_dept_id ', $department_id);
    }
    if ($emp_email != '') {
      $this->db->like('BaseTbl.email', $emp_email);
    }
    if (!empty($empName)) {
      $likeCriteria = "(BaseTbl.email  LIKE '%" . $empName . "%'
                            OR  BaseTbl.name  LIKE '%" . $empName . "%'
                            OR  BaseTbl.mobile  LIKE '%" . $empName . "%')";
      $this->db->where($likeCriteria);
    }
//    if (!empty($empCode)) {
//      $likeCriteria = "(BaseTbl.emp_id  LIKE '%" . $empCode . "%')";
//      $this->db->or_where($likeCriteria);
//    }
    $this->db->where('BaseTbl.isDeleted', 0);
    $this->db->where('BaseTbl.roleId !=', 1);
    if ($roleId) {
      $this->db->where('BaseTbl.roleId =', $roleId);
    } else {
      $this->db->where('BaseTbl.roleId =', 3);
    }
    $this->db->order_by('BaseTbl.userId', 'DESC');
    $this->db->limit($length, $start);
    $query = $this->db->get();
    //$totalrows = $query->num_rows();

    $results = $query->result();
//    echo $this->db->last_query();
//    die;
    $data = array();

    if (!empty($results)) {
      foreach ($results as $key => $userinfo) {
//        pre($userinfo);

        $attr = array();
        $attr[] = '#' . sprintf("%'.07d\n", $userinfo->userId);
        $attr[] = $userinfo->name;
        if ($userinfo->role != 'Employee') {
          $attr[] = $userinfo->username;
        }
        $attr[] = $userinfo->email;
        $attr[] = $userinfo->mobile;
        $attr[] = $userinfo->role;
        if (!in_array($userinfo->role, ['Supervisor', 'HR'])) {
          $attr[] = $userinfo->org_name;
          $clientArray = $this->user_model->getClientByClientId($userinfo->client_id);
          $clients = '';
//        $cArray = explode('~', $userinfo->store_client_name);

          foreach ($clientArray as $client) {
            $clients .= $client['client'] . '<br>';
//          die;
          }
          if ($userinfo->role != 'Supervisor' && $userinfo->role != 'Employee') {
            $attr[] = $clients;
          }
        }
        if (!$roleId) {
//          $attr[] = $userinfo->main_department;
        }
        if ($userinfo->doj != '0000-00-00') {
//          $attr[] = isset($userinfo->doj) ? date('d-m-Y', strtotime($userinfo->doj)) : '';
        } else {
//          $attr[] = '';
        }
        if (!$roleId && $userinfo->role != 'Employee') {
          $attr[] = isset($userinfo->reporting_manager_name) ? ucfirst($userinfo->reporting_manager_name) : '';
        }
        if ($userinfo->role != 'Employee') {
          $attr[] = ''
//                  . ' <a href="' . site_url('employee/view/' . $userinfo->userId) . '" class="btn btn-sm btn-default"><i class="fa fa-eye"></i></a>'
                  . '
                            <a class="btn btn-sm btn-primary" href="' . base_url() . 'edit-user-staff/' . $userinfo->userId . '" title="Edit"><i class="fa fa-pencil"></i></a>
                            <a class="btn btn-sm btn-danger deleteUser" href="#" data-userid="' . $userinfo->userId . '" title="Delete"><i class="fa fa-trash"></i></a>';
        } elseif ($userinfo->role == 'Employee') {
          $attr[] = ' <a href="' . site_url('employee/view/' . $userinfo->userId) . '" class="btn btn-sm btn-default"><i class="fa fa-eye"></i></a>
                            <a class="btn btn-sm btn-primary" href="' . base_url() . 'editOld/' . $userinfo->userId . '" title="Edit"><i class="fa fa-pencil"></i></a>
                            <a class="btn btn-sm btn-danger deleteUser" href="#" data-userid="' . $userinfo->userId . '" title="Delete"><i class="fa fa-trash"></i></a>';
        } else {
          $attr[] = '<a class="btn btn-sm btn-primary" href="' . base_url() . 'editOld/' . $userinfo->userId . '" title="Edit"><i class="fa fa-pencil"></i></a>';
        }

        $data[] = $attr;
      }
    }

    $output = array(
        "draw" => $draw,
        "recordsTotal" => $totalrows,
        "recordsFiltered" => $totalrows,
        "data" => $data
    );
    echo json_encode($output);
    exit();
  }

  function userAttendance() {

    $userId = $this->session->userdata('userId');
    $data['attendance'] = $this->user_model->getTodayLoginDetail($userId);
    $data['userId'] = $userId;
    $organizationList = $this->user_model->getOrganizationList();
    $data['organizationList'] = $organizationList;
    $this->global['pageTitle'] = 'Searbird : Attendance';
    $this->loadViews("attendance", $this->global, $data, NULL);
  }

  function updateattendancestatus() {
    if (!$this->input->is_ajax_request()) {
      exit('No direct script access allowed');
    }
    $userId = $this->input->post('userId');
    $status = $this->input->post('status');
    $attendanceStatus = $this->user_model->checktodayattendance($userId, $status);
    if (!$attendanceStatus) {
      $date = date('Y-m-d H:i:s');
      if ($status == 'in') {
        $chklastsignout = $this->user_model->checklastsignout($userId);
        $outdatetime = date('Y-m-d H:i:s', strtotime($date) - 1);

        if ($chklastsignout) {
          $this->db->insert('tbl_attendances', ['user_id' => $userId, 'type' => 'out', 'created_at' => $outdatetime, 'updated_at' => $outdatetime]);
        }
      }


      $this->db->insert('tbl_attendances', ['user_id' => $userId, 'type' => $status, 'created_at' => $date, 'updated_at' => $date]);
      $result['datetime'] = $date;
      $result['date'] = date('d/m/Y', strtotime($date));
      $result['time'] = date('H:i:s', strtotime($date));
      echo json_encode($result);
      exit;
    }
    echo json_encode('');
    exit;
  }

  public function downloademployeeattendance() {
    $userId = $this->input->post('selectempid');
    $startdate = $this->input->post('attandance_start_date');
    $endate = $this->input->post('attandance_end_date');
    if ($startdate != '') {
      $startdate = date('Y-m-d', strtotime($startdate));
    }
    if ($endate != '') {
      $endate = date('Y-m-d', strtotime($endate));
    }

    $this->db->select('DATE(created_at) as date,created_at,tbl_users.emp_id,tbl_users.name');
    $this->db->order_by('created_at', 'DESC');
    $this->db->where('user_id', $userId);
    if ($start_date != '') {
      $this->db->where('tbl_attendances.created_at >=', $start_date);
    }
    if ($end_date != '') {
      $this->db->where('tbl_attendances.created_at <=', $end_date);
    }
    $this->db->join('tbl_users', 'tbl_users.userId=tbl_attendances.user_id');
    $this->db->from('tbl_attendances');
    $this->db->group_by('date');
    $query = $this->db->get();
    $results = $query->result_array();

    $file_name = 'csv_' . time() . '.csv';
    header("Content-Type: text/csv");
    header("Content-Disposition: attachment; filename=$file_name");
    header("Cache-Control: no-cache, no-store, must-revalidate");
    header("Pragma: no-cache");
    header("Expires: 0");
    $output = fopen("php://output", "w");
    fputcsv($output, array('EmployeeId', 'Name', 'Check-In Date', 'Check-In Time', 'Check-Out Date', 'Check-Out Time', 'Working Hours'));
    if (!empty($results)) {
      foreach ($results as $attendance) {
        $attr = array();
        $signInDatetime = $this->user_model->getsigninattendenceTime($userId, 'in', $attendance['date']);
        $signOutDattime = $this->user_model->getsignoutdatetime($userId, 'out', $attendance['created_at']);
        $attr[] = '#' . $attendance['emp_id'];
        $attr[] = ucfirst($attendance['name']);
        $attr[] = date('d-m-Y', strtotime($signInDatetime));
        $attr[] = date('H:i:s a', strtotime($signInDatetime));
        $attr[] = ($signOutDattime) ? date('d-m-Y', strtotime($signOutDattime)) : '';
        $attr[] = ($signOutDattime) ? date('H:i:s a', strtotime($signOutDattime)) : '';
        $attr[] = $this->user_model->getTotalworkinghours($signInDatetime, $signOutDattime);
        fputcsv($output, $attr);
      }
    }
    fclose($output);
  }

  public function getuserattendancelist() {
    if (!$this->input->is_ajax_request()) {
      exit('No direct script access allowed');
    }
    if ($this->input->post('userId')) {
      $userId = $this->input->post('userId');
    } else {
      $userId = $this->session->userdata('userId');
    }

    $draw = intval($this->input->post("draw"));
    $start = intval($this->input->post("start"));
    $length = intval($this->input->post("length"));
    $search = $this->input->post('search[value]');
    $start_date = ($this->input->post('start_date')) ? $this->input->post('start_date') : '';
    $end_date = ($this->input->post('end_date')) ? $this->input->post('end_date') : '';
    if ($start_date != '') {
      $start_date = date('Y-m-d', strtotime($start_date));
    }
    if ($end_date != '') {
      $end_date = date('Y-m-d', strtotime($end_date));
    }


    $this->db->select('DATE(created_at) as date');
    $this->db->from('tbl_attendances');
    $this->db->group_by('date');
    if ($start_date != '') {
      $this->db->where('tbl_attendances.created_at >=', $start_date);
    }
    if ($end_date != '') {
      $this->db->where('tbl_attendances.created_at <=', $end_date);
    }
    $this->db->where('user_id', $userId);
    $totalrows = $this->db->get()->num_rows();



    /*     * *********Listing of attendance************ */
    $this->db->select('DATE(created_at) as date,created_at,tbl_users.emp_id,tbl_users.name');
    $this->db->order_by('created_at', 'DESC');
    $this->db->where('user_id', $userId);
    if ($start_date != '') {
      $this->db->where('tbl_attendances.created_at >=', $start_date);
    }
    if ($end_date != '') {
      $this->db->where('tbl_attendances.created_at <=', $end_date);
    }
    $this->db->join('tbl_users', 'tbl_users.userId=tbl_attendances.user_id');
    $this->db->from('tbl_attendances');
    $this->db->group_by('date');
    $this->db->limit($length, $start);
    $query = $this->db->get();

    $filterrecord = $query->num_rows();
    $results = $query->result_array();

    $data = array();
    if (!empty($results)) {
      foreach ($results as $key => $attendance) {
        $attr = array();
        $signInDatetime = $this->user_model->getsigninattendenceTime($userId, 'in', $attendance['date']);
        $signOutDattime = $this->user_model->getsignoutdatetime($userId, 'out', $attendance['created_at']);
        $attr[] = '#' . $attendance['emp_id'];
        $attr[] = ucfirst($attendance['name']);
        $attr[] = date('d-m-Y', strtotime($signInDatetime));
        $attr[] = date('H:i:s a', strtotime($signInDatetime));
        $attr[] = ($signOutDattime) ? date('d-m-Y', strtotime($signOutDattime)) : '';
        $attr[] = ($signOutDattime) ? date('H:i:s a', strtotime($signOutDattime)) : '';
        $attr[] = $this->user_model->getTotalworkinghours($signInDatetime, $signOutDattime);

        $data[] = $attr;
      }
    }

    $output = array(
        "draw" => $draw,
        "recordsTotal" => $totalrows,
        "recordsFiltered" => $filterrecord,
        "data" => $data
    );
    echo json_encode($output);
    exit();
  }

  function getalluserattendancelist() {
    if (!$this->input->is_ajax_request()) {
      exit('No direct script access allowed');
    }

    $userId = $this->session->userdata('userId');
    $draw = intval($this->input->post("draw"));
    $start = intval($this->input->post("start"));
    $length = intval($this->input->post("length"));
    $search = $this->input->post('search[value]');
    $organization_id = $this->input->post('organization_id');
    $emp_idcode = $this->input->post('emp_id');
    $email = $this->input->post('email');
    $empID = '';
    if ($emp_idcode) {
      $emparray = explode('_', $emp_idcode);
      $empID = isset($emparray[0]) ? $emparray[0] : '';
    }



    $this->db->select('DATE(created_at) as date');
    $this->db->from('tbl_users');

    $this->db->group_by(array("tbl_users.userId"));
    $this->db->where('tbl_users.isDeleted', '0');
    if ($empID) {
      $this->db->where('tbl_users.userId', $empID);
    }
    if ($email) {

      $this->db->like('tbl_users.email', $email);
    }
    $this->db->where('tbl_users.organization_id', $organization_id);
    $this->db->join('tbl_attendances', 'tbl_attendances.user_id=tbl_users.userId', 'LEFT');
    $totalrows = $this->db->get()->num_rows();
    $this->db->select('tbl_users.userId,tbl_users.name,tbl_users.emp_id,tbl_users.email,tbl_users.designation');
    $this->db->group_by('tbl_users.userId');
    $this->db->order_by('tbl_attendances.created_at', 'DESC');
    $this->db->where('tbl_users.isDeleted', '0');
    if ($empID) {
      $this->db->where('tbl_users.userId', $empID);
    }
    if ($email) {
      $this->db->like('tbl_users.email', $email);
    }
    $this->db->where('tbl_users.organization_id', $organization_id);
    $this->db->join('tbl_attendances', 'tbl_attendances.user_id=tbl_users.userId', 'left');
    $this->db->from('tbl_users');
    if ($search != '') {
      //$this->db->like('cat_name', $search);
    }
    $this->db->limit($length, $start);
    $query = $this->db->get();
    $filterrecord = $query->num_rows();
    $results = $query->result_array();

    $data = array();
    if (!empty($results)) {
      foreach ($results as $key => $attendance) {
        $attr = array();
        $attr[] = '<a href="javascript:void(0)" onclick="showuserattendance(\'' . $attendance['userId'] . '\')">' . $attendance['name'] . ' (#' . $attendance['emp_id'] . ')</a>';

        $todaysignin = $this->user_model->getsigninattendenceTime($attendance['userId'], 'in', date('Y-m-d'));
        if ($todaysignin == '') {
          $todaySignOut = '';
          $totalhours = '';
        } else {
          $todaySignOut = $this->user_model->getsignoutdatetime($attendance['userId'], 'out', $todaysignin);
          $totalhours = $this->user_model->getTotalworkinghours($todaysignin, $todaySignOut);
        }



        $attr[] = $attendance['email'];
        $attr[] = $attendance['designation'];
        $attr[] = $totalhours;
        $data[] = $attr;
        //$count++;
      }
    }

    $output = array(
        "draw" => $draw,
        "recordsTotal" => $totalrows,
        "recordsFiltered" => $filterrecord,
        "data" => $data
    );
    echo json_encode($output);
    exit();
  }

  function getdepartmentajax($withEmpCount = '0') {
    if (!$this->input->is_ajax_request()) {
      exit('No direct script access allowed');
    }
    $orgaizationId = $this->input->post('orgaizationId');
    if ($withEmpCount) {
      $this->db->select('tbl_departments.dept_id,tbl_departments.dept_name,count(tbl_users.userId) as manpower');
      $this->db->join('tbl_organization', 'tbl_organization.id=tbl_departments.org_id');
      $this->db->join('tbl_users', 'tbl_users.department_id=tbl_departments.dept_id');
      $this->db->where('tbl_users.isDeleted', '0')->where('tbl_users.roleId', '3')->group_by('tbl_departments.dept_id');
    } else {
      $this->db->select('dept_id,dept_name');
      $this->db->join('tbl_organization', 'tbl_organization.id=tbl_departments.org_id');
    }
    $this->db->from('tbl_departments');
    $this->db->where('tbl_departments.isDeleted', '0');
    $this->db->where('tbl_organization.isDeleted', '0');

    $this->db->where('tbl_departments.org_id', $orgaizationId);

    $departmentlist = $this->db->get()->result_array();
    echo json_encode($departmentlist);
  }

  function getmaindepartmentajax($withEmpCount = '0') {
    if (!$this->input->is_ajax_request()) {
      exit('No direct script access allowed');
    }
    $orgaizationId = $this->input->post('orgaizationId');
    if ($withEmpCount) {
      $this->db->select('tbl_departments.dept_id,tbl_departments.dept_name,count(tbl_users.userId) as manpower');
      $this->db->join('tbl_organization', 'tbl_organization.id=tbl_departments.org_id');
      //$this->db->join('tbl_users', 'tbl_users.department_id=tbl_departments.dept_id');
      $this->db->join('tbl_users', 'tbl_users.main_dept_id = tbl_departments.dept_id');
      $this->db->where('tbl_users.isDeleted', '0')->where('tbl_users.roleId', '3')->group_by('tbl_departments.dept_id');
    } else {
      $this->db->select('dept_id,dept_name');
      $this->db->join('tbl_organization', 'tbl_organization.id=tbl_departments.org_id');
    }
    $this->db->from('tbl_departments');
    $this->db->where('tbl_departments.isDeleted', '0');
    $this->db->where('tbl_organization.isDeleted', '0');

    $this->db->where('tbl_departments.org_id', $orgaizationId);

    $departmentlist = $this->db->get()->result_array();
    echo json_encode($departmentlist);
  }

  function getlocationajax($withEmpCount = '0') {
    if (!$this->input->is_ajax_request()) {
      exit('No direct script access allowed');
    }
    $clientId = $this->input->post('clientId');
    if ($withEmpCount) {
      $this->db->select('tbl_departments.dept_id,tbl_departments.dept_name,count(tbl_users.userId) as manpower');
      $this->db->join('tbl_organization', 'tbl_organization.id=tbl_departments.org_id');
      $this->db->join('tbl_users', 'tbl_users.department_id=tbl_departments.dept_id');
      $this->db->where('tbl_users.isDeleted', '0')->group_by('tbl_departments.dept_id');
    } else {
      $this->db->select('loc_id,loc_name');
      //$this->db->join('tbl_organization', 'tbl_organization.id=tbl_departments.org_id');
    }
    $this->db->from('tbl_location');
    $this->db->where('tbl_location.isDeleted', '0');
    //$this->db->where('tbl_organization.isDeleted', '0');

    $this->db->where('tbl_location.client_id', $clientId);

    $locationlist = $this->db->get()->result_array();
    //echo $this->db->last_query();
    //pre($locationlist);
    echo json_encode($locationlist);
  }

  function getclientajax($withEmpCount = '0') {
    if (!$this->input->is_ajax_request()) {
      exit('No direct script access allowed');
    }
    $locationId = $this->input->post('locationId');
    if ($withEmpCount) {
      $this->db->select('tbl_departments.dept_id,tbl_departments.dept_name,count(tbl_users.userId) as manpower');
      $this->db->join('tbl_organization', 'tbl_organization.id=tbl_departments.org_id');
      $this->db->join('tbl_users', 'tbl_users.department_id=tbl_departments.dept_id');
      $this->db->where('tbl_users.isDeleted', '0')->group_by('tbl_departments.dept_id');
    } else {
      $this->db->select('id,client');
      //$this->db->join('tbl_organization', 'tbl_organization.id=tbl_departments.org_id');
    }
    $this->db->from('tbl_clients');
    //$this->db->where('tbl_clients.isDeleted', '0');
    //$this->db->where('tbl_organization.isDeleted', '0');

    $this->db->where('tbl_clients.location_id', $locationId);

    $locationlist = $this->db->get()->result_array();
    //echo $this->db->last_query();
    //pre($locationlist);
    echo json_encode($locationlist);
  }

  function getlocationlist() {
    if (!$this->input->is_ajax_request()) {
      exit('No direct script access allowed');
    }

    $userId = $this->session->userdata('userId');
    $draw = intval($this->input->post("draw"));
    $start = intval($this->input->post("start"));
    $length = intval($this->input->post("length"));
    $search = $this->input->post('search[value]');



    $this->db->from('tbl_warehouse_location');
    $this->db->where('tbl_organization.isDeleted', '0');
    $this->db->join('tbl_organization', 'tbl_organization.id=tbl_warehouse_location.org_id');
    $totalrows = $this->db->get()->num_rows();



    $this->db->select('tbl_warehouse_location.*,tbl_organization.org_name');
    $this->db->where('tbl_organization.isDeleted', '0');
    $this->db->join('tbl_organization', 'tbl_organization.id=tbl_warehouse_location.org_id');
    $this->db->from('tbl_warehouse_location');
    if ($search != '') {
      //$this->db->like('cat_name', $search);
    }
    $this->db->limit($length, $start);
    $query = $this->db->get();
    $filterrecord = $query->num_rows();
    $results = $query->result_array();

    $data = array();
    if (!empty($results)) {
      foreach ($results as $key => $location) {
        $attr = array();
        $attr[] = $location['location'];
        $attr[] = $location['org_name'];
        $attr[] = '<a href="' . site_url('warehouse-meeting-location/' . $location['id']) . '" class="btn btn-sm btn-primary"><i class="fa fa-pencil-square-o" aria-hidden="true"></i></a><a onclick="return confirm(\'Are you sure\')" href="' . site_url('delwarehouselocation/' . $location['id']) . '" style="margin-left:5px" class="btn btn-sm btn-danger"><i class="fa fa-trash" aria-hidden="true"></i></a>';
        $data[] = $attr;
        //$count++;
      }
    }

    $output = array(
        "draw" => $draw,
        "recordsTotal" => $totalrows,
        "recordsFiltered" => $filterrecord,
        "data" => $data
    );
    echo json_encode($output);
    exit();
  }

  function getdepartmentlist() {
    if (!$this->input->is_ajax_request()) {
      exit('No direct script access allowed');
    }
    $userId = $this->session->userdata('userId');
    $draw = intval($this->input->post("draw"));
    $start = intval($this->input->post("start"));
    $length = intval($this->input->post("length"));
    $search = $this->input->post('search[value]');
    $orgId = '';
    if (in_array($this->role, ['2', '4', '5', '8', '9', '14'])) {
      $orgId = $this->organization_id;
    }
    $this->db->from('tbl_departments');
    $this->db->where('tbl_departments.isDeleted', '0');
    $this->db->not_like('tbl_departments.dept_name', 'FTU');
    $this->db->where('tbl_organization.isDeleted', '0');
    if ($orgId != '') {
      $this->db->where('tbl_organization.id', $orgId);
    }
    $this->db->join('tbl_organization', 'tbl_organization.id=tbl_departments.org_id');

    if ($search != '') {
      $likeCriteria = "(tbl_departments.dept_name  LIKE '%" . $search . "%'
                           )";
      $this->db->where($likeCriteria);
    }
    $totalrows = $this->db->get()->num_rows();
    $this->db->select('tbl_departments.*, count(tbl_users.userId) as manpower');
    $this->db->where('tbl_departments.isDeleted', '0');
    $this->db->not_like('tbl_departments.dept_name', 'FTU');
    $this->db->where('tbl_organization.isDeleted', '0');
    if ($orgId != '') {
      $this->db->where('tbl_organization.id', $orgId);
    }
    $this->db->join('tbl_organization', 'tbl_organization.id=tbl_departments.org_id');
    $this->db->join('tbl_users', 'tbl_users.department_id=tbl_departments.dept_id', 'left');
    //$this->db->where('tbl_users.isDeleted', '0');
    $this->db->group_by('tbl_departments.dept_id');
    $this->db->order_by('tbl_departments.dept_id', 'desc');
    $this->db->from('tbl_departments');
    if ($search != '') {
      $likeCriteria = "(tbl_departments.dept_name  LIKE '%" . $search . "%'
                            )";
      $this->db->where($likeCriteria);
    }
    $this->db->limit($length, $start);
    $query = $this->db->get();
    $filterrecord = $query->num_rows();
    $results = $query->result_array();
    $data = array();
    if (!empty($results)) {
      foreach ($results as $key => $deptpartment) {
        $attr = array();
        $attr[] = $deptpartment['dept_id'];
        $attr[] = $deptpartment['dept_name'];
//        $attr[] = $deptpartment['manpower'];
        $attr[] = '<a href="' . site_url('department/' . $deptpartment['dept_id']) . '" class="btn btn-sm btn-primary"><i class="fa fa-pencil-square-o" aria-hidden="true"></i></a><a onclick="return confirm(\'Are you sure\')" href="' . site_url('deldepartment/' . $deptpartment['dept_id']) . '" style="margin-left:5px" class="btn btn-sm btn-danger"><i class="fa fa-trash" aria-hidden="true"></i></a>';
        $data[] = $attr;
        //$count++;
      }
    }
    $output = array(
        "draw" => $draw,
        "recordsTotal" => $totalrows,
        "recordsFiltered" => $totalrows,
        "data" => $data
    );
    //pre($output);
    //die;

    echo json_encode($output);
    exit();
  }

  function getsubdepartmentlist() {
    if (!$this->input->is_ajax_request()) {
      exit('No direct script access allowed');
    }
    $userId = $this->session->userdata('userId');
    $draw = intval($this->input->post("draw"));
    $start = intval($this->input->post("start"));
    $length = intval($this->input->post("length"));
    $search = $this->input->post('search[value]');

    $this->db->from('tbl_sub_departments');
    $this->db->where('tbl_sub_departments.isDeleted', '0');
    $this->db->where('tbl_organization.id', $this->organization_id);
    $this->db->where('tbl_departments.isDeleted', '0');
    $this->db->not_like('tbl_sub_departments.sub_dept_name', 'FTU');
    $this->db->not_like('tbl_departments.dept_name', 'FTU');
    $this->db->join('tbl_departments', 'tbl_departments.dept_id=tbl_sub_departments.dept_id');
    $this->db->join('tbl_organization', 'tbl_organization.id=tbl_departments.org_id', 'left');
    if ($search != '') {
      $likeCriteria = "(tbl_sub_departments.sub_dept_name  LIKE '%" . $search . "%'
                            OR  tbl_departments.dept_name  LIKE '%" . $search . "%')";
      $this->db->where($likeCriteria);
    }
    $totalrows = $this->db->get()->num_rows();

    $this->db->select('tbl_sub_departments.*,tbl_departments.dept_name');
    $this->db->where('tbl_sub_departments.isDeleted', '0');
    $this->db->not_like('tbl_sub_departments.sub_dept_name', 'FTU');
    $this->db->not_like('tbl_departments.dept_name', 'FTU');
    $this->db->where('tbl_organization.id', $this->organization_id);
    $this->db->where('tbl_departments.isDeleted', '0');
    $this->db->join('tbl_departments', 'tbl_departments.dept_id=tbl_sub_departments.dept_id', 'left');
    $this->db->join('tbl_organization', 'tbl_organization.id=tbl_departments.org_id', 'left');
    $this->db->from('tbl_sub_departments');
    if ($search != '') {
      $likeCriteria = "(tbl_sub_departments.sub_dept_name  LIKE '%" . $search . "%'
                            OR  tbl_departments.dept_name  LIKE '%" . $search . "%')";
      $this->db->where($likeCriteria);
    }
    $this->db->order_by('tbl_sub_departments.id', 'desc');
    $this->db->limit($length, $start);
    $query = $this->db->get();
    $filterrecord = $query->num_rows();
    $results = $query->result_array();
    $data = array();
    if (!empty($results)) {
      foreach ($results as $key => $deptpartment) {
        $attr = array();
        $attr[] = $deptpartment['id'];
        $attr[] = $deptpartment['sub_dept_name'];
        $attr[] = $deptpartment['dept_name'];
        $attr[] = '<a href="' . site_url('sub-department/' . $deptpartment['id']) . '" class="btn btn-sm btn-primary"><i class="fa fa-pencil-square-o" aria-hidden="true"></i></a><a onclick="return confirm(\'Are you sure\')" href="' . site_url('delsubdepartment/' . $deptpartment['id']) . '" style="margin-left:5px" class="btn btn-sm btn-danger"><i class="fa fa-trash" aria-hidden="true"></i></a>';
        $data[] = $attr;
      }
    }
    $output = array(
        "draw" => $draw,
        "recordsTotal" => $totalrows,
        "recordsFiltered" => $totalrows,
        "data" => $data
    );

    echo json_encode($output);
    exit();
  }

  function getshiftlist() {
    if (!$this->input->is_ajax_request()) {
      exit('No direct script access allowed');
    }
    $userId = $this->session->userdata('userId');
    $draw = intval($this->input->post("draw"));
    $start = intval($this->input->post("start"));
    $length = intval($this->input->post("length"));
    $search = $this->input->post('search[value]');

    $this->db->from('shift_mgmt');
    $this->db->where('shift_mgmt.isDeleted', '0');
    $this->db->where('shift_mgmt.org_id', $this->organization_id);
    $this->db->where('tbl_departments.isDeleted', '0');
    $this->db->where('tbl_sub_departments.isDeleted', '0');
    $this->db->not_like('tbl_sub_departments.sub_dept_name', 'FTU');
    $this->db->not_like('tbl_departments.dept_name', 'FTU');
    $this->db->join('tbl_departments', 'tbl_departments.dept_id=shift_mgmt.dept_id');
    $this->db->join('tbl_sub_departments', 'tbl_sub_departments.id=shift_mgmt.sub_dept_id', 'left');
    if ($search != '') {
      $likeCriteria = "(shift_mgmt.shift  LIKE '%" . $search . "%' "
              . " OR tbl_sub_departments.sub_dept_name  LIKE '%" . $search . "%'
                            OR  tbl_departments.dept_name  LIKE '%" . $search . "%')";
      $this->db->where($likeCriteria);
    }
    $totalrows = $this->db->get()->num_rows();

    $this->db->select('shift_mgmt.*,tbl_sub_departments.sub_dept_name,tbl_departments.dept_name,tbl_users.name,tbl_shift.shift_name');
    $this->db->where('shift_mgmt.isDeleted', '0');
    $this->db->where('shift_mgmt.org_id', $this->organization_id);

    $this->db->where('tbl_departments.isDeleted', '0');
    $this->db->where('tbl_sub_departments.isDeleted', '0');
    $this->db->not_like('tbl_sub_departments.sub_dept_name', 'FTU');
    $this->db->not_like('tbl_departments.dept_name', 'FTU');
    $this->db->join('tbl_departments', 'tbl_departments.dept_id = shift_mgmt.dept_id');
    $this->db->join('tbl_sub_departments', 'tbl_sub_departments.id = shift_mgmt.sub_dept_id', 'left');
    $this->db->join('tbl_users', 'tbl_users.userId = shift_mgmt.superviser_id', 'left');
    $this->db->join('tbl_shift', 'tbl_shift.id = shift_mgmt.shift', 'left');
    $this->db->from('shift_mgmt');
    if ($search != '') {
      $likeCriteria = " (shift_mgmt.shift  LIKE '%" . $search . "%' "
              . " OR tbl_sub_departments.sub_dept_name  LIKE '%" . $search . "%'
                        OR  tbl_departments.dept_name  LIKE '%" . $search . "%')";
      $this->db->where($likeCriteria);
    }
    $this->db->limit($length, $start);
    $query = $this->db->get();
    $filterrecord = $query->num_rows();
    $results = $query->result_array();
    $data = array();
    if (!empty($results)) {
      foreach ($results as $key => $shift) {
        $attr = array();
        $attr[] = $shift['id'];
        $attr[] = $shift['dept_name'];
        $attr[] = $shift['sub_dept_name'];
        $attr[] = $shift['name'];
        $attr[] = $shift['shift_name'];
        $attr[] = $shift['in_time'];
        $attr[] = $shift['out_time'];
        $attr[] = '<a href="' . site_url('shift/' . $shift['id']) . '" class="btn btn-sm btn-primary"><i class="fa fa-pencil-square-o" aria-hidden="true"></i></a><a onclick="return confirm(\'Are you sure\')" href="' . site_url('delshift/' . $shift['id']) . '" style="margin-left:5px" class="btn btn-sm btn-danger"><i class="fa fa-trash" aria-hidden="true"></i></a>';
        $data[] = $attr;
      }
    }
    $output = array(
        "draw" => $draw,
        "recordsTotal" => $totalrows,
        "recordsFiltered" => $totalrows,
        "data" => $data
    );

    echo json_encode($output);
    exit();
  }

  function userattendancelist() {
    if (!in_array($this->role, ['1', '2', '5', '8', '9', '10', '11', '12'])) {
      $this->loadThis();
    } else {
      $userId = $this->session->userdata('userId');
      $this->global['pageTitle'] = 'Searbird : Attendance report';
      $orgId = '';
      if ($this->role == 2) {
        $orgId = $this->organization_id;
      }
      $organizationList = $this->user_model->getOrganizationList($orgId);
      $data['organizationList'] = $organizationList;
      $this->loadViews("userattendance", $this->global, $data, NULL);
    }
  }

  function getSupervisorListBySubDept() {
    if (!in_array($this->role, ['1', '2', '5', '8', '9', '10', '11', '12', '13', '14'])) {
      $this->loadThis();
    } else {
      $subDeptId = $this->input->post('subDeptId');
      $supervisorList = supervisersBySubDeptId($subDeptId);
      //pre($supervisorList);
      $html = "<option value=''>Select Supervisor</option>";
      if (!empty($supervisorList)) {
        foreach ($supervisorList as $key => $supervisor) {
          $html .= "<option value='" . $supervisor['userId'] . "'>" . $supervisor['name'] . "</option>";
        }
      }
      echo json_encode($html);
    }
  }

  /**
   * This function is used to load the add new form
   */
  function addNew() {
    if (!in_array($this->role, ['1', '2', '5', '8', '9', '10', '11', '12'])) {
      $this->loadThis();
    } else {
      $this->load->model('user_model');
      $data['roles'] = $this->user_model->getUserRoles();
      $orgId = '';
      if ($this->role != 1) {
        $orgId = $this->organization_id;
      }
      $data['role'] = $this->role;
      $data['organizationList'] = $this->user_model->getOrganizationList($orgId);
      $data['departmentList'] = $this->user_model->getDepartmentList($orgId, '');
      $this->global['pageTitle'] = 'Searbird : Add New Employee';
      $this->loadViews("addNew", $this->global, $data, NULL);
    }
  }

  function addUserStaffForm($addUserRoleType) {
    $roleTypeArray = userFilterByRole($addUserRoleType);
    $qRole = $roleTypeArray['qRole'];
    $qtype = $roleTypeArray['qtype'];
    if (!in_array($this->role, ['1', '2', '5', '8', '9', '10', '11', '12'])) {
      $this->loadThis();
    } else {
      $this->load->model('user_model');
      $data['roles'] = $this->user_model->getUserRoles();
      $orgId = '';
      if ($this->role != 1) {
        $orgId = $this->organization_id;
      }
      $data['addUserRole'] = $qRole;
      $data['qtype'] = $qtype;
      $data['addUserRoleType'] = $addUserRoleType;
      $data['role'] = $this->role;
      $data['organizationList'] = $this->user_model->getOrganizationList($orgId);
      $data['clientList'] = $this->user_model->getClientByWarehouse($data['organizationList'][0]['id']);
//      pre($data['clientList']);
      $data['departmentList'] = $this->user_model->getDepartmentList($orgId, '');
      $data['subDepartmentList'] = $this->user_model->getSubDepartmentList($data['departmentList'][0]['dept_id'], $subDepartmentId, $withManPowerCount = '0');
      $data['locationList'] = $this->user_model->locationList();
      $this->global['pageTitle'] = 'Searbird : Add New WH Admin';
      $this->loadViews("user_staff/add_user_staff", $this->global, $data, NULL);
    }
  }

  /**
   * This function is used to check whether email already exist or not
   */
  function checkEmailExists() {
    $userId = $this->input->post("userId");
    $email = $this->input->post("email");
    if ($userId) {
      $result = $this->user_model->checkEmailExists($email, $userId);
    } else {
      $result = $this->user_model->checkEmailExists($email);
    }
    if (empty($result)) {
      echo json_encode('true');
    } else {
      echo json_encode('false');
    }
  }

  function checkEmployeecode() {
    $userId = $this->input->post("userId");
    $empcode = $this->input->post("emp_code");

    if (empty($userId)) {
      $result = $this->user_model->checkEmployeecode($empcode);
    } else {
      $result = $this->user_model->checkEmployeecode($empcode, $userId);
    }

    if (empty($result)) {
      echo json_encode('true');
    } else {
      echo json_encode('false');
    }
  }

  function checkEmployeeUsername() {
    $userId = $this->input->post("userId");
    $username = $this->input->post("username");

    if (empty($userId)) {
      $result = $this->user_model->checkEmployeeUsername($empcode);
    } else {
      $result = $this->user_model->checkEmployeeUsername($username, $userId);
    }

    if (empty($result)) {
      echo json_encode('true');
    } else {
      echo json_encode('false');
    }
  }

  /**
   * This function is used to add new user to the system
   */
  function addNewUser() {
    if (!in_array($this->role, ['1', '2', '5', '8', '9', '10', '11', '12'])) {
      $this->loadThis();
    } else {
      $this->load->library('form_validation');
      $this->form_validation->set_rules('fname', 'Full Name', 'trim|required|max_length[128]');
      $this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email|max_length[128]|is_unique[tbl_users.email]');
      $this->form_validation->set_rules('role', 'Role', 'trim|required|numeric');
      $this->form_validation->set_rules('mobile', 'Mobile Number', 'required|min_length[10]');
      $this->form_validation->set_rules('organization', 'Organization', 'trim|required');
//      $this->form_validation->set_rules('department', 'Department', 'trim|required');
      $this->form_validation->set_rules('designation', 'Designation', 'trim|required');
      $this->form_validation->set_rules('skills', 'Skills', 'trim');
//      $this->form_validation->set_rules('doj', 'Date of joining', 'trim|required');
      $this->form_validation->set_rules('emp_code', 'Employee code', 'trim|required|is_unique[tbl_users.emp_code]');
      if ($this->input->post('role') == '4') {
        $this->form_validation->set_rules('shift', 'required');
      }
      if ($this->form_validation->run() == FALSE) {
        $this->addNew();
      } else {
        $ftuDataArray = utfDepartmentByOrg($this->input->post('organization'));
        $name = ucwords(strtolower($this->security->xss_clean($this->input->post('fname'))));
        $email = strtolower($this->security->xss_clean($this->input->post('email')));
//        $mainDepartment = $this->input->post('department');
        $roleId = $this->input->post('role');
        $shift = $this->input->post('shift');
        $mobile = $this->security->xss_clean($this->input->post('mobile'));
        $organizationId = $this->input->post('organization');
        $departmentId = $ftuDataArray['dept_id'];
        $subdepartmentId = $ftuDataArray['id'];
        $designation = ($this->security->xss_clean($this->input->post('designation')));
        $skills = $this->security->xss_clean($this->input->post('skills'));
        $emp_code = $this->input->post('emp_code');
//        $doj = $this->input->post('doj');
//        if ($doj != '') {
//          $doj = date('Y-m-d', strtotime($doj));
//        }
        $reporting_manager = $this->input->post('reporting_manager');

        if (!empty($skills)) {
          foreach ($skills as $skill) {
            $skill = strtolower($skill);
            $this->db->where("skill LIKE '" . $skill . "'");
            $chkcount = $this->db->get('tbl_skills')->num_rows();
            if (!$chkcount) {
              $this->db->insert('tbl_skills', ['skill' => $skill]);
            }
          }
        }

        $skills = strtolower(implode(',', $skills));

        $avatar = '';
        if ($_FILES["avatar"]["size"] > 0) {
          $config['upload_path'] = BASE_PATH . '/assets/images/avatar/';
          $config['allowed_types'] = 'gif|jpg|png';
          //$config['max_width']            = 1024;
          //$config['max_height']           = 768;
          $config['encrypt_name'] = TRUE;
          $this->load->library('upload', $config);
          if ($this->upload->do_upload('avatar')) {
            $avatarInfo = $this->upload->data();
            $avatar = $avatarInfo['file_name'];
          }
        }

        $userInfo = array(
            'email' => $email,
            'roleId' => $roleId,
            'name' => $name,
            'skills' => $skills,
            'mobile' => $mobile,
            'createdBy' => $this->vendorId,
            'createdDtm' => date('Y-m-d H:i:s'),
            'organization_id' => $organizationId,
            'department_id' => $departmentId,
            'main_department' => $mainDepartment,
            'sub_department_id' => $subdepartmentId,
            'avatar' => $avatar,
            'designation' => $designation,
            'emp_code' => $emp_code,
            'doj' => $doj,
            'reporting_manager' => $reporting_manager,
            'shift' => $shift
        );
        $this->load->model('user_model');
        $result = $this->user_model->addNewUser($userInfo);
        if ($result > 0) {
          $empID = sprintf("%'.07d\n", $result);
          $this->user_model->editUser(['emp_id' => $empID], $result);
          $this->session->set_flashdata('success', 'New Employee created successfully');
        } else {
          $this->session->set_flashdata('error', 'Employee creation failed');
        }
        redirect('userListing');
      }
    }
  }

  /**
   * This function is used to add new user to the system
   */
  function addUserStaff($addUserRole) {
    if (!in_array($this->role, ['1', '2', '5', '8', '9', '10', '11', '12'])) {
      $this->loadThis();
    } else {
      $this->load->library('form_validation');
      $this->form_validation->set_rules('fname', 'Full Name', 'trim|required|max_length[128]');
      $this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email|max_length[128]|is_unique[tbl_users.email]');
      $this->form_validation->set_rules('username', 'Username', 'trim|required|is_unique[tbl_users.username]');
      $this->form_validation->set_rules('password', 'Password', 'required|max_length[20]');
      $this->form_validation->set_rules('cpassword', 'Confirm Password', 'trim|required|matches[password]|max_length[20]');
      $this->form_validation->set_rules('mobile', 'Mobile Number', 'required|min_length[10]');
      if ($this->input->post('role') != '11') {
        if ($this->input->post('role') == '10') {
          $this->form_validation->set_rules('location[]', 'Location', 'required');
        } elseif ($this->input->post('role') == '12' || $this->input->post('role') == '9') {
          $this->form_validation->set_rules('location', 'Location', 'required');
        } else {
          if ($this->input->post('role') == '11') {

          } else {
            if ($this->input->post('role') != '5') {
              $this->form_validation->set_rules('organization', 'Organization', 'trim|required');
              if ($this->input->post('role') != '4') {
                $this->form_validation->set_rules('client[]', 'Clients', 'trim|required');
              }
            }
          }
        }
      }
//      $this->form_validation->set_rules('doj', 'Date of joining', 'trim|required');
      $this->form_validation->set_rules('emp_code', 'Employee code', 'trim|required|is_unique[tbl_users.emp_code]');
      if ($this->form_validation->run() == FALSE) {
        $this->addUserStaffForm($addUserRole);
      } else {
        $name = ucwords(strtolower($this->security->xss_clean($this->input->post('fname'))));
        $email = strtolower($this->security->xss_clean($this->input->post('email')));
        $username = strtolower($this->security->xss_clean($this->input->post('username')));
        $password = $this->input->post('password');
        $roleId = $this->input->post('role');
        $mobile = $this->security->xss_clean($this->input->post('mobile'));
        $organizationId = $this->input->post('organization');
        $locationIdsArray = $this->input->post('location');
        $clientIdsArray = $this->input->post('client');
        $departmentId = $this->input->post('department');
        $subdepartmentId = $this->input->post('subdepartment');
        if (is_array($locationIdsArray)) {
          $locationString = implode(',', $locationIdsArray);
        } else {
          $locationString = $locationIdsArray;
        }
        if (is_array($clientIdsArray)) {
          $clientString = implode(',', $clientIdsArray);
        } else {
          $clientString = $clientIdsArray;
        }
        $emp_code = $this->input->post('emp_code');
        $doj = $this->input->post('doj');
        if ($doj != '') {
          $doj = date('Y-m-d', strtotime($doj));
        }
        $avatar = '';
        if ($_FILES["avatar"]["size"] > 0) {
          $config['upload_path'] = BASE_PATH . '/assets/images/avatar/';
          $config['allowed_types'] = 'gif|jpg|png';
          $config['encrypt_name'] = TRUE;
          $this->load->library('upload', $config);
          if ($this->upload->do_upload('avatar')) {
            $avatarInfo = $this->upload->data();
            $avatar = $avatarInfo['file_name'];
          }
        }
        $userInfo = array(
            'email' => $email,
            'username' => $username,
            'password' => getHashedPassword($password),
            'roleId' => $roleId,
            'name' => $name,
            'mobile' => $mobile,
            'createdBy' => $this->vendorId,
            'createdDtm' => date('Y-m-d H:i:s'),
            'avatar' => $avatar,
            'designation' => $this->input->post('designation'),
            'main_department' => $departmentId,
            'sub_department_id' => $subdepartmentId,
            'emp_code' => $emp_code,
            'doj' => $doj,
        );
        if ($this->input->post('role') != '11') {
          if ($this->input->post('role') == '10' || $this->input->post('role') == '12') {
            $userInfo['location'] = $locationString;
          } else {
            $userInfo['organization_id'] = $organizationId;
            $userInfo['client_id'] = $clientString;
          }
        }
        $userInfo['location'] = $locationString;
        $this->load->model('user_model');
//        pre($userInfo);
        $result = $this->user_model->addNewUser($userInfo);
//        die;
        if ($result > 0) {
          $empID = sprintf("%'.07d\n", $result);
          $this->user_model->editUser(['emp_id' => $empID], $result);
          $this->session->set_flashdata('success', 'New WH Admin created successfully');
        } else {
          $this->session->set_flashdata('error', 'User creation failed');
        }
        $redirect = 'users/' . $addUserRole;
        redirect($redirect);
      }
    }
  }

  /**
   * This function is used load user edit information
   * @param number $userId : Optional : This is user id
   */
  function editOld($userId = NULL) {
    if (!in_array($this->role, ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'])) {
      $this->loadThis();
    } else {
      if ($userId == null) {
        redirect('userListing');
      }
      $data['roles'] = $this->user_model->getUserRoles();
      $data['userInfo'] = $this->user_model->getUserInfo($userId);
      if (!empty($data['userInfo'])) {
        $data['userInfo']->reportingManager = $this->user_model->getUserName($data['userInfo']->reporting_manager);
      }
      $this->global['pageTitle'] = 'Searbird : Edit Employee';
      $organizationId = $data['userInfo']->organization_id;
      $departmentId = $data['userInfo']->department_id;
      $orgId = '';
      if ($this->role == 2 || $this->role == 8) {
        $orgId = $this->organization_id;
      }
      $data['organizationList'] = $this->user_model->getOrganizationList($orgId);
      $data['departmentList'] = $this->user_model->getDepartmentList($organizationId, '');
      $data['subDepartmentList'] = $this->user_model->getSubDepartmentList($departmentId, '', '');

      $data['skillslist'] = $this->user_model->getskillslist();

      $this->loadViews("editOld", $this->global, $data, NULL);
    }
  }

  function editUserStaff($userId = NULL) {
    if (!in_array($this->role, ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'])) {
      $this->loadThis();
    } else {
      if ($userId == null) {
        redirect('users');
      }
      $data['roles'] = $this->user_model->getUserRoles();
      $data['userInfo'] = $this->user_model->getUserInfo($userId);
      if (!empty($data['userInfo'])) {
        $data['userInfo']->reportingManager = $this->user_model->getUserName($data['userInfo']->reporting_manager);
      }
      $this->global['pageTitle'] = 'Searbird : Edit Employee';
      $organizationId = $data['userInfo']->organization_id;
      $orgId = '';
      if ($this->role == 2 || $this->role == 8) {
        $orgId = $this->organization_id;
      }
      $userRoleArray = userFilterByRoleId($data['userInfo']->roleId);

      $roleTypeArray = userFilterByRole($userRoleArray['qtype']);
      $data['qtype'] = $roleTypeArray['qtype'];
      $data['addUserRoleType'] = $userRoleArray['qtype'];
      $data['organizationList'] = $this->user_model->getOrganizationList($organizationId);
      $data['clientList'] = $this->user_model->getClientByWarehouse($data['organizationList'][0]['id']);
//      pre($data['clientList']);
      $data['locationList'] = $this->user_model->locationList();
//      pre($data['locationList']);
      $data['departmentList'] = $this->user_model->getDepartmentList($organizationId, '');
      $data['subDepartmentList'] = $this->user_model->getSubDepartmentList($data['userInfo']->department_id, $subDepartmentId, $withManPowerCount = '0');
      $data['skillslist'] = $this->user_model->getskillslist();
      $this->loadViews("user_staff/edit_user_staff", $this->global, $data, NULL);
    }
  }

  function updateUserStaff() {
    if (!in_array($this->role, ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'])) {
      $this->loadThis();
    } else {
      $this->load->library('form_validation');
      $userId = $this->input->post('userId');
      $userDetail = $this->user_model->getUserInfo($userId);
      $userEmail = $userDetail->email;
      $username = $userDetail->username;
      $userAvatar = $userDetail->avatar;
      $userEmpcode = $userDetail->emp_code;
      if ($this->input->post('email') != $userEmail) {
        $is_unique = '|is_unique[tbl_users.email]';
      } else {
        $is_unique = '';
      }
      if ($this->input->post('emp_code') != $userEmpcode) {
        $is_unique_code = '|is_unique[tbl_users.emp_code]';
      } else {
        $is_unique_code = '';
      }
      if ($this->input->post('username') != $username) {
        $is_unique_username = '|is_unique[tbl_users.username]';
      } else {
        $is_unique_username = '';
      }
      $this->form_validation->set_rules('fname', 'Full Name', 'trim|required|max_length[128]');
      $this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email|max_length[128]');
      $this->form_validation->set_rules('role', 'Role', 'trim|required|numeric');
      $this->form_validation->set_rules('mobile', 'Mobile Number', 'required|min_length[10]');
//      $this->form_validation->set_rules('doj', 'Date of joining', 'trim|required');
      $this->form_validation->set_rules('emp_code', 'Employee code', 'trim|required' . $is_unique_code);
      $this->form_validation->set_rules('username', 'Username', 'trim|required' . $is_unique_username);
      if ($this->input->post('role') != '11') {
        if ($this->input->post('role') == '10') {
          $this->form_validation->set_rules('location[]', 'Location', 'required');
        } elseif ($this->input->post('role') == '12' || $this->input->post('role') == '9') {
          $this->form_validation->set_rules('location', 'Location', 'required');
        } else {
          if (!in_array($this->input->post('role'), ['4', '5'])) {
            $this->form_validation->set_rules('organization', 'Organization', 'trim|required');

            $this->form_validation->set_rules('client[]', 'Clients', 'trim|required');
          }
          // $this->form_validation->set_rules('client[]', 'Client', 'trim|required');
        }
      }
      if ($this->form_validation->run() == FALSE) {
        $this->editUserStaff($userId);
      } else {
        $name = ucwords(strtolower($this->security->xss_clean($this->input->post('fname'))));
        $email = strtolower($this->security->xss_clean($this->input->post('email')));
        $roleId = $this->input->post('role');
        $mobile = $this->security->xss_clean($this->input->post('mobile'));
        $organizationId = $this->input->post('organization');
        $emp_code = $this->input->post('emp_code');
        $username = $this->input->post('username');
        $doj = $this->input->post('doj');
        $locationIdsArray = $this->input->post('location');
        $clientIdsArray = $this->input->post('client');
        $departmentId = $this->input->post('department');
        $subdepartmentId = $this->input->post('subdepartment');
        if (is_array($locationIdsArray)) {
          $locationString = implode(',', $locationIdsArray);
        } else {
          $locationString = $locationIdsArray;
        }
        if (is_array($clientIdsArray)) {
          $clientString = implode(',', $clientIdsArray);
        } else {
          $clientString = $clientIdsArray;
        }
        if ($doj != '') {
          $doj = date('Y-m-d', strtotime($doj));
        }
        $userInfo = array();
        $avatar = $userAvatar;
        if ($_FILES["avatar"]["size"] > 0) {
          $config['upload_path'] = BASE_PATH . '/assets/images/avatar/';
          $config['allowed_types'] = 'gif|jpg|png';
          $config['encrypt_name'] = TRUE;
          $this->load->library('upload', $config);
          if ($this->upload->do_upload('avatar')) {
            $avatarInfo = $this->upload->data();
            if (file_exists(BASE_PATH . '/assets/images/avatar/' . $avatar)) {
              unlink(BASE_PATH . '/assets/images/avatar/' . $avatar);
            }
            $avatar = $avatarInfo['file_name'];
          } else {
            echo $this->upload->display_errors();
            die;
          }
        }

        $userInfo = array(
            'email' => $email,
            'roleId' => $roleId,
            'name' => $name,
            'username' => $username,
            'skills' => $skills,
            'mobile' => $mobile,
            'client_id' => $clientString,
            'updatedBy' => $this->vendorId,
            'updatedDtm' => date('Y-m-d H:i:s'),
            'designation' => $this->input->post('designation'),
            'main_department' => $departmentId,
            'sub_department_id' => $subdepartmentId,
            'location' => $locationString,
            'avatar' => $avatar,
            'emp_code' => $emp_code,
            'doj' => $doj,
            'reporting_manager' => $reporting_manager,
            'shift' => $shift
        );

        if (!empty($password)) {
          $userInfo = array(
              'password' => getHashedPassword($password)
          );
        }
        if ($this->input->post('role') != '11') {
          if ($this->input->post('role') == '10' || $this->input->post('role') == '12') {
            $userInfo['location'] = $locationString;
          } else {
            $userInfo['organization_id'] = $organizationId;
          }
        }
        $result = $this->user_model->editUser($userInfo, $userId);
        if ($result == true) {
          $this->session->set_flashdata('success', 'User updated successfully');
        } else {
          $this->session->set_flashdata('error', 'User updation failed');
        }
        $roleTypeArray = userFilterByRoleId($roleId);
        $redirect = 'users/' . $roleTypeArray['qtype'];
        redirect($redirect);
      }
    }
  }

  /**
   * This function is used to edit the user information
   */
  function editUser() {
    if (!in_array($this->role, ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'])) {
      $this->loadThis();
    } else {
      $this->load->library('form_validation');
      $userId = $this->input->post('userId');
      $userDetail = $this->user_model->getUserInfo($userId);
      $userEmail = $userDetail->email;
      $userAvatar = $userDetail->avatar;
      $userEmpcode = $userDetail->emp_code;
      if ($this->input->post('email') != $userEmail) {
        $is_unique = '|is_unique[tbl_users.email]';
      } else {
        $is_unique = '';
      }
      if ($this->input->post('emp_code') != $userEmpcode) {
        $is_unique_code = '|is_unique[tbl_users.emp_code]';
      } else {
        $is_unique_code = '';
      }
      $this->form_validation->set_rules('fname', 'Full Name', 'trim|required|max_length[128]');
      $this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email|max_length[128]' . $is_unique);
      // $this->form_validation->set_rules('password', 'Password', 'matches[cpassword]|max_length[20]');
      // $this->form_validation->set_rules('cpassword', 'Confirm Password', 'matches[password]|max_length[20]');
      $this->form_validation->set_rules('role', 'Role', 'trim|required|numeric');
      $this->form_validation->set_rules('mobile', 'Mobile Number', 'required|min_length[10]');
      $this->form_validation->set_rules('organization', 'Organization', 'trim|required');
//      $this->form_validation->set_rules('department', 'Department', 'trim|required');
      $this->form_validation->set_rules('designation', 'Designation', 'trim|required');
      $this->form_validation->set_rules('skills', 'Skills', 'trim');
      //$this->form_validation->set_rules('reporting_manager','Reporting manager','trim|required');
//      $this->form_validation->set_rules('doj', 'Date of joining', 'trim|required');
      //$this->form_validation->set_rules('emp_code', 'Employee code', 'trim|required' . $is_unique_code);
      if ($this->input->post('role') == '4') {

        $this->form_validation->set_rules('shift', 'required');
      }

      if ($this->form_validation->run() == FALSE) {
        $this->editOld($userId);
      } else {
        $name = ucwords(strtolower($this->security->xss_clean($this->input->post('fname'))));
        $email = strtolower($this->security->xss_clean($this->input->post('email')));
        //$password = $this->input->post('password');
        $roleId = $this->input->post('role');
        $mobile = $this->security->xss_clean($this->input->post('mobile'));
        $organizationId = $this->input->post('organization');
//        $mainDepartment = $this->input->post('department');
        // $subdepartmentId = $this->input->post('subdepartment');
        $designation = ($this->security->xss_clean($this->input->post('designation')));
        $skills = $this->security->xss_clean($this->input->post('skills'));
        $emp_code = $this->input->post('emp_code');
        //  $reporting_manager = $this->input->post('reporting_manager');
        //$shift = $this->input->post('shift');
//        $doj = $this->input->post('doj');
        if ($doj != '') {
          $doj = date('Y-m-d', strtotime($doj));
        }
        if (!empty($skills)) {
          foreach ($skills as $skill) {
            $skill = strtolower($skill);
            $this->db->where("skill LIKE '" . $skill . "'");
            $chkcount = $this->db->get('tbl_skills')->num_rows();
            if (!$chkcount) {
              $this->db->insert('tbl_skills', ['skill' => $skill]);
            }
          }
        }
        $skills = strtolower(implode(',', $skills));
        $userInfo = array();
        $avatar = $userAvatar;
        if ($_FILES["avatar"]["size"] > 0) {
          $config['upload_path'] = BASE_PATH . '/assets/images/avatar/';
          $config['allowed_types'] = 'gif|jpg|png';
          //$config['max_width']            = 1024;
          //$config['max_height']           = 768;
          $config['encrypt_name'] = TRUE;
          $this->load->library('upload', $config);
          if ($this->upload->do_upload('avatar')) {
            $avatarInfo = $this->upload->data();
            if (file_exists(BASE_PATH . '/assets/images/avatar/' . $avatar)) {
              unlink(BASE_PATH . '/assets/images/avatar/' . $avatar);
            }
            $avatar = $avatarInfo['file_name'];
          } else {
            echo $this->upload->display_errors();
            die;
          }
        }
        if (empty($password)) {
          $userInfo = array(
              'email' => $email,
              'roleId' => $roleId,
              'name' => $name,
              'skills' => $skills,
              'mobile' => $mobile,
              'updatedBy' => $this->vendorId,
              'updatedDtm' => date('Y-m-d H:i:s'),
              'organization_id' => $organizationId,
//              'main_department' => $mainDepartment,
              'avatar' => $avatar,
              'designation' => $designation,
              'emp_code' => $emp_code,
//              'doj' => $doj,
          );
        } else {
          $userInfo = array(
              'email' => $email,
              'roleId' => $roleId,
              'skills' => $skills,
              'name' => ucwords($name),
              'mobile' => $mobile,
              'updatedBy' => $this->vendorId,
              'updatedDtm' => date('Y-m-d H:i:s'),
              'organization_id' => $organizationId,
              'avatar' => $avatar,
              'designation' => $designation,
              'emp_code' => $emp_code,
              'doj' => $doj,
              'main_department' => $mainDepartment,
          );
        }
        $result = $this->user_model->editUser($userInfo, $userId);
        if ($result == true) {
          $this->session->set_flashdata('success', 'User updated successfully');
        } else {
          $this->session->set_flashdata('error', 'User updation failed');
        }
        redirect('userListing');
      }
    }
  }

  /**
   * This function is used to delete the user using userId
   * @return boolean $result : TRUE / FALSE
   */
  function deleteUser() {
//    pre($this->input->post());
    if (!$this->role) {
      echo (json_encode(array('status' => 'access')));
    } else {
      $userId = $this->input->post('userId');
      $userInfo = array('isDeleted' => 1, 'updatedBy' => $this->vendorId, 'updatedDtm' => date('Y-m-d H:i:s'));

//      $result = $this->user_model->deleteUser($userId, $userInfo);
      $result = $this->db->delete('tbl_users', array('userId' => $userId));
//      die;
//      die;

      if ($result > 0) {
        echo (json_encode(array('status' => TRUE)));
      } else {
        echo (json_encode(array('status' => FALSE)));
      }
    }
  }

  function delorganization($organizationId) {
    $this->db->where('id', $organizationId);
    $this->db->update('tbl_organization', ['isDeleted' => '1']);
    $this->session->set_flashdata('success', 'Organization deleted successfully');
    redirect(site_url('organization'));
  }

  function delLocation($locationId) {
    $this->db->where('loc_id', $locationId);
    $this->db->update('tbl_location', ['isDeleted' => '1']);
    $this->session->set_flashdata('success', 'Location deleted successfully');
    redirect(site_url('location'));
  }

  function deldepartment($departmentId) {
    $this->db->where('dept_id', $departmentId);
    $this->db->delete('tbl_departments');
    $this->session->set_flashdata('success', 'Department deleted successfully');
    redirect(site_url('department'));
  }

  function delsubdepartment($subdepartmentId) {
    $this->db->where('id', $subdepartmentId);
    $this->db->delete('tbl_sub_departments');
//    $this->db->update('tbl_sub_departments', ['isDeleted' => '1']);
    $this->session->set_flashdata('success', 'Sub Department deleted successfully');
    redirect(site_url('sub-department'));
  }

  function delwarehouselocation($location) {
    $this->db->where('id', $location);
    $this->db->delete('tbl_warehouse_location');
    $this->session->set_flashdata('success', 'Location deleted successfully');
    redirect(site_url('warehouse-meeting-location'));
  }

  function updateorganization() {
    //pre($this->input->post());
    if ($this->input->post()) {
      $organization_id = $this->input->post('organization_id');
      if ($organization_id) {
        $this->form_validation->set_rules('orgname', 'Organization', 'required');
        $this->form_validation->set_rules('client_id[]', 'Client Name', 'required');
        $this->form_validation->set_rules('location_id', 'Location Name', 'required');
        $this->form_validation->set_rules('org_code', 'Organization Code', 'required');
        if ($this->form_validation->run() === TRUE) {

          $organization = strip_tags($this->input->post('orgname'));
          $clientIdsArray = $this->input->post('client_id');
          //pre($clientIdsArray);
          if (is_array($clientIdsArray)) {
            $clientString = implode(',', $clientIdsArray);
          } else {
            $clientString = $clientIdsArray;
          }
          //echo $clientString;
          //die;
          $locationId = strip_tags($this->input->post('location_id'));
          $org_code = strip_tags($this->input->post('org_code'));

          $this->db->where('id', $organization_id);
          $this->db->update('tbl_organization', ['org_name' => $organization, 'client_id' => $clientString, 'loc_id' => $locationId, 'org_code' => $org_code]);
          //echo $this->db->last_query();
          //die;
          $this->session->set_flashdata('success', 'Organization updated successfully');
          redirect(site_url('organization'));
          exit;
        }
      }
    }
    redirect(site_url('organization'));
  }

  function organization($organizationId = '') {
    //pre($organizationId);
    if (!in_array($this->role, ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'])) {
      $this->loadThis();
    } else {
      if ($this->input->post()) {
        $this->form_validation->set_rules('orgname', 'Organization', 'required|is_unique[tbl_organization.org_name]');
        $this->form_validation->set_rules('client_id[]', 'Client Name', 'required');
        $this->form_validation->set_rules('location_id', 'Location Name', 'required');
        $this->form_validation->set_rules('org_code', 'Organization Code', 'required|is_unique[tbl_organization.org_code]');
        if ($this->form_validation->run() === TRUE) {
          $organization = strip_tags($this->input->post('orgname'));
          $clientIdsArray = $this->input->post('client_id');
          //pre($clientIdsArray);
          if (is_array($clientIdsArray)) {
            $clientString = implode(',', $clientIdsArray);
          } else {
            $clientString = $clientIdsArray;
          }
          //echo $clientString;
          //die;
          $locationId = strip_tags($this->input->post('location_id'));
          $org_code = strip_tags($this->input->post('org_code'));
          if ($organizationId) {
            //pre($organizationId);
            $this->db->where('id', $organizationId);
            $this->db->update('tbl_organization', ['org_name' => $organization, 'client_id' => $clientString, 'loc_id' => $locationId, 'org_code' => $org_code]);

            $this->session->set_flashdata('success', ' Warehouse Updated Successfully');
            redirect(site_url('organization'));
          } else {
            //echo $clientString;
            //die;
            $this->db->insert('tbl_organization', ['org_name' => $organization, 'client_id' => $clientString, 'loc_id' => $locationId, 'org_code' => $org_code]);
            $orgId = $this->db->insert_id();
            if ($orgId) {
              $this->db->insert('tbl_departments', ['org_id' => $orgId, 'dept_name' => 'FTU', 'benchmark' => '0']);
              $dept = $this->db->insert_id();
              if ($dept) {
                $this->db->insert('tbl_sub_departments', ['org_id' => $orgId, 'dept_id' => $dept, 'sub_dept_name' => 'FTU']);
              }
            }
            $this->session->set_flashdata('success', 'Organization Update Successfully');
            redirect(site_url('organization'));
          }
        }
      }
      $this->global['pageTitle'] = 'Searbird : Warehouse';
      $this->db->where('tbl_organization.isDeleted', '0');
      $this->db->select('tbl_organization.*,tbl_clients.client as client_name,tbl_location.loc_name');
      $this->db->join('tbl_clients', 'tbl_organization.client_id=tbl_clients.id', 'left');
      $this->db->join('tbl_location', 'tbl_organization.loc_id=tbl_location.loc_id', 'left');
      $this->db->order_by('tbl_organization.org_name');
      $organizationList = $this->db->get('tbl_organization')->result_array();
      //clientsList($organizationList);
      $locationList = $this->db->get('tbl_location')->result_array();
      $locationId = isset($locationList[0]['loc_id']) ? $locationList[0]['loc_id'] : '';
      $clientList = $this->db->get('tbl_clients')->result_array();
      //pre($clientList);
      if ($organizationId) {
        $this->db->select('tbl_organization.*,tbl_location.loc_name');
        //$this->db->join('tbl_clients', 'tbl_organization.client_id = tbl_clients.id');
        $this->db->join('tbl_location', 'tbl_organization.loc_id = tbl_location.loc_id');
        $this->db->where('tbl_organization.id', $organizationId);
        $data['organizationInfo'] = $this->db->get('tbl_organization')->row_array();
      }
      $data['organizationList'] = $organizationList;
      //pre($data);
      $data['locationList'] = $locationList;
      $data['clientList'] = $clientList;
      //$data['clientList'] = [];
      $this->loadViews("organization_view", $this->global, $data, NULL);
    }
  }

  function location($locationId = '') {
    if (!in_array($this->role, ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'])) {
      $this->loadThis();
    } else {
      if ($this->input->post()) {
        if ($locationId) {
          $this->form_validation->set_rules('loc_name', 'Location Name', 'required');
          $this->form_validation->set_rules('loc_code', 'Location Code', 'required');
        } else {
          $this->form_validation->set_rules('loc_name', 'Location Name', 'required|is_unique[tbl_location.loc_name]');
          $this->form_validation->set_rules('loc_code', 'Location Code', 'required|is_unique[tbl_location.loc_code]');
        }
        if ($this->form_validation->run() === TRUE) {
          $locName = $this->input->post('loc_name');
          $locCode = $this->input->post('loc_code');
          //echo $locationId;
          //die;
          if ($locationId) {
            $this->db->where('loc_id', $locationId);
            $this->db->update('tbl_location', ['loc_name' => $locName, 'loc_code' => $locCode]);
            $this->session->set_flashdata('success', 'Location updated successfully');
            redirect(site_url('location'));
          } else {
            $this->db->insert('tbl_location', ['loc_name' => $locName, 'loc_code' => $locCode]);
            $this->session->set_flashdata('success', 'New Location created successfully');
            redirect(site_url('location'));
          }
        }
      }
      $this->global['pageTitle'] = 'Searbird : Warehouse';
      $this->db->where('isDeleted', '0');
      $this->db->select('tbl_location.*');
      $this->db->group_by('loc_name');
      $this->db->order_by('tbl_location.loc_id', 'desc');
      $locationList = $this->db->get('tbl_location')->result_array();
      if ($locationId) {
        $this->db->select('tbl_location.*');
        $this->db->where('tbl_location.loc_id', $locationId);
        $data['locationInfo'] = $this->db->get('tbl_location')->row_array();
      }
      $data['locationList'] = $locationList;
      $this->loadViews("location_view", $this->global, $data, NULL);
    }
  }

  function updateLocationhw() {
    if ($this->input->post()) {
      $location_id = $this->input->post('location_id');
      if ($organization_id) {
        $this->form_validation->set_rules('orgname', 'Organization', 'required|is_unique[tbl_organization.org_name]');
        if ($this->form_validation->run() === TRUE) {
          $organization = strip_tags($this->input->post('orgname'));

          $this->db->where('id', $organization_id);
          $this->db->update('tbl_organization', ['org_name' => $organization]);
          $this->session->set_flashdata('success', 'New Organization updated successfully');
          redirect(site_url('organization'));
          exit;
        }
      }
    }
    redirect(site_url('organization'));
  }

  function fetchemployeelist() {

    if (!$this->input->is_ajax_request()) {
      exit('No direct script access allowed');
    }
    $search = $this->input->post('search');
    $orgId = $this->input->post('org_id');

    if ($this->role != '1') {

      $this->db->where('organization_id', $orgId);
    }

    $this->db->where('isDeleted', '0');
    $this->db->like('name', $search);
    $this->db->or_like('emp_id', $search);

    $result = $this->db->get('tbl_users')->result_array();
    $response = array();
    if (!empty($result)) {
      foreach ($result as $row) {
        $response[] = array("value" => $row['userId'] . '_' . $row['emp_id'] . '_' . $row['name'], "label" => $row['name'] . ' (#' . $row['emp_id'] . ')');
      }
    }
    echo json_encode($response);
    exit;
  }

  function updatedepartment() {
    if (!in_array($this->role, ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'])) {
      $this->loadThis();
    } else {
      $deptpartmentId = $this->input->post('department_id');
      if ($this->input->post()) {
        $rowCount = $this->db->limit(1)->get_where('tbl_departments', ['dept_name' => $this->input->post('deptname'), 'org_id' => $this->organization_id])->row()->dept_name;
        $isunique = ($rowCount && $rowCount == $this->input->post('deptname')) ? '|is_unique[tbl_departments.dept_name]' : '';
        $this->form_validation->set_rules('deptname', 'Department', 'required' . $isunique);
        if ($this->form_validation->run() === TRUE) {
          $organizationId = $this->organization_id;
          $departmentName = $this->input->post('deptname');
          $this->db->where('dept_id', $deptpartmentId);
          $this->db->update('tbl_departments', ['org_id' => $organizationId, 'dept_name' => $departmentName]);
          $this->session->set_flashdata('success', 'Department updated successfully');
          redirect(site_url('department'));
          exit;
        }
      }
      redirect(site_url('department'));
    }
  }

  function updatesubdepartment() {
    if (!in_array($this->role, ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'])) {
      $this->loadThis();
    } else {
      $subDeptpartmentId = $this->input->post('sub_department_id');
      if ($this->input->post()) {
        $rowCount = $this->db->limit(1)->get_where('tbl_sub_departments', ['sub_dept_name' => $this->input->post('subdeptname'), 'org_id' => $this->organization_id])->row()->sub_dept_name;
        $isunique = ($rowCount && $rowCount == $this->input->post('subdeptname')) ? '|is_unique[tbl_sub_departments.sub_dept_name]' : '';
        $this->form_validation->set_rules('subdeptname', 'Sub Department Name', 'required' . $isunique);
        $this->form_validation->set_rules('dept_name', 'Department Name', 'required');
        //$this->form_validation->set_rules('banchmark', 'Banchmark', 'required');
        if ($this->form_validation->run() === TRUE) {
          $subDeptName = $this->input->post('subdeptname');
          $deptId = $this->input->post('dept_name');
          $banchmark = $this->input->post('banchmark');
          $this->db->where('id', $subDeptpartmentId);
          $this->db->update('tbl_sub_departments', ['dept_id' => $deptId, 'sub_dept_name' => $subDeptName]);
          $this->session->set_flashdata('success', 'Sub Department updated successfully');
          redirect(site_url('sub-department'));
          exit;
        }
      }
      redirect(site_url('sub-department'));
    }
  }

  function updatelocation() {
    if (!in_array($this->role, ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'])) {
      $this->loadThis();
    } else {
      $location_id = $this->input->post('location_id');
      if ($this->input->post()) {
        $this->form_validation->set_rules('org_name', 'Organization', 'required');
        $this->form_validation->set_rules('location', 'Location', 'required');
        if ($this->form_validation->run() === TRUE) {
          $organizationId = $this->input->post('org_name');
          $location = $this->input->post('location');
          $this->db->where('id', $location_id);
          $this->db->update('tbl_warehouse_location', ['org_id' => $organizationId, 'location' => $location]);
          $this->session->set_flashdata('success', 'Location updated successfully');
          redirect(site_url('warehouse-meeting-location'));
          exit;
        }
      }
      redirect(site_url('warehouse-meeting-location'));
    }
  }

  function department($departmentId = '') {
    if (!in_array($this->role, ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'])) {
      $this->loadThis();
    } else {
      if ($this->input->post()) {
        if ($this->input->post('email') != $userEmail) {
          $is_unique = '|is_unique[tbl_departments.dept_name]';
        } else {
          $is_unique = '';
        }
        $rowCount = $this->db->limit(1)->get_where('tbl_departments', ['dept_name' => $this->input->post('deptname'), 'org_id' => $this->organization_id])->row()->dept_id;
//        pre($rowCount);
        $isunique = $rowCount ? '|is_unique[tbl_departments.dept_name]' : '';
//        last_query();
        $this->form_validation->set_rules('deptname', 'Department', 'required' . $isunique);
        if ($this->form_validation->run() === TRUE) {
          $organizationId = $this->organization_id;
          $departmentName = $this->input->post('deptname');
          $this->db->insert('tbl_departments', ['dept_name' => $departmentName, 'org_id' => $organizationId]);
          $this->session->set_flashdata('success', 'New Department created successfully');
          redirect(site_url('department'));
        }
      }
      if ($departmentId) {
        $data['departmentInfo'] = $this->user_model->getDepartmentList('', $departmentId);
      }
//      $orgId = '';
//      if ($this->role == '8') {
//        $orgId = $this->organization_id;
//      }
      $this->global['pageTitle'] = 'Searbird : Department';
//      $data['organizationList'] = $this->user_model->getOrganizationList($orgId);
      $this->loadViews("department_view", $this->global, $data, NULL);
    }
  }

  function subDepartment($subDepartmentId = '') {
    if (!in_array($this->role, ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'])) {
      $this->loadThis();
    } else {
      if ($this->input->post()) {
        $rowCount = $this->db->limit(1)->get_where('tbl_sub_departments', ['sub_dept_name' => $this->input->post('subdeptname'), 'org_id' => $this->organization_id])->row()->sub_dept_name;
//        pre($rowCount);
//        last_query();
        $isunique = ($rowCount) ? '|is_unique[tbl_sub_departments.sub_dept_name]' : '';
//        die;
        $this->form_validation->set_rules('subdeptname', 'Sub Department Name', 'required' . $isunique);
        $this->form_validation->set_rules('dept_name', 'Department', 'required');
//        $this->form_validation->set_rules('subdeptname', 'Sub Department', 'required|is_unique[tbl_sub_departments.sub_dept_name]');
        //$this->form_validation->set_rules('banchmark', 'Banchmark', 'required');
        if ($this->form_validation->run() === TRUE) {
          $orgId = $this->organization_id;
          $departmentId = $this->input->post('dept_name');
          $subDeptName = $this->input->post('subdeptname');
          // $banchmark = $this->input->post('banchmark');
          $this->db->insert('tbl_sub_departments', ['dept_id' => $departmentId, 'sub_dept_name' => $subDeptName, 'org_id' => $this->organization_id]);
          $this->session->set_flashdata('success', 'New Sub Department created successfully');
          redirect(site_url('sub-department'));
        }
      }
      if ($subDepartmentId) {
        $data['subDepartmentInfo'] = $this->user_model->getSubDepartmentList('', $subDepartmentId);
      }
      $orgId = '';
      if (in_array($this->role, ['2', '4', '5', '6', '8', '9', '14', '11', '12'])) {
        $orgId = $this->organization_id;
      }
      $this->global['pageTitle'] = 'Searbird : Sub Department';
      //$data['organizationList'] = $this->user_model->getOrganizationList($orgId);
      $data['departmentList'] = $this->user_model->getDepartmentList($orgId);
      $this->loadViews("sub_department_view", $this->global, $data, NULL);
    }
  }

  function meetingLocation($location = '') {
    if (!in_array($this->role, ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'])) {
      $this->loadThis();
    } else {
      if ($this->input->post()) {
        $this->form_validation->set_rules('org_name', 'Organization', 'required');
        $this->form_validation->set_rules('location', 'Location', 'required');
        if ($this->form_validation->run() === TRUE) {
          $organizationId = $this->input->post('org_name');
          $departmentName = $this->input->post('location');
          $this->db->insert('tbl_warehouse_location', ['org_id' => $organizationId, 'location' => $departmentName]);
          $this->session->set_flashdata('success', 'New Location created successfully');
          redirect(site_url('warehouse-meeting-location'));
        }
      }

      if ($location) {
        $data['locationInfo'] = $this->user_model->getLocationList('', $location);
      }
      $orgId = '';
      if ($this->role == '8') {
        $orgId = $this->organization_id;
      }
      $this->global['pageTitle'] = 'Searbird : Warehouse location';
      $data['organizationList'] = $this->user_model->getOrganizationList($orgId);
      $this->loadViews("warehouselocation_view", $this->global, $data, NULL);
    }
  }

  function addnewdepartment() {
    if (!$this->input->is_ajax_request()) {
      exit('No direct script access allowed');
    }
    if (!in_array($this->role, ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'])) {
      $this->loadThis();
    } else {
      $organizationId = $this->input->post('organization');
      $deptname = strip_tags($this->input->post('deptname'));
      $this->db->like('dept_name', $deptname);
      $this->db->where('org_id', $organizationId);
      $count = $this->db->get('tbl_departments')->num_rows();
      if ($count) {
        echo json_encode('exist');
      } else {
        $this->db->insert('tbl_departments', ['dept_name' => $deptname, 'org_id' => $organizationId]);
        echo json_encode('added');
      }
    }
  }

  function getdepartmentlistnew() {


    if (!$this->input->is_ajax_request()) {
      exit('No direct script access allowed');
    }
    if (!in_array($this->role, ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'])) {
      $this->loadThis();
    } else {

      $organizationId = $this->input->post('organizationId');
      $type = $this->input->post('type');
      $departmentList = $this->user_model->getDepartmentListAll($organizationId, '', '', '0');
      $html = "<option value=''>Select Department</option>";
      if ($type == 'all') {
        $html .= "<option value='all'>All</option>";
      }
      if (!empty($departmentList)) {
        foreach ($departmentList as $key => $dept) {
          $html .= "<option value='" . $dept['dept_id'] . "'>" . $dept['dept_name'] . "</option>";
        }
      }

      echo json_encode($html);
    }
  }

  function getclientlist() {


    if (!$this->input->is_ajax_request()) {
      exit('No direct script access allowed');
    }
    if (!in_array($this->role, ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'])) {
      $this->loadThis();
    } else {

      $organizationId = $this->input->post('organizationId');
      $type = $this->input->post('type');
      $locid = $this->input->post('locId');

      $clientList = $this->user_model->getClientByWarehouse($organizationId, $locid, $type);

      if ($type == 'all') {
        $html = "<option value='all'>All</option>";
      } else {
        $html = "<option value=''>Select Client</option>";
      }

      if (!empty($clientList)) {
        foreach ($clientList as $key => $client) {
          $html .= "<option value='" . $client['id'] . "'>" . $client['name'] . "</option>";
        }
      }

      echo json_encode($html);
    }
  }

  function getPerformaceEmployeeBySubDepartmentAjax() {
    if (!$this->input->is_ajax_request()) {
      exit('No direct script access allowed');
    }
    if (!in_array($this->role, ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'])) {
      $this->loadThis();
    } else {
      $subDeptId = $this->input->post('subDepartment');
      $employeesList = $this->user_model->getPerformaceEmployeeBySubDepartment($subDeptId);
      $html = "<option value=''>Select Employee</option>";
      if (!empty($employeesList)) {
        foreach ($employeesList as $key => $dept) {
          $html .= "<option value='" . $dept['userId'] . "'>" . $dept['name'] . "</option>";
        }
      }
      echo json_encode($html);
    }
  }

  function getLocationByClient() {

    if (!$this->input->is_ajax_request()) {
      exit('No direct script access allowed');
    }
    if (!in_array($this->role, ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'])) {
      $this->loadThis();
    } else {
      $clientId = $this->input->post('clientId');
      $locationList = $this->user_model->getLocationByClient($clientId);
      $html = "<option value=''>Select Location</option>";
      $html .= "<option value='all'>All</option>";
      if (!empty($locationList)) {
        foreach ($locationList as $key => $location) {
          $html .= "<option value='" . $location['loc_id'] . "'>" . $location['loc_name'] . "</option>";
        }
      }
      echo json_encode($html);
    }
  }

  function getWarehouseByLocation() {

    if (!$this->input->is_ajax_request()) {
      exit('No direct script access allowed');
    }
    if (!in_array($this->role, ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'])) {
      $this->loadThis();
    } else {
      $locationId = $this->input->post('locationId');
      $type = $this->input->post('type');
      $locationList = $this->user_model->getWarehouseByLocation($locationId);
      if ($type == 'all') {
        $html = "<option value='all'>All</option>";
      } else {
        $html = "<option value=''>Select Warehouse</option>";
      }
      if (!empty($locationList)) {
        foreach ($locationList as $key => $location) {
          $html .= "<option value='" . $location['id'] . "'>" . $location['org_name'] . "</option>";
        }
      }
      echo json_encode($html);
    }
  }

  function getWarehouseByClient() {

    if (!$this->input->is_ajax_request()) {
      exit('No direct script access allowed');
    }
    if (!in_array($this->role, ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'])) {
      $this->loadThis();
    } else {
      $clientId = $this->input->post('clientId');
      $warehouseList = $this->user_model->getWarehouseByClient($clientId);
      $html = "<option value=''>Select Warehouse</option>";
      $html .= "<option value='all'>All</option>";
      if (!empty($warehouseList)) {
        foreach ($warehouseList as $key => $warehouse) {
          $html .= "<option value='" . $warehouse['id'] . "'>" . $warehouse['org_name'] . "</option>";
        }
      }
      echo json_encode($html);
    }
  }

  function getClientByOrgAjax() {
    //pre($this->input->post());

    if (!$this->input->is_ajax_request()) {
      exit('No direct script access allowed');
    }
    if (!in_array($this->role, ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'])) {
      $this->loadThis();
    } else {
      $orgId = $this->input->post('orgId');
      $clientList = $this->user_model->getClientByWarehouse($orgId);
      $html = "<option value=''>Select Warehouse</option>";
      $html .= "<option value='all'>All</option>";
      if (!empty($clientList)) {
        foreach ($clientList as $key => $client) {
          $html .= "<option value='" . $client['id'] . "'>" . $client['name'] . "</option>";
        }
      }
      echo json_encode($html);
    }
  }

  function getsubdepartmentlistajax() {

    if (!$this->input->is_ajax_request()) {
      exit('No direct script access allowed');
    }
    if (!in_array($this->role, ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12', '13', '14'])) {
      $this->loadThis();
    } else {
      $organizationId = $this->input->post('organizationId');
      $departmentId = $this->input->post('departmentId');
      $type = $this->input->post('type');
      $subdepartmentList = $this->user_model->getSubDepartmentList($departmentId, $subDepartmentId = '', $withManPowerCount = '0', $type);
//      $html = "<option value=''>Select Sub Department</option><option value='all'>All</option>";

      if ($type == 'all') {
        $html .= "<option value='all'>All</option>";
      } else {
        $html = "<option value=''>Select Sub Department</option>";
      }
//      $html = "<option value=''>Select Sub Department</option>";
      if (!empty($subdepartmentList)) {
        foreach ($subdepartmentList as $key => $dept) {
          //   $html .= "<option value='" . $dept['id'] . "'>" . $dept['sub_dept_name'] . "</option>";
          $html .= "<option value='" . $dept['id'] . "'>" . $dept['sub_dept_name'] . "</option>";
        }
      }
      echo json_encode($html);
    }
  }

  function getshiftlistajax() {

    if (!$this->input->is_ajax_request()) {
      exit('No direct script access allowed');
    }
    if (!in_array($this->role, ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12', '13', '14'])) {
      $this->loadThis();
    } else {
      $subDepartmentId = $this->input->post('subdepartmentId');
      $shiftList = $this->user_model->getShiftList($subDepartmentId);
      $html = "<option value=''>Select Shift</option>";
      if (!empty($shiftList)) {
        foreach ($shiftList as $key => $shift) {
          $html .= "<option value='" . $shift['shift'] . "'>" . shiftName($shift['shift']) . "</option>";
        }
      }
      echo json_encode($html);
    }
  }

  function getshiftlistreportajax() {

    if (!$this->input->is_ajax_request()) {
      exit('No direct script access allowed');
    }
    if (!in_array($this->role, ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12', '13', '14'])) {
      $this->loadThis();
    } else {
      $orgId = $this->input->post('orgId');
      $clientId = $this->input->post('clientId');
      $departmentId = $this->input->post('departmentId');
      $subDepartmentId = $this->input->post('subdepartmentId');
      $shiftList = $this->user_model->getshiftlistreportajax($orgId, $clientId, $departmentId, $subDepartmentId);
      //pre($shiftList);
      $html = "<option value=''>Select Shift</option><option value='all'>All</option>";
      if (!empty($shiftList)) {
        foreach ($shiftList as $key => $shift) {
          $html .= "<option value='" . $shift['shift'] . "'>" . shiftName($shift['shift']) . "</option>";
        }
      }
      echo json_encode($html);
    }
  }

  /**
   * Page not found : error 404
   */
  function pageNotFound() {
    $this->global['pageTitle'] = 'Searbird : 404 - Page Not Found';

    $this->loadViews("404", $this->global, NULL, NULL);
  }

  /**
   * This function used to show login history
   * @param number $userId : This is user id
   */
  function loginHistoy($userId = NULL) {
    if (!in_array($this->role, ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'])) {
      $this->loadThis();
    } else {
      $userId = ($userId == NULL ? 0 : $userId);

      $searchText = $this->input->post('searchText');
      $fromDate = $this->input->post('fromDate');
      $toDate = $this->input->post('toDate');

      $data["userInfo"] = $this->user_model->getUserInfoById($userId);

      $data['searchText'] = $searchText;
      $data['fromDate'] = $fromDate;
      $data['toDate'] = $toDate;

      $this->load->library('pagination');

      $count = $this->user_model->loginHistoryCount($userId, $searchText, $fromDate, $toDate);

      $returns = $this->paginationCompress("login-history/" . $userId . "/", $count, 10, 3);

      $data['userRecords'] = $this->user_model->loginHistory($userId, $searchText, $fromDate, $toDate, $returns["page"], $returns["segment"]);

      $this->global['pageTitle'] = 'Searbird : User Login History';

      $this->loadViews("loginHistory", $this->global, $data, NULL);
    }
  }

  /**
   * This function is used to show users profile
   */
  function profile($active = "details") {
    $data["userInfo"] = $this->user_model->getUserInfoWithRole($this->vendorId);
    $data["active"] = $active;

    $this->global['pageTitle'] = $active == "details" ? ' : My Profile' : ' : Change Password';
    $this->loadViews("profile", $this->global, $data, NULL);
  }

  /**
   * This function is used to update the user details
   * @param $active : This is flag to set the active tab
   */
  function profileUpdate($active = "details") {
    $this->load->library('form_validation');

    $this->form_validation->set_rules('fname', 'Full Name', 'trim|required|max_length[128]');
    $this->form_validation->set_rules('mobile', 'Mobile Number', 'required|min_length[10]');

    if ($this->form_validation->run() == FALSE) {
      $this->profile($active);
    } else {
      $avatar = $this->user_model->getUserInfo($this->vendorId)->avatar;
      //echo BASE_PATH.'/assets/images/avatar/'; die;
      if ($_FILES["avatar"]["size"] > 0) {
//        $config['upload_path'] = BASE_PATH . '/assets/images/avatar/';
        $config['upload_path'] = 'assets/images/avatar/';
        $config['allowed_types'] = 'gif|jpg|png';
        //$config['max_width']            = 1024;
        //$config['max_height']           = 768;
        $config['encrypt_name'] = TRUE;
        $this->load->library('upload', $config);
        if ($this->upload->do_upload('avatar')) {
          //echo 'ffff';
          //die;
          $avatarInfo = $this->upload->data();
          if (file_exists(BASE_PATH . '/assets/images/avatar/' . $avatar)) {
            unlink(BASE_PATH . '/assets/images/avatar/' . $avatar);
          }
          $avatar = $avatarInfo['file_name'];
        } else {
          //echo 'hhhh';
          echo $this->upload->display_errors();
          //die;
        }
      }

      // die;
      $name = ucwords(strtolower($this->security->xss_clean($this->input->post('fname'))));
      $mobile = $this->security->xss_clean($this->input->post('mobile'));

      $userInfo = array('name' => $name, 'mobile' => $mobile, 'avatar' => $avatar, 'updatedBy' => $this->vendorId, 'updatedDtm' => date('Y-m-d H:i:s'));

      $result = $this->user_model->editUser($userInfo, $this->vendorId);

      if ($result == true) {
        $this->session->set_userdata('name', $name);
        $this->session->set_userdata('avatar', $avatar);
        $this->session->set_flashdata('success', 'Profile updated successfully');
      } else {
        $this->session->set_flashdata('error', 'Profile updation failed');
      }

      redirect('profile/' . $active);
    }
  }

  function getfloorsalescalculation() {
    if (!$this->input->is_ajax_request()) {
      exit('No direct script access allowed');
    }
    $floor_pallets = $this->input->post('floor_pallets');
    $floor_stored_pallets = $this->input->post('floor_stored_pallets');
    $floor_aisle = $this->input->post('floor_aisle');
    $processingArea = $this->input->post('processingArea');
    $squareFeet = 0;

    if ($floor_pallets == 'american') {

      if ($floor_aisle == 5 || $floor_aisle == '5') {


        $squareFeet = 26;
      } elseif ($floor_aisle == 9 || $floor_aisle == '9') {


        $squareFeet = 34;
      }
    } elseif ($floor_pallets == 'euro') {

      if ($floor_aisle == 5 || $floor_aisle == '5') {

        $squareFeet = 22;
      } elseif ($floor_aisle == 9 || $floor_aisle == '9') {


        $squareFeet = 30;
      }
    }



    $totalArea = $floor_stored_pallets * $squareFeet;
    $totalAreapercentage = '';
    if ($processingArea) {
      $percentageArea = (int) (($processingArea / 100) * $totalArea);
      $totalAreapercentage = $totalArea + $percentageArea;
    }
    $result['area'] = $totalArea . ' Sq Ft.';
    $result['areapercentage'] = $totalAreapercentage . ' Sq Ft.';
    echo json_encode($result);
  }

  /**
   * This function is used to change the password of the user
   * @param  $active : This is flag to set the active tab
   */
  function changePassword($active = "changepass") {
    $this->load->library('form_validation');

    $this->form_validation->set_rules('oldPassword', 'Old password', 'required|max_length[20]');
    $this->form_validation->set_rules('newPassword', 'New password', 'required|max_length[20]');
    $this->form_validation->set_rules('cNewPassword', 'Confirm new password', 'required|matches[newPassword]|max_length[20]');

    if ($this->form_validation->run() == FALSE) {
      $this->profile($active);
    } else {
      $oldPassword = $this->input->post('oldPassword');
      $newPassword = $this->input->post('newPassword');

      $resultPas = $this->user_model->matchOldPassword($this->vendorId, $oldPassword);

      if (empty($resultPas)) {
        $this->session->set_flashdata('nomatch', 'Your old password is not correct');
        redirect('profile/' . $active);
      } else {
        $usersData = array(
            'password' => getHashedPassword($newPassword), 'updatedBy' => $this->vendorId,
            'updatedDtm' => date('Y-m-d H:i:s')
        );

        $result = $this->user_model->changePassword($this->vendorId, $usersData);

        if ($result > 0) {
          $this->session->set_flashdata('success', 'Password updation successful');
        } else {
          $this->session->set_flashdata('error', 'Password updation failed');
        }

        redirect('profile/' . $active);
      }
    }
  }

  function benchMark() {
    if ($this->role == '1' || $this->role == '4' || $this->role == '5' || $this->role == '8') {

      $orgId = '';

      if ($this->role == '2' || $this->role == '4' || $this->role == '8') {
        $orgId = $this->organization_id;
      }

      $warehouseList = $this->user_model->getOrganizationList($orgId);
      $warehouseId = isset($warehouseList[0]['id']) ? $warehouseList[0]['id'] : '';

      if ($this->role == '1') {
        $departmentList = $this->user_model->getDepartmentList($warehouseId);
      } else {
        $departmentList = $this->user_model->getDepartmentList($warehouseId);
      }
      $deptId = isset($departmentList[0]['dept_id']) ? $departmentList[0]['dept_id'] : '';
      $data['subDepartmentList'] = $this->user_model->getSubDepartmentList($deptId, $subDepartmentId, $withManPowerCount = '0');
      $data['warehouseList'] = $warehouseList;
      $data['departmentList'] = $departmentList;
      $data['role'] = $this->role;
      $data['department_id'] = $this->department_id;
      $this->global['pageTitle'] = 'Searbird : Benchmark';
      $this->loadViews("banchmark_view", $this->global, $data, NULL);
    } else {
      $this->loadThis();
    }
  }

  function getprevioussupervisor() {
    if (!$this->input->is_ajax_request()) {
      exit('No direct script access allowed');
    }
    $html = '';
    $shift = $this->input->post('shift');
    $department = $this->input->post('department');
    $userId = $this->input->post('userId');
    $this->db->select('userId,name,email');
    $this->db->where('shift', $shift);
    $this->db->where('department_id', $department);
    $this->db->where('isDeleted', '0');
    if ($userId != '') {
      $this->db->where_not_in('userId', [$userId]);
    }
    $userList = $this->db->get('tbl_users')->result_array();
    $html .= '<table class="table">';
    $html .= '<tr><th>Name</th><th>Email</th><th>Change Role</th></tr>';
    if (!empty($userList)) {
      foreach ($userList as $key => $usr) {
        $html .= '<tr>';
        $html .= '<td>' . $usr['name'] . '</td>';
        $html .= '<td>' . $usr['email'] . '</td>';
        $html .= '<td><a href="' . site_url('editOld/' . $usr['userId']) . '" target="_blank">Change</a></td>';
        $html .= '</tr>';
      }
    }
    $html .= '</table>';
    $result['html'] = $html;
    $result['supervisor'] = count($userList);
    echo json_encode($result);
  }

  function getdepartment_benchmark() {
    if (!$this->input->is_ajax_request()) {
      exit('No direct script access allowed');
    }
    $departmentId = $this->session->userdata('department_id');
    $subDepartmentId = $this->session->userdata('sub_department_id');
    $warehouseId = $this->input->post('warehouseId');
    $department_id = $this->input->post('department_id');
    $sub_department_id = $this->input->post('sub_department_id');
    $benchmonth = $this->input->post('benchmonth');
    $view = $this->input->post('view');
    if ($view == 'week') {
      $fromDate = date("Y-m-d", strtotime('monday this week'));
      $toDate = date('Y-m-d');
    } elseif ($view == 'month') {
      $fromDate = date("Y-m-01");
      $toDate = date('Y-m-d');
    } elseif ($view == 'prevmonth') {
      $month_ini = new DateTime("first day of last month");
      $month_end = new DateTime("last day of last month");
      $fromDate = $month_ini->format('Y-m-d');
      $toDate = $month_end->format('Y-m-d');
    }
    $this->db->select('benchmark');
    $this->db->where('dept_id', $sub_department_id);
    $banchmark = $this->db->get('tbl_sub_departments')->row()->benchmark;
    $this->db->select('dept_name');
    $this->db->where('dept_id', $department_id);
    $deptName = $this->db->get('tbl_departments')->row()->dept_name;
    $subDeptName = subDeptName($sub_department_id);
    $teamId = array();
    $this->db->select('id');
    $this->db->where('department_id', $department_id);
    $teamInfo = $this->db->get('tbl_manpower_team')->result_array();
    if (!empty($teamInfo)) {
      foreach ($teamInfo as $key => $team) {
        $teamId[] = $team['id'];
      }
    }

    $selectQuery = 'SELECT '
            . '  '
            . 'U.roleId AS user_role,'
            . 'U.designation, '
            . 'U.userId AS user_id, '
            . 'U.name AS employee_name, '
            . 'U.email AS employee_email, '
            . 'U.emp_id AS employee_id, '
            . 'U.emp_code AS employee_code,'
            . 'U.department_id, U.current_status, '
            . '(SELECT dept_name from `tbl_departments` where `dept_id`= department_id) as department_name, '
            . '(SELECT sub_dept_name from `tbl_sub_departments` where `id`= sub_department_id) as sub_department_name FROM tbl_users AS U '
            . 'WHERE  U.sub_department_id = ' . $sub_department_id . ' AND U.department_id = ' . $department_id . ' and organization_id = ' . $warehouseId . ' and U. 	roleId  = 3';
    $teammembersList = $this->db->query($selectQuery)->result();

    $totalEmployee = count($teammembersList);
    $crosseBenchMark = 0;

    $passarray = array();
    $failarray = array();


    $html = '<script>Highcharts.chart(\'benchmark_section\', {
    chart: {
        type: \'column\'
    },
    title: {
        text: \'' . ucfirst($subDeptName) . ' : Shift (' . shiftNameBySubDeptId($sub_department_id) . ') Benchmark Report\'
    },
    subtitle: {
        text: \'Benchmark Target ' . $banchmark . '\'
    },
    xAxis: {
        categories: [ ';


    while (strtotime($fromDate) <= strtotime($toDate)) {


      $employeebanchmark = array();
      if (!empty($teamId)) {
        $this->db->select('employee_id,SUM(`challans`+`A`+`B`+`C`) as empBenchmark');
        $this->db->where('date', $fromDate);
        $this->db->where('dept_id', $departmentId);
        $this->db->where('sub_dept_id', $subDepartmentId);
        $this->db->from('tbl_manpower_team_performance');
        $this->db->group_by('employee_id');
        $employeebanchmark = $this->db->get()->result_array();
      }



      /* $employeebanchmark = $this->db->query("SELECT `employee_id`, SUM(`challans`+`A`+`B`+`C`) as empBenchmark FROM `tbl_manpower_team_performance` WHERE date ='".$fromDate."' AND `team_id`='".$teamId."' GROUP BY `employee_id`")->result_array(); */

      $textdate = date('d M, Y', strtotime($fromDate));
      $html .= '\'' . $textdate . '\',';
      $pass = 0;
      $fail = 0;
      if (!empty($employeebanchmark)) {
        foreach ($employeebanchmark as $key => $emp) {
          if ($emp['empBenchmark'] >= $banchmark) {
            $pass += 1;
          }
        }
      }
      $fail = $totalEmployee - $pass;
      $passpercentage = number_format(($pass / $totalEmployee) * 100, 2);
      $failpecentage = 100 - $passpercentage;
      $passarray[] = $passpercentage;
      $failarray[] = $failpecentage;
      $fromDate = date("Y-m-d", strtotime("+1 day", strtotime($fromDate)));
    }

    $html .= '
        ],
        crosshair: true
    },
    yAxis: {
        min: 0,
        title: {
            text: \'Benchmark (%)\'
        }
    },
    tooltip: {
        headerFormat: \'<span style="font-size:10px">{point.key}</span><table>\',
        pointFormat: \'<tr><td style="color:{series.color};padding:0">{series.name}: </td>\' +
            \'<td style="padding:0"><b>{point.y:.1f} %</b></td></tr>\',
        footerFormat: \'</table>\',
        shared: true,
        useHTML: true
    },
    plotOptions: {
        column: {
            pointPadding: 0.2,
            borderWidth: 0
        }
    },
    series: [{
        name: \'Pass\',
        data: [ ';

    if (!empty($passarray)) {
      foreach ($passarray as $key => $passbanch) {
        $html .= $passbanch . ',';
      }
    }
    $html .= ' ]

    }, {
        name: \'Fail\',
        data: [ ';

    if (!empty($failarray)) {
      foreach ($failarray as $key => $failbanch) {
        $html .= $failbanch . ',';
      }
    }
    $html .= ']

    }]
});</script>';



    echo json_encode($html);
    exit;
  }

}
