<?php

if (!defined('BASEPATH'))
  exit('No direct script access allowed');

require APPPATH . '/libraries/BaseController.php';

/**
 * Class : Visitor (VisitorController)
 * Visitor Class to control all user related operations.
 * @author : Vijayraj Chaudhary
 * @version : 2.1
 * @since : 30 August 2019
 */
class TicketController extends BaseController {

  /**
   * This is default constructor of the class
   */
  public function __construct() {
    parent::__construct();
    $this->load->model('user_model');
    $this->isLoggedIn();
    date_default_timezone_set('Asia/Kolkata');
  }

  public function index() {
    $data['userrole'] = $this->role;
    $this->global['pageTitle'] = 'Searbird : Tickets';
    $data['allTicket'] = $this->user_model->getTotalTicketCount('all', $this->role);
    $data['openTicket'] = $this->user_model->getTotalTicketCount('0', $this->role);
    $data['closeTicket'] = $this->user_model->getTotalTicketCount('1', $this->role);
    $data['role'] = $this->role;
    $orgId = '';
    if ($this->role == '2' || $this->role == '4' || $this->role == 8) {
      $orgId = $this->organization_id;
    }
    $warehouseList = $this->user_model->getOrganizationList($orgId);
    $warehouseId = isset($warehouseList[0]['id']) ? $warehouseList[0]['id'] : '';
    if ($this->role == '1' || $this->role == '8') {
      $departmentList = $this->user_model->getDepartmentList($warehouseId);
    } else {
      $departmentList = $this->user_model->getDepartmentList($warehouseId);
    }
    $data['department_id'] = $this->session->userdata('department_id');
    $data['warehouseList'] = $warehouseList;
    $data['departmentList'] = $departmentList;
    $this->loadViews("ticket_view", $this->global, $data, NULL);
  }

  public function ticketDetailforedit() {
    if (!$this->input->is_ajax_request()) {
      exit('No direct script access allowed');
    }
    $ticketId = $this->input->post('ticketId');
    $this->db->where('id', $ticketId);
    $ticketDetail = $this->db->get('tbl_tickets')->row_array();
    if (!empty($ticketDetail)) {
      $ticketDetail['start_date'] = date('d-m-Y', strtotime($ticketDetail['start_date']));
      $ticketDetail['due_date'] = date('d-m-Y', strtotime($ticketDetail['due_date']));
      $ticketDetail['ticket_file'] = json_decode($ticketDetail['ticket_file']);
      $this->db->select('tbl_users.name,tbl_users.userId as user_id,emp_code');
      $this->db->where('ticket_no', $ticketId);
      $this->db->join('tbl_users', 'tbl_users.userId=tbl_ticket_assign_user.assign_user');
      $assignUsers = $this->db->get('tbl_ticket_assign_user')->result_array();
      $ticketDetail['assignuser'] = $assignUsers;
    }
    echo json_encode($ticketDetail);
    exit;
  }

  public function viewTickets($ticketId) {
    $ticketInfo = $this->user_model->getTicketDetail($ticketId);
    if (!empty($ticketInfo)) {
      $ticketInfo['created_by'] = $this->user_model->getUserName($ticketInfo['user_id']);
    }
    $ticketAssignUser = $this->user_model->getTicketAssignUserList($ticketId);
    $assignUserIds = array();
    $assignUserName = '';
    if (!empty($ticketAssignUser)) {
      foreach ($ticketAssignUser as $assignusr) {
        $assignUserIds[] = $assignusr['userid'];
        $assignUserName .= ucfirst($assignusr['name']) . ', ';
      }
    }
    $assignUserName = trim($assignUserName, ', ');
    $data['assignUserIds'] = $assignUserIds;
    $data['assignUserName'] = $assignUserName;
    $data['ticketInfo'] = $ticketInfo;
    $data['ticket_id'] = $ticketId;
    $data['loginUserId'] = $this->session->userdata('userId');
    $data['ticketcommentList'] = $this->user_model->getTicketCommentList($ticketId);
    $orgId = '';
    if ($this->role == '2' || $this->role == '4' || $this->role == 8) {
      $orgId = $this->organization_id;
    }
    $warehouseList = $this->user_model->getOrganizationList($orgId);
    $warehouseId = isset($warehouseList[0]['id']) ? $warehouseList[0]['id'] : '';
    if (!empty($assignUserIds)) {
      $assignUsrId = $assignUserIds[0];
      $this->db->select('organization_id,department_id');
      $this->db->where('userId', $assignUsrId);
      $assignInfo = $this->db->get('tbl_users')->row_array();
      $data['assignwarehouse'] = $warehouseId = isset($assignInfo['organization_id']) ? $assignInfo['organization_id'] : '';
      $data['assigndept'] = isset($assignInfo['department_id']) ? $assignInfo['department_id'] : '';
    }
    if ($this->role == '1') {
      $departmentList = $this->user_model->getDepartmentList($warehouseId);
    } else {
      $departmentList = $this->user_model->getDepartmentList($warehouseId);
    }
    $data['warehouseList'] = $warehouseList;
    $data['departmentList'] = $departmentList;
    $data['department_id'] = $this->session->userdata('department_id');
    $this->global['pageTitle'] = 'Searbird : Tickets';
    $this->loadViews("ticket_detail_view", $this->global, $data, NULL);
  }

  public function updateTicketStatus() {
    if (!$this->input->is_ajax_request()) {
      exit('No direct script access allowed');
    }
    $userId = $this->session->userdata('userId');
    $ticketId = $this->input->post('ticketId');
    $status = $this->input->post('status');
    if ($ticketId != '' && $status != '') {
      $this->db->where('id', $ticketId);
      $this->db->update('tbl_tickets', ['status' => $status]);
      $userName = $this->global ['name'];
      $logAttribute = array();
      $logAttribute['ticket_id'] = $ticketId;
      $custicket = sprintf("%'.05d\n", $ticketId);
      $statusName = '';
      if ($status == '0') {
        $statusName = 'Open';
      } elseif ($status == '1') {
        $statusName = 'Close';
      } elseif ($status == '2') {
        $statusName = 'Reopen';
      }
      $logAttribute['log'] = $userName . ' change the status to ' . $statusName;
      $this->db->insert('tbl_ticket_logs', $logAttribute);
      $this->db->select('tbl_users.name,tbl_users.email');
      $this->db->where("tbl_tickets.id", $ticketId);
      $this->db->join('tbl_users', 'tbl_users.userId=tbl_tickets.user_id');
      $createdUsers = $this->db->get('tbl_tickets')->row_array();
      $this->db->select('tbl_users.name,tbl_users.email');
      $this->db->where("tbl_users.userId != '" . $userId . "'");
      $this->db->join('tbl_users', 'tbl_users.userId=tbl_ticket_assign_user.assign_user');
      $assignUsers = $this->db->get('tbl_ticket_assign_user')->result_array();
      $assignUserEmail = array();
      if (!empty($assignUsers)) {
        foreach ($assignUsers as $usr) {
          $assignUserEmail[] = array('email' => $usr['email'], 'name' => $usr['name']);
        }
      }
      if (!empty($createdUsers)) {
        $assignUserEmail[] = array('email' => $createdUsers['email'], 'name' => $createdUsers['name']);
      }
      $mailAttribute = array();
      $mailAttribute['receivedUser'] = $assignUserEmail;
      $mailAttribute['changeStatusByUser'] = $this->name;
      $mailAttribute['newTicketStatus'] = $statusName;
      $custicket = sprintf("%'.05d\n", $ticketId);
      $mailAttribute['ticketId'] = $custicket;
      $mailAttribute['message'] = $ticketcommenttext;
      $sendStatus = sendticketstatusEmail($mailAttribute);
    }
    echo json_encode('SUCCESS');
  }

  public function addticketComment() {
    if (!$this->input->is_ajax_request()) {
      exit('No direct script access allowed');
    }
    $userId = $this->session->userdata('userId');
    $ticket_id = $this->input->post('ticket_id');
    $ticketcommenttext = ($this->input->post('ticketcommenttext'));
    $ticketcommentfile = '';
    if ($_FILES["ticketcommentfile"]["size"] <= 0 && $ticketcommenttext == '') {
      echo json_encode('FAILED');
      exit;
    }
    $ticketFile = array();
    $ticketcommentfileUrl = array();
    $filesCount = count($_FILES['ticketcommentfile']['name']);
    for ($i = 0; $i < $filesCount; $i++) {
      $_FILES['file']['name'] = $_FILES['ticketcommentfile']['name'][$i];
      $_FILES['file']['type'] = $_FILES['ticketcommentfile']['type'][$i];
      $_FILES['file']['tmp_name'] = $_FILES['ticketcommentfile']['tmp_name'][$i];
      $_FILES['file']['error'] = $_FILES['ticketcommentfile']['error'][$i];
      $_FILES['file']['size'] = $_FILES['ticketcommentfile']['size'][$i];
      if ($_FILES['file']['size'] > 0) {
        $config['upload_path'] = BASE_PATH . 'assets/images/tickets/';
        $config['allowed_types'] = 'gif|jpg|png|jpeg|csv|xls|xlsx|docx|txt|pdf';
        $config['encrypt_name'] = TRUE;
        $this->load->library('upload', $config);
        if ($this->upload->do_upload('file')) {
          $avatarInfo = $this->upload->data();
          $ticketFile[] = $avatarInfo['file_name'];
          $ticketcommentfileUrl[] = site_url('assets/images/tickets/' . $avatarInfo['file_name']);
        }
      }
    }

    $ticketcommentfile = json_encode($ticketFile);

    /* if($_FILES["ticketcommentfile"]["size"] > 0){

      $config['upload_path']          = BASE_PATH.'/assets/images/tickets/';
      $config['allowed_types']        = 'gif|jpg|png|xls|xlsx|csv|pdf|jpeg';
      //$config['max_width']            = 1024;
      //$config['max_height']           = 768;
      $config['encrypt_name']         = TRUE;
      $this->load->library('upload', $config);
      if($this->upload->do_upload('ticketcommentfile')){
      $avatarInfo = $this->upload->data();
      $ticketcommentfile = $avatarInfo['file_name'];

      }else{
      echo $this->upload->display_errors();die;

      }
      } */

    $userName = $this->user_model->getUserName($userId);
    $attr = array('user_id' => $userId, 'ticket_id' => $ticket_id, 'comment' => $ticketcommenttext, 'files' => $ticketcommentfile, 'created_at' => date('Y-m-d H:i:s'));
    $this->db->insert('tbl_ticket_comments', $attr);

    /*  $ticketcommentfileUrl = '';
      if($ticketcommentfile != ''){
      $ticketcommentfileUrl = site_url('assets/images/tickets/'.$ticketcommentfile);
      } */


    $this->db->select('tbl_users.name,tbl_users.email');
    $this->db->where("tbl_tickets.id", $ticket_id);
    $this->db->join('tbl_users', 'tbl_users.userId=tbl_tickets.user_id');
    $createdUsers = $this->db->get('tbl_tickets')->row_array();
    error_reporting(0);
    $this->db->select('tbl_users.name,tbl_users.email');
    $this->db->where("tbl_users.userId != '" . $userId . "'");
    $this->db->join('tbl_users', 'tbl_users.userId=tbl_ticket_assign_user.assign_user');
    $assignUsers = $this->db->get('tbl_ticket_assign_user')->result_array();
    $assignUserEmail = array();
    if (!empty($assignUsers)) {
      foreach ($assignUsers as $usr) {
        $assignUserEmail[] = array('email' => $usr['email'], 'name' => $usr['name']);
      }
    }
    if (!empty($createdUsers)) {
      $assignUserEmail[] = array('email' => $createdUsers['email'], 'name' => $createdUsers['name']);
    }
    $mailAttribute = array();
    $mailAttribute['receivedUser'] = $assignUserEmail;
    $mailAttribute['commentUserName'] = $this->name;
    $custicket = sprintf("%'.05d\n", $ticket_id);
    $mailAttribute['ticketId'] = $custicket;
    $mailAttribute['message'] = $ticketcommenttext;
    $sendStatus = sendticketcommentEmail($mailAttribute);
    echo json_encode(['status' => 'SUCCESS', 'comment' => $ticketcommenttext, 'file' => $ticketcommentfile, 'fileurl' => $ticketcommentfileUrl, 'name' => $userName, 'datetime' => date('d-m-Y H:i')]);
  }

  public function getSearchEmployee() {
    if (!$this->input->is_ajax_request()) {
      exit('No direct script access allowed');
    }
    $term = $this->input->post('term')['term'];
    $rolePriority = $this->input->post('rolePriority');
    $userId = $this->session->userdata('userId');
    $this->db->select('userId as id,userId as slug,CONCAT(name, \' - \', emp_code) AS text');
    if ($userId != '1') {
      $this->db->where('organization_id', $this->organization_id);
    }
    $this->db->where_not_in('tbl_users.roleId', ['1', $userId]);
    $this->db->where('tbl_roles.roleId < ', $rolePriority);
    $this->db->where("(name LIKE '%" . $term . "%' OR emp_id LIKE '%" . $term . "%' OR emp_code LIKE '%" . $term . "%')");
    $this->db->join('tbl_roles', 'tbl_roles.roleId=tbl_users.roleId', 'left');
    $employeeList = $this->db->get('tbl_users')->result_array();
    echo json_encode($employeeList);
  }

  public function getticketslisting() {
    if (!$this->input->is_ajax_request()) {
      exit('No direct script access allowed');
    }
    $draw = intval($this->input->post("draw"));
    $start = intval($this->input->post("start"));
    $length = intval($this->input->post("length"));
    $search = $this->input->post('search[value]');
    $userId = $this->session->userdata('userId');
    $type = $this->input->post('type');

    /*     * ****Filter option**** */
    $ticketId = $this->input->post('ticketId');
    $subject = $this->input->post('subject');
    $assignUser = $this->input->post('assignUser');
    $start_date = $this->input->post('start_date');
    $due_date = $this->input->post('due_date');
    $ticket_priority = $this->input->post('ticket_priority');



    /* ============Start get count============ */
    $orgId = '';
    if ($this->role != '1') {
      $orgId = $this->organization_id;
      $this->db->where('tbl_users.organization_id', $orgId);
    }

    if ($this->role != '1' && $this->role != '8') {
      /* $this->db->where('tbl_ticket_assign_user.assign_user',$userId);
        $this->db->or_where('tbl_tickets.user_id',$userId); */
      $this->db->where("(tbl_ticket_assign_user.assign_user = '" . $userId . "' OR tbl_tickets.user_id = '" . $userId . "')");
    }

    if ($type == '0') {

      //$this->db->where('tbl_tickets.status','0');
      $this->db->where("(tbl_tickets.status = '0' OR tbl_tickets.status = '2')");
    } elseif ($type == '1') {

      $this->db->where('tbl_tickets.status', '1');
    }

    if ($ticketId != '') {
      $this->db->like('tbl_tickets.ticket_no', $ticketId);
    }
    if ($subject != '') {
      $this->db->like('tbl_tickets.subject', $subject);
    }

    if ($start_date != '') {
      $start_date = date('Y-m-d', strtotime($start_date));
      $this->db->like('tbl_tickets.start_date', $start_date);
    }

    if ($due_date != '') {
      $due_date = date('Y-m-d', strtotime($due_date));
      $this->db->like('tbl_tickets.due_date', $due_date);
    }
    if ($ticket_priority != '') {
      $this->db->where("tbl_tickets.priority like '" . $ticket_priority . "'");
    }

    if ($assignUser != '') {
      $this->db->where('tbl_ticket_assign_user.assign_user', $assignUser);
    }

    if ($search != '') {
      $this->db->where("(tbl_tickets.subject LIKE '%" . $search . "%' OR tbl_tickets.ticket_no LIKE '%" . $search . "%' OR tbl_users.name LIKE '%" . $search . "%')");
    }

    $this->db->from('tbl_ticket_assign_user');
    $this->db->join('tbl_tickets', 'tbl_tickets.id=tbl_ticket_assign_user.ticket_no');
    $this->db->join('tbl_users', 'tbl_users.userId=tbl_ticket_assign_user.assign_user', 'LEFT');
    $this->db->order_by('tbl_tickets.created_at', 'DESC');
    $this->db->group_by('tbl_ticket_assign_user.ticket_no');
    $totalrows = $this->db->get()->num_rows();


    /* ============End get count============ */

    /* ============Start get list============ */

    $this->db->select('tbl_tickets.*');
    $orgId = '';
    if ($this->role != '1') {
      $orgId = $this->organization_id;
      $this->db->where('tbl_users.organization_id', $orgId);
    }
    if ($this->role != '1' && $this->role != '8') {
      /* $this->db->where('tbl_ticket_assign_user.assign_user',$userId);
        $this->db->or_where('tbl_tickets.user_id',$userId); */
      $this->db->where("(tbl_ticket_assign_user.assign_user = '" . $userId . "' OR tbl_tickets.user_id = '" . $userId . "')");
    }

    if ($type == '0') {
      $this->db->where("(tbl_tickets.status = '0' OR tbl_tickets.status = '2')");
    } elseif ($type == '1') {
      $this->db->where('tbl_tickets.status', '1');
    }

    if ($ticketId != '') {
      $this->db->like('tbl_tickets.ticket_no', $ticketId);
    }
    if ($subject != '') {
      $this->db->like('tbl_tickets.subject', $subject);
    }

    if ($start_date != '') {
      $start_date = date('Y-m-d', strtotime($start_date));
      $this->db->like('tbl_tickets.start_date', $start_date);
    }

    if ($due_date != '') {
      $due_date = date('Y-m-d', strtotime($due_date));
      $this->db->like('tbl_tickets.due_date', $due_date);
    }
    if ($ticket_priority != '') {

      $this->db->where("tbl_tickets.priority like '" . $ticket_priority . "'");
    }

    if ($assignUser != '') {
      $this->db->where('tbl_ticket_assign_user.assign_user', $assignUser);
    }

    if ($search != '') {
      $this->db->where("(tbl_tickets.subject LIKE '%" . $search . "%' OR tbl_tickets.ticket_no LIKE '%" . $search . "%' OR tbl_users.name LIKE '%" . $search . "%')");
    }

    $this->db->from('tbl_ticket_assign_user');
    $this->db->join('tbl_tickets', 'tbl_tickets.id=tbl_ticket_assign_user.ticket_no');
    $this->db->join('tbl_users', 'tbl_users.userId=tbl_ticket_assign_user.assign_user', 'LEFT');
    $this->db->order_by('tbl_tickets.created_at', 'DESC');
    $this->db->group_by('tbl_ticket_assign_user.ticket_no');
    $this->db->limit($length, $start);
    $query = $this->db->get();
    $filterrecord = $query->num_rows();
    $results = $query->result_array();

    /* ============End get list============ */
    $data = array();
    if (!empty($results)) {
      foreach ($results as $ticket) {
        $attr = array();
        $assigntoName = $this->user_model->getTicketAssign($ticket['id']);

        $attr[] = '<h4>' . $ticket['subject'] . '</h4><br><b>Assign to</b> ' . $assigntoName . '<br><b>Assignee</b> ' . $this->user_model->getUserName($ticket['user_id']);
        $attr[] = '<span class="label label-' . strtolower($ticket['priority']) . '">' . $ticket['priority'] . '</span>';
        $attr[] = $ticket['ticket_no'];


        $this->db->where('ticket_id', $ticket['id']);
        $this->db->order_by('created_at', 'DESC');
        $this->db->limit(1);
        $lastcomment = $this->db->get('tbl_ticket_comments')->row_array();

        $attr[] = isset($lastcomment['created_at']) ? date('d-m-Y h:i a', strtotime($lastcomment['created_at'])) : '';

        $statusText = '';

        if ($ticket['status'] == 0) {
          $statusText = 'pending';
        } elseif ($ticket['status'] == 2) {
          $statusText = 'reopen';
        } else {
          $statusText = 'complete';
        }
        $attr[] = '<span class="label label-' . $statusText . '">' . ucfirst($statusText) . '</span>';
        $attr[] = date('d-m-Y', strtotime($ticket['due_date']));

        if ($ticket['user_id'] == $userId || $this->role == '1') {
          //<a style="margin-left:5px" href="javascript:void(0)" class="btn btn-warning" onclick="openEdirTicketForm(\''.$ticket['id'].'\')">Edit</a>
          $editTicketHtml = ' <a onclick="return confirm(\'Are you sure ?\')" href="' . site_url('delete-ticket/' . $ticket['id']) . '" class="btn btn-danger">Delete</a>&nbsp;';
        } else {
          $editTicketHtml = '';
        }


        $attr[] = '<a href="' . site_url('view-tickets/' . $ticket['id']) . '" class="btn btn-default">View</a> &nbsp;' . $editTicketHtml;
        $data[] = $attr;
      }
    }
    $output = array(
        "draw" => $draw,
        "recordsTotal" => $totalrows,
        "recordsFiltered" => $filterrecord,
        "data" => $data
    );
    echo json_encode($output);
    exit();
  }

  public function deleteTicket($ticketId) {

    $this->db->where('ticket_id', $ticketId);
    $this->db->delete('tbl_ticket_comments');

    $this->db->where('ticket_no', $ticketId);
    $this->db->delete('tbl_ticket_assign_user');

    $this->db->where('id', $ticketId);
    $this->db->delete('tbl_tickets');

    $this->session->set_flashdata('success', 'Ticket deleted successfully');
    redirect(site_url('support-tickets'));
  }

  function updateTicket() {
    if (!$this->input->is_ajax_request()) {
      exit('No direct script access allowed');
    }
    $editticketId = $this->input->post('editticketId');
    $ticketsubject = $this->security->xss_clean($this->input->post('editticketsubject'));
    $ticketassignto = $this->input->post('editticketassignto');
    $ticketstartdate = $this->input->post('editticketstartdate');
    $ticketduedate = $this->input->post('editticketduedate');
    $ticketpriority = $this->input->post('editticketpriority');
    $ticketdescription = $this->security->xss_clean($this->input->post('editticketdescription'));
    if ($ticketstartdate != '') {
      $ticketstartdate = date('Y-m-d', strtotime($ticketstartdate));
    }
    if ($ticketduedate != '') {
      $ticketduedate = date('Y-m-d', strtotime($ticketduedate));
    }
    $oldFiles = array();
    if ($this->input->post('oldfile')) {
      $oldFiles = $this->input->post('oldfile');
    }
    $filesCount = count($_FILES['editticketfile']['name']);
    for ($i = 0; $i < $filesCount; $i++) {
      $_FILES['file']['name'] = $_FILES['editticketfile']['name'][$i];
      $_FILES['file']['type'] = $_FILES['editticketfile']['type'][$i];
      $_FILES['file']['tmp_name'] = $_FILES['editticketfile']['tmp_name'][$i];
      $_FILES['file']['error'] = $_FILES['editticketfile']['error'][$i];
      $_FILES['file']['size'] = $_FILES['editticketfile']['size'][$i];
      if ($_FILES['file']['size'] > 0) {
        $config['upload_path'] = BASE_PATH . '/assets/images/tickets/';
        $config['allowed_types'] = ' gif|jpg|png|jpeg|csv|xls|xlsx|pdf|docx|txt';
        $config['encrypt_name'] = TRUE;
        $this->load->library('upload', $config);
        if ($this->upload->do_upload('file')) {
          $avatarInfo = $this->upload->data();
          $oldFiles[] = $avatarInfo['file_name'];
        }
      }
    }
    $attribute = array('subject' => $ticketsubject, 'start_date' => $ticketstartdate, 'due_date' => $ticketduedate, 'priority' => $ticketpriority, 'ticket_file' => json_encode($oldFiles), 'description' => $ticketdescription);
    $this->db->where('id', $editticketId);
    $this->db->update('tbl_tickets', $attribute);
    $oldUserArray = array();
    $this->db->where('ticket_no', $editticketId);
    $oldusers = $this->db->get('tbl_ticket_assign_user')->result_array();
    if (!empty($oldusers)) {
      foreach ($oldusers as $usr) {
        $oldUserArray[] = $usr['assign_user'];
      }
    }
    $assignToUser = $this->input->post('editticketassignto');
    $this->db->where('ticket_no', $editticketId);
    $this->db->delete('tbl_ticket_assign_user');
    $custicket = sprintf("%'.05d\n", $editticketId);
    if (!empty($assignToUser)) {
      foreach ($assignToUser as $assignUser) {
        $this->db->insert('tbl_ticket_assign_user', ['ticket_no' => $editticketId, 'assign_user' => $assignUser]);
        $EmployeeInfo = $this->user_model->getUserInfoById($assignUser);
        if (!empty($EmployeeInfo)) {
          $mailAttribute = array();
          $mailAttribute['email'] = isset($EmployeeInfo->email) ? strtolower($EmployeeInfo->email) : '';
          $mailAttribute['name'] = isset($EmployeeInfo->name) ? $EmployeeInfo->name : '';
          $mailAttribute['ticketnumber'] = $custicket;
          $mailAttribute['fromUser'] = $this->global ['name'];
          $mailAttribute['ticketId'] = $editticketId;
          $sendStatus = sendnewticketEmail($mailAttribute);
        }
        if ($assignUser) {
          $notificationAttribute = array('title' => 'Ticket  ' . $custicket . ' created for you', 'type' => 'newticket', 'user_id' => $assignUser, 'message' => '', 'object_id' => $editticketId);
          $this->db->insert('tbl_notification', $notificationAttribute);
        }
      }
    }

    echo json_encode('SUCCESS');
  }

  public function addNewtTicket() {
    if (!$this->input->is_ajax_request()) {
      exit('No direct script access allowed');
    }
    $ticketsubject = $this->security->xss_clean($this->input->post('ticketsubject'));
    $ticketassignto = $this->input->post('ticketassignto');
    $ticketstartdate = $this->input->post('ticketstartdate');
    $ticketduedate = $this->input->post('ticketduedate');
    $ticketpriority = $this->input->post('ticketpriority');
    $ticketdescription = $this->security->xss_clean($this->input->post('ticketdescription'));
    $ticketsubject = $this->security->xss_clean($this->input->post('ticketsubject'));
    if ($ticketstartdate != '') {
      $ticketstartdate = date('Y-m-d', strtotime($ticketstartdate));
    }
    if ($ticketduedate != '') {
      $ticketduedate = date('Y-m-d', strtotime($ticketduedate));
    }

    $ticketFile = array();
    $filesCount = count($_FILES['ticketfile']['name']);

    for ($i = 0; $i < $filesCount; $i++) {
      $_FILES['file']['name'] = $_FILES['ticketfile']['name'][$i];
      $_FILES['file']['type'] = $_FILES['ticketfile']['type'][$i];
      $_FILES['file']['tmp_name'] = $_FILES['ticketfile']['tmp_name'][$i];
      $_FILES['file']['error'] = $_FILES['ticketfile']['error'][$i];
      $_FILES['file']['size'] = $_FILES['ticketfile']['size'][$i];
      if ($_FILES['file']['size'] > 0) {
        $config['upload_path'] = BASE_PATH . '/assets/images/tickets/';
        $config['allowed_types'] = ' gif|jpg|png|jpeg|csv|xls|xlsx|docx|txt|pdf';
        $config['encrypt_name'] = TRUE;
        $this->load->library('upload', $config);
        if ($this->upload->do_upload('file')) {
          $avatarInfo = $this->upload->data();
          $ticketFile[] = $avatarInfo['file_name'];
        }
      }
    }


    $userId = $this->session->userdata('userId');
    $attribute = array('user_id' => $userId, 'subject' => $ticketsubject, 'ticket_no' => '', 'start_date' => $ticketstartdate, 'due_date' => $ticketduedate, 'priority' => $ticketpriority, 'ticket_file' => json_encode($ticketFile), 'description' => $ticketdescription, 'created_at' => date('Y-m-d H:i:s'));
    $this->db->insert('tbl_tickets', $attribute);
    $ticketId = $this->db->insert_id();
    if ($ticketId) {
      $custicket = sprintf("%'.05d", $ticketId);
      $this->db->where('id', $ticketId);
      $this->db->update('tbl_tickets', ['ticket_no' => $custicket]);

      $assignToUser = $this->input->post('ticketassignto');

      if (!empty($assignToUser)) {
        foreach ($assignToUser as $assignUser) {
          $this->db->insert('tbl_ticket_assign_user', ['ticket_no' => $ticketId, 'assign_user' => $assignUser]);

          $EmployeeInfo = $this->user_model->getUserInfoById($assignUser);
          if (!empty($EmployeeInfo)) {
            $mailAttribute = array();
            $mailAttribute['email'] = isset($EmployeeInfo->email) ? strtolower($EmployeeInfo->email) : '';
            $mailAttribute['name'] = isset($EmployeeInfo->name) ? $EmployeeInfo->name : '';
            $mailAttribute['ticketnumber'] = $custicket;
            $mailAttribute['fromUser'] = $this->global ['name'];
            $mailAttribute['ticketId'] = $ticketId;
            $sendStatus = sendnewticketEmail($mailAttribute);
          }

          if ($assignUser) {
            $notificationAttribute = array('title' => 'Ticket  ' . $custicket . ' created for you', 'type' => 'newticket', 'user_id' => $assignUser, 'message' => '', 'object_id' => $ticketId);
            $this->db->insert('tbl_notification', $notificationAttribute);
          }
        }
      }

      $logAttribute = array();
      $logAttribute['ticket_id'] = $ticketId;
      $userName = $this->global ['name'];
      $logAttribute['log'] = $userName . ' created a ticket';
      $this->db->insert('tbl_ticket_logs', $logAttribute);
    }
    echo json_encode('SUCCESS');
  }

}
