<?php

if (!defined('BASEPATH'))
  exit('No direct script access allowed');

require APPPATH . '/libraries/BaseController.php';

/**
 * Class : User (UserController)
 * User Class to control all user related operations.
 * @author : Vijayraj Chaudhary
 * @version : 2.1
 * @since : 15 November 2019
 */
class ShiftController extends BaseController {

  /**
   * This is default constructor of the class
   */
  public function __construct() {
    parent::__construct();
    $this->load->model('user_model');
    $this->load->model('shift_model');
    $this->isLoggedIn();
    date_default_timezone_set('Asia/Kolkata');
  }

  function delshift($shiftId) {
    $this->db->where('id', $shiftId);
    $this->db->delete('shift_mgmt');
    $this->session->set_flashdata('success', 'Shift Deleted Successfully');
    redirect(site_url('shift'));
  }

  function getShiftMgmtListBySubDeptId() {
    if (!$this->input->is_ajax_request()) {
      exit('No direct script access allowed');
    }
    if (!in_array($this->role, ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'])) {
      $this->loadThis();
    } else {
      $subDeptId = $this->input->post('subDeptId');
      $shiftList = $this->shift_model->getShiftListBySubDeptId($subDeptId);
      //pre($shiftList);
      $html = "<option value=''>Select Shift</option>";
      if (!empty($shiftList)) {
        foreach ($shiftList as $key => $shift) {
          $html .= "<option value='" . $shift['id'] . "'>" . $shift['shift_name'] . "</option>";
        }
      }
      echo json_encode($html);
    }
  }

  function shift($shiftId = '') {
    if (!in_array($this->role, ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'])) {
      $this->loadThis();
    } else {
      if ($this->input->post()) {
        $this->form_validation->set_rules('dept_name', 'Department Name', 'required');
        $this->form_validation->set_rules('sub_dept_name', 'Sub Department Name', 'required');
        $this->form_validation->set_rules('supervisor_name', 'Supervisor Name', 'required');
        $this->form_validation->set_rules('shift', 'Shift', 'required');
        $this->form_validation->set_rules('shift_in_time', 'Shift in Time', 'required');
        $this->form_validation->set_rules('shift_out_time', 'Shift out Time', 'required');
        if ($this->form_validation->run() === TRUE) {
          $orgId = $this->organization_id;
          $deptId = $this->input->post('dept_name');
          $subDeptId = $this->input->post('sub_dept_name');
          $supervisorId = $this->input->post('supervisor_name');
          $shift = $this->input->post('shift');
          $shiftInTime = $this->input->post('shift_in_time');
          $shiftOutTime = $this->input->post('shift_out_time');
          $this->db->insert('shift_mgmt', ['org_id' => $orgId, 'dept_id' => $deptId, 'sub_dept_id' => $subDeptId, 'superviser_id' => $supervisorId, 'shift' => $shift, 'in_time' => $shiftInTime, 'out_time' => $shiftOutTime]);
          $this->session->set_flashdata('success', 'New Shift Created Successfully');
          redirect(site_url('shift'));
        }
      }
      if ($shiftId) {
        $data['shiftInfo'] = $this->shift_model->getShiftInfo($shiftId);
//        pre($data['shiftInfo']);
      }
      //echo 'jhjhjhh';
      $orgId = '';
      if (in_array($this->role, ['2', '4', '5', '6', '8', '9', '14', '11', '12'])) {
        $orgId = $this->organization_id;
      }
      // pre($data);

      $this->global['pageTitle'] = 'Searbird : Shift';
      $data['departmentList'] = $departmentList = $this->user_model->getDepartmentList($orgId);

      $deptId = isset($departmentList[0]['dept_id']) ? $departmentList[0]['dept_id'] : '';
      if ($shiftId) {
        $data['subDepartmentList'] = $subDepartmentList = $this->user_model->getSubDepartmentList($data['shiftInfo']['dept_id'], $subDepartmentId = '', $withManPowerCount = '0');

//        pre($data['shiftInfo']);
      } else {
        $data['subDepartmentList'] = $subDepartmentList = $this->user_model->getSubDepartmentList($deptId, $subDepartmentId = '', $withManPowerCount = '0');
      }
      // pre($data);
      $subDeptId = isset($subDepartmentList[0]['id']) ? $subDepartmentList[0]['id'] : '';
      $data['supervisorList'] = supervisersBySubDeptId($subDeptId);
      //pre($data);
      $data['shiftList'] = allShiftList();
      //pre($data);
      $this->loadViews("shift-view", $this->global, $data, NULL);
    }
  }

  function updateshift() {
    if (!in_array($this->role, ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'])) {
      $this->loadThis();
    } else {
      $shiftId = $this->input->post('shift_id');
      if ($this->input->post()) {
        $this->form_validation->set_rules('dept_name', 'Department Name', 'required');
        $this->form_validation->set_rules('sub_dept_name', 'Sub Department Name', 'required');
        $this->form_validation->set_rules('supervisor_name', 'Supervisor Name', 'required');
        $this->form_validation->set_rules('shift', 'Shift', 'required');
        $this->form_validation->set_rules('shift_in_time', 'Shift in Time', 'required');
        $this->form_validation->set_rules('shift_out_time', 'Shift out Time', 'required');
        if ($this->form_validation->run() === TRUE) {
          $orgId = $this->organization_id;
          $deptId = $this->input->post('dept_name');
          $subDeptId = $this->input->post('sub_dept_name');
          $supervisorId = $this->input->post('supervisor_name');
          $shift = $this->input->post('shift');
          $shiftInTime = $this->input->post('shift_in_time');
          $shiftOutTime = $this->input->post('shift_out_time');
          $this->db->where('id', $shiftId);
          $this->db->update('shift_mgmt', ['org_id' => $orgId, 'dept_id' => $deptId, 'sub_dept_id' => $subDeptId, 'superviser_id' => $supervisorId, 'shift' => $shift, 'in_time' => $shiftInTime, 'out_time' => $shiftOutTime]);
          $this->session->set_flashdata('success', 'Sub Department updated successfully');
          redirect(site_url('shift'));
          exit;
        }
      }
      redirect(site_url('shift'));
    }
  }

}
