<?php

defined('BASEPATH') OR exit('No direct script access allowed');

/*
  | -------------------------------------------------------------------------
  | URI ROUTING
  | -------------------------------------------------------------------------
  | This file lets you re-map URI requests to specific controller functions.
  |
  | Typically there is a one-to-one relationship between a URL string
  | and its corresponding controller class/method. The segments in a
  | URL normally follow this pattern:
  |
  |	example.com/class/method/id/
  |
  | In some instances, however, you may want to remap this relationship
  | so that a different class/function is called than the one
  | corresponding to the URL.
  |
  | Please see the user guide for complete details:
  |
  |	https://codeigniter.com/user_guide/general/routing.html
  |
  | -------------------------------------------------------------------------
  | RESERVED ROUTES
  | -------------------------------------------------------------------------
  |
  | There are three reserved routes:
  |
  |	$route['default_controller'] = 'welcome';
  |
  | This route indicates which controller class should be loaded if the
  | URI contains no data. In the above example, the "welcome" class
  | would be loaded.
  |
  |	$route['404_override'] = 'errors/page_missing';
  |
  | This route will tell the Router which controller/method to use if those
  | provided in the URL cannot be matched to a valid route.
  |
  |	$route['translate_uri_dashes'] = FALSE;
  |
  | This is not exactly a route, but allows you to automatically route
  | controller and method names that contain dashes. '-' isn't a valid
  | class or method name character, so it requires translation.
  | When you set this option to TRUE, it will replace ALL dashes in the
  | controller and method URI segments.
  |
  | Examples:	my-controller/index	-> my_controller/index
  |		my-controller/my-method	-> my_controller/my_method
 */

$route['default_controller'] = "login";
$route['404_override'] = 'error_404';
$route['ticketDetailforedit'] = 'TicketController/ticketDetailforedit';

/* * ********* USER DEFINED ROUTES ****************** */

$route['loginMe'] = 'login/loginMe';
$route['dashboard'] = 'user';
$route['logout'] = 'user/logout';
$route['userListing'] = 'user/userListing';
$route['downloademployee'] = 'User/downloadEmployee';
$route['downloademployeeall'] = 'User/downloadEmployeeAll';
$route['userAttendance'] = 'user/userAttendance';
$route['getuserajaxlisting'] = 'user/getuserajaxlisting';
$route['getuserajaxlistingall'] = 'user/getuserajaxlistingall';
$route['updateattendancestatus'] = 'user/updateattendancestatus';
$route['getuserattendancelist'] = 'user/getuserattendancelist';
$route['downloademployeeattendance'] = 'user/downloademployeeattendance';
$route['userattendancelist'] = 'user/userattendancelist';
$route['getalluserattendancelist'] = 'user/getalluserattendancelist';
$route['getdepartmentlist'] = "user/getdepartmentlist";
$route['getsubdepartmentlist'] = "user/getsubdepartmentlist";
$route['benchmark'] = "user/benchMark";
$route['getdepartment_benchmark'] = "User/getdepartment_benchmark";
$route['getprevioussupervisor'] = "User/getprevioussupervisor";
$route['getdeptemployee'] = "User/getdeptemployee";

$route['getlocationlist'] = "user/getlocationlist";
$route['getdepartmentajax/(:num)'] = "user/getdepartmentajax/$1";
$route['getmaindepartmentajax/(:num)'] = "user/getmaindepartmentajax/$1";
$route['getdepartmentlistnew'] = "user/getdepartmentlistnew";
$route['getclientlist'] = "user/getclientlist";
$route['getsubdepartmentlistajax'] = "user/getsubdepartmentlistajax";
$route['userListing/(:num)'] = "user/userListing/$1";
$route['employee/view/(:num)'] = "user/view/$1";
$route['addNew'] = "user/addNew";
$route['organization'] = "user/organization";
$route['department'] = "user/department";
$route['sub-department'] = "user/subDepartment";
$route['department/(:num)'] = "user/department/$1";
$route['sub-department/(:num)'] = "user/subDepartment/$1";
$route['warehouse-meeting-location/(:num)'] = "user/meetingLocation/$1";

$route['updatedepartment'] = "user/updatedepartment";
$route['updatesubdepartment'] = "user/updatesubdepartment";
$route['updatelocation'] = "user/updatelocation";
$route['warehouse-meeting-location'] = "user/meetingLocation";
$route['organization/(:num)'] = "user/organization/$1";
$route['updateorganization'] = "user/updateorganization";
$route['delorganization/(:num)'] = "user/delorganization/$1";
$route['deldepartment/(:num)'] = "user/deldepartment/$1";
$route['delsubdepartment/(:num)'] = "user/delsubdepartment/$1";
$route['delwarehouselocation/(:num)'] = "user/delwarehouselocation/$1";
$route['addnewdepartment'] = "user/addnewdepartment";
$route['visitors'] = "VisitorController/visitors";
$route['visitors-listing'] = "VisitorController/visitorsListing";
$route['create-appointment'] = "VisitorController/createAppointment";
$route['addvisitororganization'] = "VisitorController/addvisitororganization";
$route['getvisitorganization'] = "VisitorController/getvisitorganization";
$route['getsearchemployee'] = "TicketController/getSearchEmployee";
$route['getappointmentemployee'] = "VisitorController/getappointmentemployee";
$route['visitor-checkout'] = "VisitorController/visitorCheckout";
$route['getvisitorinformation'] = "VisitorController/getvisitorinformation";

$route['fetchemployeelist'] = "user/fetchemployeelist";
$route['manpower'] = "ManpowerController/index";
$route['sales'] = "SalesController/index";
$route['support-tickets'] = "TicketController/index";
$route['visitor-report'] = "VisitorController/visitorReport";
$route['manpower-report'] = "ManpowerController/manpowerReport";
$route['getpreregistervisit'] = "VisitorController/getPreRegisterVisit";
$route['uploadwebcamimage'] = "VisitorController/uploadwebcamimage";
$route['checkinvisitor'] = "VisitorController/checkinvisitor";
$route['getcheckoutlist'] = "VisitorController/getCheckoutList";
$route['getvisitorreport'] = "VisitorController/getvisitorreport";
$route['checkoutrequest'] = "VisitorController/checkoutrequest";
$route['visitingcard/(:num)'] = "VisitorController/visitingCard/$1";
$route['generatepdf/(:num)'] = "VisitorController/generatePdf/$1";

//Route for matrix
$route['matrix-data'] = "MatrixController/matrixData";
$route['matrix-report'] = "MatrixController/matrixReport";
$route['visitors-listing'] = "MatrixController/matrixListing";
$route['emp-matrix'] = "MatrixController/matrix";

$route['addnewticket'] = "TicketController/addNewtTicket";
$route['updateticket'] = "TicketController/updateTicket";
$route['getticketslisting'] = "TicketController/getticketslisting";
$route['delete-ticket/(:num)'] = "TicketController/deleteTicket/$1";
$route['addticketcomment'] = "TicketController/addticketComment";
$route['sendticketnotification'] = "Login/sendTicketNotificationEmail";

$route['getfloorsalescalculation'] = "user/getfloorsalescalculation";

/** Manpower Routes (Team Routes) */
$route['gethoursbetweentime'] = "ManpowerController/getTotalHours";
$route['list-teams'] = "ManpowerController/list_teams";
$route['create-team'] = "ManpowerController/create_team";
$route['edit-team/(:num)'] = "ManpowerController/edit_team/$1";
$route['fetch_team_report_markup'] = "ManpowerController/fetch_team_report_markup";
$route['save_shift_start_time'] = "ManpowerController/save_shift_start_time";
$route['submit-team'] = "ManpowerController/submit_team";
$route['view-team'] = "ManpowerController/view_team";
$route['view-manager-team'] = "ManpowerController/view_manager_team";
$route['upload-team-report/(:num)'] = "ManpowerController/upload_team_report/$1";
$route['upload-team-report-co/(:num)'] = "ManpowerController/upload_team_report_co/$1";
$route['create-team-post'] = 'ManpowerController/create_team_post';
$route['fetch_employees_from_team_id_post'] = "ManpowerController/fetch_employees_from_team_id_post";
$route['fetch_add_performance_form'] = 'ManpowerController/fetch_add_performance_form';
$route['add_performance'] = 'ManpowerController/add_performance';
$route['view-report'] = 'ManpowerController/view_report';

$route['manpower-traking-report-view'] = 'ReportController/manpower_traking_report_view';
$route['get-manpower-tracking-report'] = 'ReportController/get_manpower_tracking_report';
$route['manpower-traking-report'] = 'ReportController/manpower_traking_report';
$route['getPerformaceEmployeeBySubDepartmentAjax'] = 'User/getPerformaceEmployeeBySubDepartmentAjax';

$route['view-report-new'] = 'ManpowerController/view_report_new';
$route['view-report-new-one-c-l'] = 'ReportController/view_report_new_one_c_l';
$route['view-report-new-one-c-l-w-d'] = 'ReportController/view_report_new_one_c_l_w_d';
$route['view-report-new-one-c-l-w-d-sd'] = 'ReportController/view_report_new_one_c_l_w_d_sd';
$route['view-report-new-detailed-c-l-w-d'] = 'ReportController/view_report_new_detailed_c_l_w_d';
$route['view-report-new-detailed-c-l-w-d-sd'] = 'ReportController/view_report_new_detailed_c_l_w_d_sd';

$route['get-date-ranged-report-excel'] = 'ManpowerController/get_date_ranged_report_excel';
$route['get-date-ranged-report-excel-new'] = 'ManpowerController/get_date_ranged_report_excel_new';
$route['view-repogetrequestemployeelistrt-new'] = 'ManpowerController/view_report_new';

$route['get-date-ranged-report-excel-new-one'] = 'ReportController/get_date_ranged_report_excel_new_one';
//$route['get-date-ranged-report-excel-new-detailed'] = 'ReportController/get_date_ranged_report_excel_new_detailed';
$route['get-date-ranged-report-excel-new-one-c-l'] = 'ReportController/get_date_ranged_report_excel_new_one_c_l';
$route['get-date-ranged-report-excel-new-one-c-l-w-d'] = 'ReportController/get_date_ranged_report_excel_new_one_c_l_w_d';
$route['get-date-ranged-report-excel-new-one-c-l-w-d-sd'] = 'ReportController/get_date_ranged_report_excel_new_one_c_l_w_d_sd';
$route['get-date-ranged-report-excel-new-detailed-c-l-w-d'] = 'ReportController/get_date_ranged_report_excel_new_detailed_c_l_w_d';
$route['get-date-ranged-report-excel-new-detailed-c-l-w-d-sd'] = 'ReportController/get_date_ranged_report_excel_new_detailed_c_l_w_d_sd';

$route['get-date-ranged-report-excel-new-detailed'] = 'ReportDetailController/get_date_ranged_report_excel_new_detailed';

$route['view-report-new-ftu-c-l-w-d-sd'] = 'ReportFTUController/view_report_new_ftu_c_l_w_d_sd';
$route['get-date-ranged-report-excel-new-ftu'] = 'ReportFTUController/get_date_ranged_report_excel_new_ftu';

$route['download-today-report/(:num)'] = 'ManpowerController/download_today_report/$1';
$route['get_date_range_report_data'] = 'ManpowerController/get_date_range_report_data';
$route['get_date_range_report_new_data'] = 'ManpowerController/get_date_range_report_new_data';
$route['fetch_performance_stats'] = 'ManpowerController/fetch_performance_stats';
$route['get_added_employees_table_markup'] = 'ManpowerController/get_added_employees_table_markup';
$route['get_employees_to_be_added_table_markup'] = 'ManpowerController/get_employees_to_be_added_table_markup';
$route['add_employee_to_team'] = 'ManpowerController/add_employee_to_team';
$route['remove_employee_from_team'] = 'ManpowerController/remove_employee_from_team';
$route['getclientajax'] = "ManpowerController/getClientAjaxList";
$route['update_shift_over'] = "ManpowerController/update_shift_over";
$route['shift-request'] = "ManpowerController/shiftRequest";
$route['getrequestemployeelist'] = "ManpowerController/getRequestEmployeeList";

$route['save_shift_post'] = 'ManpowerController/save_shift_post';
$route['save_client_post'] = 'ManpowerController/save_client_post';
$route['getDepartmentShift'] = 'ManpowerController/getDepartmentShift';
$route['check_and_send_shift_team_request'] = 'ManpowerController/check_and_send_shift_team_request';

$route['edit-team/check_and_send_shift_team_request'] = 'ManpowerController/check_and_send_shift_team_request';

$route['approve_team_shift/(:num)'] = 'ManpowerController/approve_team_shift/$1';

$route['addNewUser'] = "user/addNewUser";
$route['editOld'] = "user/editOld";
$route['editOld/(:num)'] = "user/editOld/$1";
$route['editUser'] = "user/editUser";
$route['deleteUser'] = "user/deleteUser";
$route['profile'] = "user/profile";
$route['profile/(:any)'] = "user/profile/$1";
$route['profileUpdate'] = "user/profileUpdate";
$route['profileUpdate/(:any)'] = "user/profileUpdate/$1";

$route['loadChangePass'] = "user/loadChangePass";
$route['changePassword'] = "user/changePassword";
$route['changePassword/(:any)'] = "user/changePassword/$1";
$route['pageNotFound'] = "user/pageNotFound";

$route['checkEmailExists'] = "user/checkEmailExists";
$route['checkEmployeecode'] = "user/checkEmployeecode";
$route['checkEmployeeUsername'] = "user/checkEmployeeUsername";

$route['login-history'] = "user/loginHistoy";
$route['login-history/(:num)'] = "user/loginHistoy/$1";
$route['login-history/(:num)/(:num)'] = "user/loginHistoy/$1/$2";

$route['forgotPassword'] = "login/forgotPassword";
$route['resetPasswordUser'] = "login/resetPasswordUser";
$route['resetPasswordConfirmUser'] = "login/resetPasswordConfirmUser";
$route['resetPasswordConfirmUser/(:any)'] = "login/resetPasswordConfirmUser/$1";
$route['resetPasswordConfirmUser/(:any)/(:any)'] = "login/resetPasswordConfirmUser/$1/$2";
$route['createPasswordUser'] = "login/createPasswordUser";
$route['view-tickets/(:num)'] = "TicketController/viewTickets/$1";
$route['updateticketstatus'] = "TicketController/updateTicketStatus";
$route['clients/(:num)'] = "ManpowerController/clients/$1";
$route['clients'] = "ManpowerController/clients";
$route['updateclient/(:num)'] = "ManpowerController/clients/$1";
$route['delclient/(:num)'] = "ManpowerController/delClient/$1";

/** route for location.... * */
$route['location'] = "user/location";
$route['dellocation/(:num)'] = "user/delLocation/$1";
$route['location/(:num)'] = "user/location/$1";
$route['update-location'] = "user/updateLocationhw";
$route['dellocation/(:num)'] = "user/delLocation/$1";
$route['getlocationajax'] = "user/getlocationajax";
$route['get-client-ajax'] = "user/getClientByOrgAjax";
$route['getLocationByClient'] = "user/getLocationByClient";

/* * *Route for Warehouse Admin* */
$route['getWarehouseByLocation'] = "user/getWarehouseByLocation";
//$route['warehouseadmin'] = "user/warehouseAdmin";
//$route['addwarehouseadmin'] = "user/addNewAdmin";
//$route['warehouseadminlisting/(:num)'] = "user/warehouseAdminListing/$1";



$route['getshiftlistajax'] = "user/getshiftlistajax";
$route['user'] = "user/user";
$route['add-user-staff'] = "user/addUserStaff";
$route['add-user-staff/(:any)'] = "user/addUserStaff/$1";
$route['users/(:any)'] = "user/users/$1";
$route['users-all/(:any)'] = "user/usersAll/$1";

$route['users'] = "user/users";

$route['addNewUser'] = "user/addNewUser";
$route['edit-user-staff'] = "user/editUserStaff";
$route['edit-user-staff/(:num)'] = "user/editUserStaff/$1";
$route['update-user-staff'] = "user/updateUserStaff";
$route['deleteUser'] = "user/deleteUser";

// ftu
$route['getAddedEmployeesTableMarkup'] = 'ManpowerController/getAddedEmployeesTableMarkup';
$route['getEmployeesToBeAddedTableMarkup'] = 'ManpowerController/getEmployeesToBeAddedTableMarkup';
$route['addEmployeeToTeam'] = 'ManpowerController/addEmployeeToTeam';
$route['addEmployeeToTeamm'] = 'ManpowerController/addEmployeeToTeamm';
$route['removeEmployeeFromTeam'] = 'ManpowerController/removeEmployeeFromTeam';
$route['leaveEmployeeFromTeam'] = 'ManpowerController/leaveEmployeeFromTeam';

$route['shift-start'] = 'CronJobs/shiftStart';
$route['shift-finish'] = 'CronJobs/shiftFinish';
$route['not-using-wh-report'] = 'CronJobs/notUsingWhReport';

$route['import-employee'] = 'ExcelController/import';
$route['import-performance'] = 'ExcelController/importPerformance';
$route['import-performance-co'] = 'ExcelController/importPerformanceCO';
$route['delete-all-user-list'] = 'ExcelController/deleteAllUserList';
$route['delete-all-user'] = "ExcelController/deleteAllUser";
$route['getdeleteuserajaxlisting'] = 'ExcelController/getdeleteuserajaxlisting';

$route['delete-all-productivity-list'] = 'ExcelController/deleteAllProductivityList';
$route['delete-all-pro'] = "ExcelController/deleteAllPro";
$route['getdeleteproajaxlisting'] = 'ExcelController/getdeleteproajaxlisting';

//Shift Managment
$route['shift'] = "ShiftController/shift";
$route['shift/(:num)'] = "ShiftController/shift/$1";
$route['delshift/(:num)'] = "ShiftController/delshift/$1";
$route['updateshift'] = "ShiftController/updateshift";
$route['get-supervisorlist-by-sub-dept'] = "User/getSupervisorListBySubDept";
$route['getshiftlist'] = "User/getshiftlist";

$route['getshiftlistreportajax'] = "user/getshiftlistreportajax";

//Sub Deptartment Managment
$route['sub-dept-mngt'] = "SubDeptMngtController/subDeptMngt";
$route['sub-dept-mngt/(:num)'] = "SubDeptMngtController/subDeptMngt/$1";
$route['delshiftmngt/(:num)'] = "SubDeptMngtController/delSubDeptMngt/$1";
$route['update-sub-dept-mngt'] = "SubDeptMngtController/updateSubDeptMngt";
$route['shiftmngtajax'] = "SubDeptMngtController/shiftMngtAjax";
$route['get-sub-dept-mngt-list'] = "SubDeptMngtController/getSubDeptMngtlist";

//Supervisor Managment
$route['super-mngt'] = "SupervisorMngtController/superMngt";
$route['get-supervisor-mngt-list'] = "SupervisorMngtController/getSupervisorMngtlist";
$route['get-productivity-uploading-format'] = "SupervisorMngtController/getProductivityUploadingFormat";
$route['get-productivity-uploading-format-co'] = "SupervisorMngtController/getProductivityUploadingFormatCO";
$route['get-file-name'] = "SupervisorMngtController/getFileName";

//report preview..
$route['getdetailspreview'] = 'ReportController/getdetailsPreview';

/* End of file routes.php */
/* Location: ./application/config/routes.php */
