<?php
require_once '../init.php';
header('Content-Type: application/json');

$response = ['success' => false, 'message' => '', 'data' => []];

// Read input (JSON or POST form-data)
$data = json_decode(file_get_contents('php://input'), true);

$order_id = isset($data['order_id']) ? trim($data['order_id']) : (isset($_POST['order_id']) ? trim($_POST['order_id']) : '');

// Validate crate_id
if ($order_id === '') {
    $response['message'] = 'Order ID is Required';
    echo json_encode($response);
    exit;
}

// Escape crate_id
$crate_id = mysqli_real_escape_string($mycon, $crate_id);

// Fetch crate-wise data
$sql = "SELECT order_id, sales_delivery_no, challan_no,order_location, part_no, part_desc, batch_code, crate_weight, sticker_print_count, created_at FROM dispatch_crate_mapping_tbl WHERE order_id = '$order_id' ORDER BY created_at DESC";

$result = mysqli_query($mycon, $sql);

if ($result && mysqli_num_rows($result) > 0) {
    $table_data = [];
    while ($row = mysqli_fetch_assoc($result)) {
        $table_data[] = [
           
            'OrderId'          => $row['order_id'],
            'ChallanNo'        => $row['challan_no'],
            'SalesDeliveryNo'  => $row['sales_delivery_no'],
            'Location'         => $row['order_location'],
            'PartNo'           => $row['part_no'],
            'PartDesc'         => $row['part_desc'],
            'BatchCode'        => $row['batch_code'],
            'CrateWeight'      => $row['crate_weight'],
            'StickerPrintCount'=> $row['sticker_print_count'],
        ];
    }

    $response['success'] = true;
    $response['message'] = 'Crate Wise Data Fetched Successfully';
    $response['data'] = $table_data;
} else {
    $response['message'] = 'No data found for this crate';
}

echo json_encode($response);
