<?php
require_once '../init.php';
header('Content-Type: application/json');

$data = json_decode(file_get_contents('php://input'), true);

$response = ['success' => false, 'message' => '', 'data' => []];

// -------------------------------
// INPUT VALIDATION
// -------------------------------
$warehouse_id = '';
$search = '';

if (isset($data['warehouse_id'])) {
    $warehouse_id = trim($data['warehouse_id']);
} elseif (isset($_POST['warehouse_id'])) {
    $warehouse_id = trim($_POST['warehouse_id']);
}

if (isset($data['search'])) {
    $search = trim($data['search']);
} elseif (isset($_POST['search'])) {
    $search = trim($_POST['search']);
}

if ($warehouse_id === '') {
    $response['message'] = 'Warehouse ID is required';
    echo json_encode($response);
    exit;
}

// -------------------------------
// PAGINATION
// -------------------------------
$page  = isset($data['page']) ? (int)$data['page'] : (isset($_POST['page']) ? (int)$_POST['page'] : 1);
$limit = isset($data['limit']) ? (int)$data['limit'] : (isset($_POST['limit']) ? (int)$_POST['limit'] : 10);

$page  = max($page, 1);
$limit = max($limit, 1);
$offset = ($page - 1) * $limit;

// -------------------------------
// SANITIZE
// -------------------------------
$SearchData = mysqli_real_escape_string($mycon, $search);

// -------------------------------
// COUNT QUERY (for pagination)
// -------------------------------
$where = "";
if (!empty($SearchData)) {
    $where = "WHERE order_id LIKE '%$SearchData%' OR crate_id LIKE '%$SearchData%'";
}

$count_sql = "SELECT COUNT(id) AS total FROM dispatch_crate_mapping_tbl $where";
$count_result = mysqli_query($mycon, $count_sql);
$count_row = mysqli_fetch_assoc($count_result);
$total_records = isset($count_row['total']) ? (int)$count_row['total'] : 0;
$total_pages = ceil($total_records / $limit);

// -------------------------------
// MAIN QUERY
// -------------------------------
$sql = "SELECT crate_id, crate_weight, order_id FROM dispatch_crate_mapping_tbl $where ORDER BY id DESC LIMIT $limit OFFSET $offset";

$result = mysqli_query($mycon, $sql);

// -------------------------------
// RESPONSE BUILDING
// -------------------------------
if ($result && mysqli_num_rows($result) > 0) {
    $loading_data = [];
    while ($row = mysqli_fetch_assoc($result)) {
        $loading_data[] = [
            'Crate ID'     => $row['crate_id'],
            'Crate Weight' => $row['crate_weight'],
            'Order ID'     => $row['order_id']
        ];
    }

    $response['success'] = true;
    $response['message'] = 'Loading Data Fetched Successfully';
    $response['data'] = $loading_data;
    $response['total_pages'] = $total_pages;
    $response['total_records'] = $total_records;
} else {
    $response['message'] = 'No loading found for this data';
}

echo json_encode($response, JSON_PRETTY_PRINT);
?>
