<?php
require_once '../init.php';
header('Content-Type: application/json');

$response = ['success' => false, 'message' => '', 'data' => []];

$data = json_decode(file_get_contents('php://input'), true);

$warehouse_id = isset($data['warehouse_id']) ? trim($data['warehouse_id']) : (isset($_POST['warehouse_id']) ? trim($_POST['warehouse_id']) : '');

if ($warehouse_id === '') {
    $response['message'] = 'Warehouse ID is Required';
    echo json_encode($response);
    exit;
}
$sql = "SELECT id, vehicle_number FROM security_check_details WHERE is_loading_unloading = 0 AND cancelled_status !=2 ORDER BY vehicle_number ASC";
$result = mysqli_query($mycon, $sql);

if ($result && mysqli_num_rows($result) > 0) {
    $vehicles = [];
    while ($row = mysqli_fetch_assoc($result)) {
        $vehicles[] = [
            'id' => $row['id'],
            'vehicle_no' => $row['vehicle_number']
        ];
    }

    $response['success'] = true;
    $response['message'] = 'Vehicle Data Fetched Successfully';
    $response['data'] = $vehicles;
} else {
    $response['message'] = 'No active vehicles found';
}

echo json_encode($response);
