<?php
require_once '../init.php';

if (not_logged_in() === TRUE) {
    header('location: ../index.php');
}


// Search Data Show
function get_all_no_of_rows($mycon, $srcitem, $srcfrom, $role_item)
{
    $sql_query = "SELECT *, ud.number_of_lr, ud.number_of_box, tm.transporter_name as trnsp_nm, sc.relation_id as relation_id, sc.created_at as c_at FROM security_check_details sc join unloading_data ud on sc.gate_pass_number = ud.get_pass_number join transporter_master tm on tm.id = sc.transporter_name WHERE sc.cancelled_status !=2 AND ud.process_type = 1 " . $srcitem . " " . $srcfrom . " " . $role_item . " order by sc.created_at DESC";
    $result = mysqli_query($mycon, $sql_query);
    return mysqli_num_rows($result);
}

function get_total_no_of_rows($mycon, $srcitem, $srcfrom, $role_item)
{
    $sql_query = "SELECT *, ud.number_of_lr, ud.number_of_box, tm.transporter_name as trnsp_nm, sc.relation_id as relation_id, sc.created_at as c_at FROM security_check_details sc join unloading_data ud on sc.gate_pass_number = ud.get_pass_number join transporter_master tm on tm.id = sc.transporter_name WHERE sc.cancelled_status !=2 AND ud.process_type = 1 " . $srcitem . " " . $srcfrom . " " . $role_item . " order by sc.created_at DESC";
    $result = mysqli_query($mycon, $sql_query);
    return mysqli_num_rows($result);
}



$startHour = "00:00:00";
$endHour = "23:55:55";
if ($_POST['item'] == 'po_no') {
    $srcitem = " AND pd.po_no = '" . trim($_POST['colunmData']) . "'";
} else if ($_POST['item'] == 'po_title') {
    $srcitem = " AND pd.po_title LIKE '%" . trim($_POST['colunmData']) . "%'";
} else if ($_POST['item'] == 'sender_name') {
    $srcitem = " AND pd.sender_name = '" . trim($_POST['colunmData']) . "'";
} else if ($_POST['item'] == 'product_code') {
    $srcitem = " AND pm.product_code = '" . trim($_POST['colunmData']) . "'";
} else if ($_POST['item'] == 'all_data') {
    $srcitem = "";
}




if ($_POST['todt'] != '') {
    $srcfrom = "AND pd.created_at BETWEEN '" . $_POST['fromdt'] . " $startHour' AND '" . $_POST['todt'] . " $endHour'";
} else {
    $srcfrom = '';
}



if ($_POST['department'] == 'department') {
    //include('PHPExcel.php');
    require_once 'PHPExcel/Classes/PHPExcel.php';
    $objPHPExcel = new PHPExcel();

    $objPHPExcel->setActiveSheetIndex(0);

    $objPHPExcel->setActiveSheetIndex(0)->mergeCells('A1:I1');

    $objPHPExcel->getActiveSheet()->getCell('A1')->setValue("Report Vendor Po Material");

    $objPHPExcel->getActiveSheet()
        ->getStyle('A1')
        ->getAlignment()
        ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

    $objPHPExcel->getActiveSheet()
        ->getStyle('A1:I1')
        ->getFill()
        ->setFillType(PHPExcel_Style_Fill::FILL_SOLID)
        ->getStartColor()
        ->setARGB('F28A8C'); //FF3399 33F0FF F28A8C

    // Add function for color	  
    function cellColor($cells, $color)
    {
        global $objPHPExcel;

        $objPHPExcel->getActiveSheet()->getStyle($cells)->getFill()->applyFromArray(array(
            'type' => PHPExcel_Style_Fill::FILL_SOLID,
            'startcolor' => array(
                'rgb' => $color
            )
        ));
    }

    //cellColor('B5', 'F28A8C');
    //cellColor('G5', 'EFA26E');
    cellColor('A2:N2', 'D2C9C9');
    cellColor('A3:N3', 'D2C9C9');
    cellColor('A4:N4', 'D2C9C9');
    cellColor('A5:N5', 'D2C9C9');
    cellColor('A6:N6', 'D2C9C9');

    // End function for color	

    //$objPHPExcel->getActiveSheet()->getStyle('A1')->getFill()->getStartColor()->setRGB('FF0000');


    $objPHPExcel->getDefaultStyle()
        ->getBorders()
        ->getTop()
        ->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);
    $objPHPExcel->getDefaultStyle()
        ->getBorders()
        ->getBottom()
        ->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);
    $objPHPExcel->getDefaultStyle()
        ->getBorders()
        ->getLeft()
        ->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);
    $objPHPExcel->getDefaultStyle()
        ->getBorders()
        ->getRight()
        ->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);

    /** Borders for all data */
    /*  $objPHPExcel->getActiveSheet()->getStyle(
    'A7:' . 
    $objPHPExcel->getActiveSheet()->getHighestColumn() . 
    $objPHPExcel->getActiveSheet()->getHighestRow()
	)->getBorders()->getAllBorders()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN); */



    /** Borders for heading */
    /*  $objPHPExcel->getActiveSheet()->getStyle(
		'A1:I1'
	)->getBorders()->getAllBorders()->setBorderStyle(PHPExcel_Style_Border::BORDER_THICK); */


    $styleArray_header = array(
        'font' => array(
            'bold' => true,
            'color' => array('rgb' => '19194d'),
            'size' => 12,
            'name' => 'Verdana'
        ),
        'fill' => array(
            'type' => PHPExcel_Style_Fill::FILL_SOLID,
            'color' => array('rgb' => '9999ff')
        )
    );

    $objPHPExcel->getActiveSheet()->getStyle('A1:I1')->applyFromArray($styleArray_header);

    $objPHPExcel->getActiveSheet()->setCellValue('A2', 'WH Code:');
    $objPHPExcel->getActiveSheet()->setCellValue('B2', $wmsData['warehouse_code']);
    $objPHPExcel->getActiveSheet()->setCellValue('A3', 'Associate Name:');
    $objPHPExcel->getActiveSheet()->setCellValue('B3', $wmsData['company_name']);
    $objPHPExcel->getActiveSheet()->setCellValue('A4', 'Email:');
    $objPHPExcel->getActiveSheet()->setCellValue('B4', $wmsData['email']);
    $objPHPExcel->getActiveSheet()->setCellValue('A5', 'Country:');
    $objPHPExcel->getActiveSheet()->setCellValue('B5', $wmsData['country']);
    $objPHPExcel->getActiveSheet()->setCellValue('A6', 'City:');
    $objPHPExcel->getActiveSheet()->setCellValue('B6', $wmsData['city']);


    $objPHPExcel->setActiveSheetIndex(0)->mergeCells('B2:C2');
    $objPHPExcel->setActiveSheetIndex(0)->mergeCells('B3:C3');
    $objPHPExcel->setActiveSheetIndex(0)->mergeCells('B4:C4');
    $objPHPExcel->setActiveSheetIndex(0)->mergeCells('B5:C5');
    $objPHPExcel->setActiveSheetIndex(0)->mergeCells('B6:C6');

    $objPHPExcel->getActiveSheet()->setCellValue('D2', 'Warehouse Name:');
    $objPHPExcel->getActiveSheet()->setCellValue('E2', $wmsData['warehouse_name']);
    $objPHPExcel->getActiveSheet()->setCellValue('D3', 'Phone:');
    $objPHPExcel->getActiveSheet()->setCellValue('E3', $wmsData['phone_no']);
    $objPHPExcel->getActiveSheet()->setCellValue('D4', 'Address:');
    $objPHPExcel->getActiveSheet()->setCellValue('E4', $wmsData['address']);
    $objPHPExcel->getActiveSheet()->setCellValue('D5', 'State:');
    $objPHPExcel->getActiveSheet()->setCellValue('E5', $wmsData['state']);
    $objPHPExcel->getActiveSheet()->setCellValue('D6', 'Pincode:');
    $objPHPExcel->getActiveSheet()->setCellValue('E6', $wmsData['pincode']);

    $objPHPExcel->setActiveSheetIndex(0)->mergeCells('E2:G2');
    $objPHPExcel->setActiveSheetIndex(0)->mergeCells('E3:H3');
    $objPHPExcel->setActiveSheetIndex(0)->mergeCells('E4:H4');
    $objPHPExcel->setActiveSheetIndex(0)->mergeCells('E5:G5');
    $objPHPExcel->setActiveSheetIndex(0)->mergeCells('E6:G6');

    $objPHPExcel->getActiveSheet()->setCellValue('A7', 'PO NO');
    $objPHPExcel->getActiveSheet()->setCellValue('B7', 'PO Title');
    $objPHPExcel->getActiveSheet()->setCellValue('C7', 'PO Date ');
    $objPHPExcel->getActiveSheet()->setCellValue('D7', 'Vendor Name');
    $objPHPExcel->getActiveSheet()->setCellValue('E7', 'Product Code');
    $objPHPExcel->getActiveSheet()->setCellValue('F7', 'Product Description');
    $objPHPExcel->getActiveSheet()->setCellValue('G7', 'UOM');
    $objPHPExcel->getActiveSheet()->setCellValue('H7', 'PO Quantity');
    $objPHPExcel->getActiveSheet()->setCellValue('I7', 'Grn Qty');
    $objPHPExcel->getActiveSheet()->setCellValue('J7', 'Discrepancy Qty');
    $objPHPExcel->getActiveSheet()->setCellValue('K7', 'Discrepancy Remark');
    $objPHPExcel->getActiveSheet()->setCellValue('L7', 'Sales Return Qty');
    $objPHPExcel->getActiveSheet()->setCellValue('M7', 'Received Short Qty');
    $objPHPExcel->getActiveSheet()->setCellValue('N7', 'Balance PO Qty');



    $rowCnt = 7;

    $style_cell12 = array(
        'alignment' => array(
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_LEFT,
            'vertical' => PHPExcel_Style_Alignment::VERTICAL_TOP,
        )
    );


    $objPHPExcel->getActiveSheet()->getStyle('A2:N2')->applyFromArray($style_cell12);
    $objPHPExcel->getActiveSheet()->getStyle('A3:N3')->applyFromArray($style_cell12);
    $objPHPExcel->getActiveSheet()->getStyle('A4:N4')->applyFromArray($style_cell12);
    $objPHPExcel->getActiveSheet()->getStyle('A5:N5')->applyFromArray($style_cell12);
    $objPHPExcel->getActiveSheet()->getStyle('A6:N6')->applyFromArray($style_cell12);

    $style_cell = array(
        'alignment' => array(
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER,
        )
    );

    $styleArray = array(
        'font' => array(
            'bold' => true,
            'color' => array('rgb' => '19194d'),
            'size' => 10,
            'name' => 'Verdana'
        ),
        'fill' => array(
            'type' => PHPExcel_Style_Fill::FILL_SOLID,
            'color' => array('rgb' => 'ccccff')
        )
    );

    $styleArray1 = array(
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN
            )
        )
    );

    //$objPHPExcel->getDefaultStyle()->applyFromArray($styleArray);
    $objPHPExcel->getActiveSheet()->getStyle('A1:N1')->applyFromArray($styleArray1);
    $objPHPExcel->getActiveSheet()->getStyle('A7:N7')->applyFromArray($styleArray1);
    $objPHPExcel->getActiveSheet()->getStyle('A7:N7')->applyFromArray($styleArray);
    $objPHPExcel->getActiveSheet()->getStyle('A7:N7')->applyFromArray($style_cell);
    $objPHPExcel->getActiveSheet()->getStyle('A7:N7')->getAlignment()->setWrapText(true);
    $objPHPExcel->getActiveSheet()->getRowDimension(11)->setRowHeight(-1);

    //$objPHPExcel->getActiveSheet()->getColumnDimension('A7:I7')->setAutoSize(true);

    $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(30);
    $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
    $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(20);
    $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(35);
    $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(20);
    $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(40);
    $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(15);
    $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(15);
    $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(20);
    $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(20);
    $objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(20);
    $objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(20);
    $objPHPExcel->getActiveSheet()->getColumnDimension('M')->setWidth(20);
    $objPHPExcel->getActiveSheet()->getColumnDimension('N')->setWidth(20);

    $rowCount = 8;


    $sql2 = "SELECT pd.po_status,pd.po_no,pd.po_title,pd.po_date,pd.sender_name,pm.product_code,pm.uom,pm.qty FROM `po_details` as pd, po_material as pm WHERE pd.po_status= 10 " . $srcitem . " " . $srcfrom . " " . $role_item . " ORDER BY pm.id DESC";


    // echo $sql2; die();
    $result2 = mysqli_query($mycon, $sql2);
    if (mysqli_num_rows($result2) > 0) {
        while ($row = mysqli_fetch_array($result2)) {

            $po_no = $row['po_no'];
            $po_tittle = $row['po_title'];
            $po_date = $row['po_date'];
            $vendor_name = $row['sender_name'];
            $product_code = $row['product_code'];
            $pro_desc = get_product_name($mycon, $row['product_code']);
            $uom = $row['uom'];
            $qty = $row['qty'];
            $recieved_qty = get_recieved_qty($mycon, $row['product_code'], $row['po_no']);
            $ShortQty = $row['qty'] - $recieved_qty['invoice_qty'];
            $SalesReturnQty = GetSalesReturnQty($row['po_no'], $row['product_code'], $mycon);
            $DiscrepancyQty = $recieved_qty['DiscrepancyQty'];



            //   $objPHPExcel->getActiveSheet()->setCellValue('A' . $rowCount, $process_type);
            $objPHPExcel->getActiveSheet()->setCellValue('A' . $rowCount, $row['po_no']);
            $objPHPExcel->getActiveSheet()->setCellValue('B' . $rowCount, $row['po_title']);
            $objPHPExcel->getActiveSheet()->setCellValue('C' . $rowCount, $row['po_date']);
            $objPHPExcel->getActiveSheet()->setCellValue('D' . $rowCount, $row['sender_name']);
            $objPHPExcel->getActiveSheet()->setCellValue('E' . $rowCount, $row['product_code']);
            $objPHPExcel->getActiveSheet()->setCellValue('F' . $rowCount,  $pro_desc);
            $objPHPExcel->getActiveSheet()->setCellValue('G' . $rowCount, $row['uom']);
            $objPHPExcel->getActiveSheet()->setCellValue('H' . $rowCount, $row['qty']);
            $objPHPExcel->getActiveSheet()->setCellValue('I' . $rowCount, $recieved_qty['tqty']);
            $objPHPExcel->getActiveSheet()->setCellValue('J' . $rowCount, $recieved_qty['DiscrepancyQty']);
            $objPHPExcel->getActiveSheet()->setCellValue('K' . $rowCount, $recieved_qty['qty_issue_remark']);
            $objPHPExcel->getActiveSheet()->setCellValue('L' . $rowCount, $SalesReturnQty);
            $objPHPExcel->getActiveSheet()->setCellValue('M' . $rowCount,   $ShortQty);
            $objPHPExcel->getActiveSheet()->setCellValue('N' . $rowCount, $DiscrepancyQty + $SalesReturnQty + $ShortQty);



            $styleArrayrows1 = array(
                'borders' => array(
                    'allborders' => array(
                        'style' => PHPExcel_Style_Border::BORDER_THIN
                    )
                )
            );
            $styleArrayrows2 = array(
                'fill' => array(
                    'type' => PHPExcel_Style_Fill::FILL_SOLID
                )
            );

            $objPHPExcel->getActiveSheet()->getStyle('A' . $rowCount . ':N' . $rowCount . '')->applyFromArray($styleArrayrows1);
            $objPHPExcel->getActiveSheet()->getStyle('A' . $rowCount . ':N' . $rowCount . '')->applyFromArray($styleArrayrows2);

            $rowCount++;
        }
    } else {

        $objPHPExcel->getActiveSheet()->setCellValue('A' . $rowCount, 'Not Found Data');

        $objPHPExcel->setActiveSheetIndex(0)->mergeCells('A3:N3');

        $objPHPExcel->getActiveSheet()->getStyle('A1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
    }

    $objPHPExcel->getDefaultStyle()->applyFromArray(array(
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('rgb' => PHPExcel_Style_Color::COLOR_WHITE)
            )
        )
    ));


    $dated = date("Y-m-d h-i-s");
    $file = "Report Vendor Po Material-" . $dated . ".xlsx";

    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header('Content-Disposition: attachment;filename="' . $file . '"');
    header('Cache-Control: max-age=0');
    $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
    ob_end_clean();
    $objWriter->save('php://output');
    exit;
}
