<?php
require_once '../init.php';

$id = $_GET['id'];

// Fetch crate_id
$sql = "SELECT * FROM crate_tracking WHERE id = '$id'";
$result = $mycon->query($sql);

if ($result->num_rows > 0) {
    $row = $result->fetch_assoc();
    $crate_id = $row['crate_id'];
} else {
    $crate_id = "Unknown";
}

// QR text (sirf crate_id)
$qr_text = $crate_id;
$qr_encoded = urlencode($qr_text);
$qr_url = "https://api.qrserver.com/v1/create-qr-code/?data=$qr_encoded&size=400x400"; // High quality
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>QR Label</title>
  <style>
    body {
      display: flex;
      justify-content: center;
      align-items: center;
      height: 100vh;
      margin: 0;
      background: #fff;
    }

    .label-wrapper {
      display: flex;
      flex-direction: column;
      align-items: center;
      border: 1px solid #000;
      border-radius: 6px;
      padding: 20px;
      background: #fff;
      width: fit-content;
      box-shadow: 0 2px 6px rgba(0,0,0,0.1);
    }

    .label-wrapper img {
      width: 60mm;   /* Large print size */
      height: 60mm;
    }

    .crate-id {
      margin-top: 12px;
      font-size: 18px;
      font-family: Arial, sans-serif;
      font-weight: bold;
      text-align: center;
      max-width: 65mm;
      word-wrap: break-word;
      letter-spacing: 1px;
    }

    @media print {
      body {
        background: none;
      }
      .label-wrapper {
        border: none;
        box-shadow: none;
        padding: 0;
      }
      .crate-id {
        font-size: 16px;
      }
    }
  </style>
</head>
<body>
  <div class="label-wrapper">
    <img src="<?= $qr_url ?>" alt="QR Code">
    <div class="crate-id"><?= htmlspecialchars($crate_id) ?></div>
  </div>

  <script>
    window.onload = function() {
      window.print();
    };
  </script>
</body>
</html>
