<?php
require_once '../../init.php';
require_once 'function.php';

if (not_logged_in() === TRUE) {
  header('location: ../index.php');
}

function get_available_qty($location, $mycon) {
  $tabledata = 0;
  $sql_query1 = "SELECT sum(quantity) AS available_qty FROM temp_split_quantity_putway WHERE location='" . $location . "' group by location";

  $result1 = mysqli_query($mycon, $sql_query1);
  $rows_total1 = mysqli_num_rows($result1);
  if (mysqli_num_rows($result1) > 0) {
	while ($row1 = mysqli_fetch_assoc($result1)) {
	  $tabledata = $row1['available_qty'];
	}
  }
  return $tabledata;
}

function get_lockedqty($location, $mycon) {
  $total = 0;
  $sql_query = "SELECT SUM(pick_qty) AS qty FROM `picklist_generation` WHERE is_split = 0 AND location='" . $location . "' group by location";
  $result = mysqli_query($mycon, $sql_query);
  if (mysqli_num_rows($result) > 0) {
	while ($row = mysqli_fetch_assoc($result)) {
	  $total = $row['qty'];
	}
  }

  return $total;
}

function get_dispatched_qt($location, $mycon) {
  $total = 0;
  $sql_query = "SELECT SUM(picked_qt) AS qty FROM `packed_quantity_data` WHERE qa_status = 1 AND dispatched_auto_id = 0 AND location='" . $location . "' group by location";
  $result = mysqli_query($mycon, $sql_query);
  if (mysqli_num_rows($result) > 0) {
	while ($row = mysqli_fetch_assoc($result)) {
	  $total = $row['qty'];
	}
  }

  return $total;
}

if ($_POST['item'] == 'location') {
  $srcitem = "AND location ='" . $_POST['colunmData'] . "'";
} else if ($_POST['item'] == 'all') {
  $srcitem = "";
}

function get_totalbatch($location, $mycon) {
  $total = 0;
  $sql_query2 = "SELECT * FROM temp_split_quantity_putway WHERE location='" . $location . "' group by relation_id";
  $result2 = mysqli_query($mycon, $sql_query2);
  $total2 = mysqli_num_rows($result2);

  $sql_query1 = "SELECT * FROM picklist_generation WHERE location='" . $location . "' group by batch_location";
  $result1 = mysqli_query($mycon, $sql_query1);
  $total1 = mysqli_num_rows($result1);
  $total = $total2 + $total1;

  return $total;
}

function get_totalpro($location, $mycon) {
  $total = 0;
  $sql_query2 = "SELECT * FROM temp_split_quantity_putway WHERE location='" . $location . "' group by product_code";
  $result2 = mysqli_query($mycon, $sql_query2);
  $total2 = mysqli_num_rows($result2);

  $sql_query1 = "SELECT * FROM picklist_generation WHERE location='" . $location . "' group by pro_code";
  $result1 = mysqli_query($mycon, $sql_query1);
  $total1 = mysqli_num_rows($result1);
  $total = $total2 + $total1;

  return $total;
}

// Search Data Show
function get_all_no_of_rows($mycon, $srcitem, $srcfrom, $role_item) {
  $sql_query = "SELECT `bnning_code` FROM `binning_master` WHERE `permissions_id` = 0 " . $srcitem . " " . $srcfrom . " " . $role_item . " group by bnning_code order by bnning_code";
  $result = mysqli_query($mycon, $sql_query);
  return mysqli_num_rows($result);
}

function get_total_no_of_rows($mycon, $srcitem, $srcfrom, $role_item) {
  $sql_query = "SELECT `bnning_code` FROM `binning_master` WHERE `permissions_id` = 0 group by bnning_code order by bnning_code";
  $result = mysqli_query($mycon, $sql_query);
  return mysqli_num_rows($result);
}

$item_per_page = 20;
//continue only if $_POST is set and it is a Ajax request
if (isset($_POST) && isset($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest') {

  if (isset($_POST["page"])) {
	$page_number = filter_var($_POST["page"], FILTER_SANITIZE_NUMBER_INT, FILTER_FLAG_STRIP_HIGH); //filter number
	if (!is_numeric($page_number)) {
	  die('Invalid page number!');
	} //incase of invalid page number
  } else {
	$page_number = 1; //if there's no page number, set it to 1
  }

//Advance Search
  $startHour = "00:00:00";
  $endHour = "23:55:55";

  if ($_POST['item'] == 'location') {
	$srcitem = "AND bnning_code = '" . trim($_POST['colunmData']) . "'";
  } else if ($_POST['item'] == 'all') {
	$srcitem = "";
  }

  if ($_POST['todt'] != '') {
	$srcfrom = "AND created_on BETWEEN '" . $_POST['fromdt'] . " $startHour' AND '" . $_POST['todt'] . " $endHour'";
  } else {
	$srcfrom = '';
  }

//echo "colunmData--" . $_POST['colunmData'] . "<br/>fromdt--" . $_POST['fromdt'] . "<br/>todt--" . $_POST['todt'] . "<br/>item--" . $_POST['item'];
  ?>
  <p class="details_table">
	  <?php
	  if ($_POST['item'] == '') {
		$is_defaultshowEntries = get_total_no_of_rows($mycon, $srcitem, $srcfrom, $role_item);
		if ($is_defaultshowEntries > 20) {
		  $defaultshowEntries = 20;
		} else {
		  $defaultshowEntries = $is_defaultshowEntries;
		}
		?>
		<span><b>Searched values : </b> Default Search</span> | <span>Showing <?php echo $defaultshowEntries; ?> by default of </span><span> <?php echo $is_defaultshowEntries; ?></span> <b> entries</b>
	  <?php } else { ?>
		<span><b>Searched values : </b> <?php echo $_POST['item'] . " - " . $_POST['colunmData']; ?></span> | <strong>Total Search Data: </strong> <span><?php echo get_all_no_of_rows($mycon, $srcitem, $srcfrom, $role_item); ?></span>| <span><b>Total No. of data :</b> <?php echo get_total_no_of_rows($mycon, $srcitem, $srcfrom, $role_item); ?></span>
	  <?php } ?>
  </p>
  <table class="table table-striped table-bordered table-hover" id="sample_3">
  	<thead>
  		<tr class="poke">
  			<th>Binning Location</th>
  			<!--<th>Total Batch</th>
  			<th>Total Product</th>-->
  			<th>Available Quantity</th>
  			<th>Locked Quantity</th>
  			<th>Ready For Dispatch </th>
  			<th>Total Summary</th>
  		</tr>
  	</thead>
  	<tbody>

		  <?php
		  //get total number of records from database for pagination
		  $i = 1;
		  $sql_query = "SELECT `bnning_code` FROM `binning_master` WHERE `bnning_code` != '' " . $srcitem . " " . $srcfrom . " " . $role_item . " group by bnning_code order by bnning_code";

		  $result123 = mysqli_query($mycon, $sql_query);
		  $get_total_rows = mysqli_num_rows($result123);
		  $total_pages = ceil($get_total_rows / $item_per_page);


          //get starting position to fetch the records
		  $page_position = (($page_number - 1) * $item_per_page);

		  $sql_query_fetch = "SELECT `bnning_code` FROM `binning_master` WHERE `bnning_code` != '' " . $srcitem . " " . $srcfrom . " " . $role_item . " group by bnning_code order by bnning_code LIMIT $page_position, $item_per_page";

		  $result_fetch = mysqli_query($mycon, $sql_query_fetch);
		  //echo '<br/>' . $sql_query_fetch;
		  //echo '<br/>' . $sql_query;
		  if (mysqli_num_rows($result_fetch) > 0) {
			while ($row = mysqli_fetch_assoc($result_fetch)) {
			  $available = get_available_qty($row['bnning_code'], $mycon);
			  $picklist_qty = get_lockedqty($row['bnning_code'], $mycon);
			  $dispatched_qty = get_dispatched_qt($row['bnning_code'], $mycon);
			  $total_summary = $available + $picklist_qty + $dispatched_qty;
              //if ($total_summary != '' || $total_summary != 0) { ?>
				<tr>
					<td> <?php echo $row['bnning_code']; ?> </td>
					<td> <?php echo $available; ?> </td>
					<td> <?php echo $picklist_qty; ?> </td>
					<td> <?php echo $dispatched_qty; ?> </td>
					<td> <?php echo $total_summary; ?> </td>
				</tr>
              <?php
			 // }
			}
		  } else {
			?>
			<tr>
				<td><?php echo 'No Record Found'; ?></td>
			</tr>
		  <?php } ?>
  	</tbody>
  </table>
  <div align="center">
	  <?php
	  /* We call the pagination function here to generate Pagination link for us.
	    As you can see I have passed several parameters to the function. */
	  echo paginate_function($item_per_page, $page_number, $get_total_rows, $total_pages);
	  ?>
  </div>
  <?php
}
?>
</div>

