<?php
require_once '../../init.php';
require_once 'function.php';

if (not_logged_in() === TRUE) {
	header('location: ../index.php');
}

// Search Data Show
function get_all_no_of_rows($mycon, $srcitem, $srcfrom, $role_item)
{
	$sql_query = "SELECT file_ref_num, order_generated_on, is_generate_order, customer_code, location, COUNT(DISTINCT code) AS TotalProduct, COUNT(DISTINCT location) AS TotalLocation, crate_order_date FROM bulk_order_data_tbl WHERE customer_code != ''" . $srcitem . " " . $srcfrom . " " . $role_item . " AND uploaded_confirmed= '0' GROUP BY customer_code ORDER BY id DESC";
	$result = mysqli_query($mycon, $sql_query);
	return mysqli_num_rows($result);
}

function get_total_no_of_rows($mycon, $srcitem, $srcfrom, $role_item)
{
	$sql_query = "SELECT file_ref_num, order_generated_on, is_generate_order, customer_code, location, COUNT(DISTINCT code) AS TotalProduct, COUNT(DISTINCT location) AS TotalLocation, crate_order_date FROM bulk_order_data_tbl WHERE customer_code != ''" . $srcitem . " " . $srcfrom . " " . $role_item . " AND uploaded_confirmed= '0' GROUP BY customer_code ORDER BY id DESC";
	$result = mysqli_query($mycon, $sql_query);
	return mysqli_num_rows($result);
}


function GetCustomerName($CustomerCode, $mycon)
{
	$CustomerCode = mysqli_real_escape_string($mycon, $CustomerCode);
	$CustomerQ = "SELECT customer_name  FROM customer_details WHERE customer_code = '$CustomerCode'";
	$ResultCust = mysqli_query($mycon, $CustomerQ);
	$row = ($ResultCust && mysqli_num_rows($ResultCust) > 0) ? mysqli_fetch_assoc($ResultCust) : ['customer_name' => ''];

	return $row['customer_name'] ?? '';
}

$item_per_page = 20;
//continue only if $_POST is set and it is a Ajax request
if (isset($_POST) && isset($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest') {

	if (isset($_POST["page"])) {
		$page_number = filter_var($_POST["page"], FILTER_SANITIZE_NUMBER_INT, FILTER_FLAG_STRIP_HIGH); //filter number
		if (!is_numeric($page_number)) {
			die('Invalid page number!');
		} //incase of invalid page number
	} else {
		$page_number = 1; //if there's no page number, set it to 1
	}

	//Advance Search
	$startHour = "00:00:00";
	$endHour = "23:55:55";
	$srcitem = "";
	if ($_POST['item'] == 'model_name') {
		$srcitem = " AND model = '" . trim($_POST['colunmData']) . "'";
	} else if ($_POST['item'] == 'model_description') {
		$srcitem = " AND model_desc = '" . trim($_POST['colunmData']) . "'";
	} else if ($_POST['item'] == 'all') {
		$srcitem = "";
	}

	if ($_POST['todt'] != '' && $_POST['fromdt'] != '') {
		$srcfrom = "AND created_on BETWEEN '" . $_POST['fromdt'] . " $startHour' AND '" . $_POST['todt'] . " $endHour'";
	} else {
		$srcfrom = '';
	}

	//echo "colunmData--" . $_POST['colunmData'] . "<br/>fromdt--" . $_POST['fromdt'] . "<br/>todt--" . $_POST['todt'] . "<br/>item--" . $_POST['item'];
?>
	<p class="details_table">
		<?php
		if ($_POST['item'] == '') {
			$is_defaultshowEntries = get_total_no_of_rows($mycon, $srcitem, $srcfrom, $role_item);
			if ($is_defaultshowEntries > 20) {
				$defaultshowEntries = 20;
			} else {
				$defaultshowEntries = $is_defaultshowEntries;
			}
		?>
			<span><b>Searched values : </b> Default Search</span> | <span>Showing <?php echo $defaultshowEntries; ?> by default of </span><span> <?php echo $is_defaultshowEntries; ?></span> <b> entries</b>
		<?php } else { ?>
			<span><b>Searched values : </b> <?php echo $_POST['item'] . " - " . $_POST['colunmData']; ?></span> | <strong>Total Search Data: </strong> <span><?php echo get_all_no_of_rows($mycon, $srcitem, $srcfrom, $role_item); ?></span>| <span><b>Total No. of data :</b> <?php echo get_total_no_of_rows($mycon, $srcitem, $srcfrom, $role_item); ?></span>
		<?php } ?>
	</p>
	<table class="table table-striped table-bordered table-hover" id="sample_3" style="width: 100%;">
		<thead>
			<tr>

				<th>Customer Code / Name</th>
				<th>Location</th>
				<th>NO of Product</th>
				<th>Order Dates</th>
				<th>No of Error</th>
				<th>Create Order Date</th>
				<th>Action</th>

			</tr>
		</thead>
		<tbody>

			<?php
			//get total number of records from database for pagination
			$i = 1;
			$sql_query = "SELECT file_ref_num, order_generated_on, is_generate_order, customer_code,location, COUNT(DISTINCT code) AS TotalProduct, COUNT(DISTINCT location) AS TotalLocation, crate_order_date, SUM(CASE WHEN uom != actual_uom THEN 1 ELSE 0 END) AS UOMMismatchCount FROM bulk_order_data_tbl WHERE customer_code != ''" . $srcitem . " " . $srcfrom . " " . $role_item . " AND uploaded_confirmed= '0' GROUP BY customer_code  ORDER BY id DESC";

			$result123 = mysqli_query($mycon, $sql_query);
			$get_total_rows = mysqli_num_rows($result123);
			$total_pages = ceil($get_total_rows / $item_per_page);


			//get starting position to fetch the records
			$page_position = (($page_number - 1) * $item_per_page);



			$sql_query_fetch = "SELECT file_ref_num, order_generated_on, is_generate_order, customer_code, location, COUNT(DISTINCT code) AS TotalProduct, COUNT(DISTINCT location) AS TotalLocation, crate_order_date, SUM(CASE WHEN uom != actual_uom THEN 1 ELSE 0 END) AS UOMMismatchCount FROM bulk_order_data_tbl WHERE customer_code != ''" . $srcitem . " " . $srcfrom . " " . $role_item . " AND uploaded_confirmed= '0' GROUP BY customer_code ORDER BY id DESC LIMIT $page_position, $item_per_page";
			// echo $sql_query_fetch; die;
			$result_fetch = mysqli_query($mycon, $sql_query_fetch);
			if (mysqli_num_rows($result_fetch) > 0) {
				while ($row = mysqli_fetch_assoc($result_fetch)) {
					$CustomerName = GetCustomerName($row['customer_code'], $mycon);

			?>
					<tr>


						<td><a href="get_wrong_uploaded_order_data.php?CustomerCode=<?php echo $row['customer_code']; ?>&OrderCreatedate=<?php echo $row['crate_order_date']; ?>"><?php echo $row['customer_code'] . '/' . $CustomerName; ?></a></td>
						<td><?php echo $row['location']; ?></td>
						<td><?php echo $row['TotalProduct']; ?></td>
						<td><?php echo '7'; ?></td>
						<td><?php echo $row['UOMMismatchCount']; ?></td>
						<td><?php echo $row['crate_order_date']; ?></td>
						<td>
							<?php if ($row['is_generate_order'] == '0' && $row['UOMMismatchCount'] == '0') { ?>
								<div style="display:flex; align-items:center; justify-content:center; gap:10px;">
									<button class="btn btn-outline-dark btn-sm" title="Generate Order" onclick="ConfirmOrderUploadedData('<?php echo $row['customer_code']; ?>', '<?php echo $row['file_ref_num']; ?>', this)" style="display:flex; align-items:center; justify-content:center;">Generate Order </button>
								</div>
							<?php } else if ($row['is_generate_order'] == '0' && $row['UOMMismatchCount'] > '0') {
								echo 'First Clear The Wrong Data.Then Generate the Order.';
							} else {
								echo 'Order Already Generated';
							} ?>
						</td>

					</tr>
				<?php
					$cnt++;
				}
			} else {
				?>
				<tr>
					<td><?php echo 'No Record Found'; ?></td>
				</tr>
			<?php } ?>
		</tbody>
	</table>
	<div id="statusText" style="margin-top:15px; text-align:center;"></div>

	<script>
		function ConfirmOrderUploadedData(CustomerCode, fileRefNo, button) {
			if (!confirm("Are you sure you want to confirm this order?")) return;

			// Disable button and show loader
			button.disabled = true;
			const originalHTML = button.innerHTML;
			button.innerHTML = `
            <div style="display:flex; align-items:center; gap:6px;">
              <div class="spinner-border spinner-border-sm text-primary" role="status"></div>
              <span>Processing...</span>
            </div>
          `;

			// Prepare form data
			const bodyData = "CustomerCode=" + encodeURIComponent(CustomerCode) +
				"&fileRefNo=" + encodeURIComponent(fileRefNo);

			// Send both CustomerCode and fileRefNo
			fetch("bulk_order_confirm_customer_wise_data.php", {
					method: "POST",
					headers: {
						"Content-Type": "application/x-www-form-urlencoded"
					},
					body: bodyData
				})
				.then(response => response.text())
				.then(data => {
					alert(data.trim());
					setTimeout(() => {
						window.location = "bulk_order_master_data.php";
					}, 800);
				})
				.catch(error => {
					console.error(error);
					alert("❌ Error confirming order. Please try again.");

					// Restore button on error
					button.disabled = false;
					button.innerHTML = originalHTML;
				});
		}
	</script>


	<div align="center">
		<?php
		/* We call the pagination function here to generate Pagination link for us.
    As you can see I have passed several parameters to the function. */
		echo paginate_function($item_per_page, $page_number, $get_total_rows, $total_pages);
		?>
	</div>
<?php
}
?>
</div>