<?php
  require_once '../init.php';


if (not_logged_in() === TRUE) {
  header('location: ../index.php');
}

function displayDates($date1, $date2, $format = 'Y-m-d' ) {
      $dates = array();
      $current = strtotime($date1);
      $date2 = strtotime($date2);
      $stepVal = '+1 day';
      while( $current <= $date2 ) {
         $dates[] = date($format, $current);
         $current = strtotime($stepVal, $current);
      }
      return $dates;
   }

function get_total_picklist_qty($mycon, $reportdate){
    $total = 0;
	$startHour = "00:00:00";
    $endHour = "23:55:55";
    $srcfrom = "om.created_on < '" . $reportdate . " $endHour'";
    $sql_query = "SELECT om.order_id, SUM(pqd.pick_qty) AS tqty FROM `order_management` om, `picklist_generation` pqd  WHERE " . $srcfrom . " AND om.is_generate_picklist = 1 AND pqd.order_id = om.order_id";
        
    $result = mysqli_query($mycon, $sql_query);
    if (mysqli_num_rows($result) > 0) {
        while ($row = mysqli_fetch_assoc($result)) {
            $total = $row['tqty'];
        }
    } else { $total = 0; }

    return $total;
}

function get_total_confirmed_picklist_qty($mycon, $reportdate){
    $total = 0;
	$startHour = "00:00:00";
    $endHour = "23:55:55";
	$srcfrom = "om.created_on < '" . $reportdate . " $endHour'";
    $sql_query = "SELECT om.order_id, SUM(pqd.picking_quantity) AS tqty FROM `order_management` om, `temp_split_quantity_picking` pqd  WHERE " . $srcfrom . " AND om.is_confirm = 1 AND pqd.order_id = om.order_id";
    $result = mysqli_query($mycon, $sql_query);
    if (mysqli_num_rows($result) > 0) {
        while ($row = mysqli_fetch_assoc($result)) {
            $total = $row['tqty'];
        }
    } else { $total = 0; }

    return $total;
}

function get_total_packing_qty($mycon, $reportdate){
    $total = 0;
	$startHour = "00:00:00";
    $endHour = "23:55:55";
	$srcfrom = "om.created_on < '" . $reportdate . " $endHour'";
    $sql_query = "SELECT om.order_id, SUM(pqd.picked_qt) AS tqty FROM `order_management` om, ` packed_quantity_data` pqd  WHERE " . $srcfrom . " AND om.packing_completed = 1 AND pqd.order_id = om.order_id";
    $result = mysqli_query($mycon, $sql_query);
    if (mysqli_num_rows($result) > 0) {
        while ($row = mysqli_fetch_assoc($result)) {
            $total = $row['tqty'];
        }
    } else { $total = 0; }

    return $total;
}
		
function get_total_picked_qt($mycon, $reportdate){
    $total = 0;
	$startHour = "00:00:00";
    $endHour = "23:55:55";
	$srcfrom = "om.created_on < '" . $reportdate . " $endHour'";
    $sql_query = "SELECT om.order_id, SUM(pqd.picked_qt) AS tqty FROM `order_management` om, ` packed_quantity_data` pqd  WHERE " . $srcfrom . " AND om.qa_completed = 1 AND pqd.order_id = om.order_id";
    $result = mysqli_query($mycon, $sql_query);
    if (mysqli_num_rows($result) > 0) {
        while ($row = mysqli_fetch_assoc($result)) {
            $total = $row['tqty'];
        }
    } else { $total = 0; }

    return $total;
}

function get_total_dispatched_qty($mycon, $reportdate){
    $total = 0;
	$startHour = "00:00:00";
    $endHour = "23:55:55";
	$srcfrom = "om.created_on < '" . $reportdate . " $endHour'";
    $sql_query = "SELECT om.order_id, SUM(pqd.picked_qt) AS tqty FROM `order_management` om, ` packed_quantity_data` pqd  WHERE " . $srcfrom . " AND om.is_dispatched = 1 AND pqd.order_id = om.order_id";
    $result = mysqli_query($mycon, $sql_query);
    if (mysqli_num_rows($result) > 0) {
        while ($row = mysqli_fetch_assoc($result)) {
            $total = $row['tqty'];
        }
    } else { $total = 0; }

    return $total;
}
		
function get_total_delivered_qty($mycon, $reportdate){
    $total = 0;
	$startHour = "00:00:00";
    $endHour = "23:55:55";
	$srcfrom = "om.created_on < '" . $reportdate . " $endHour'";
    $sql_query = "SELECT om.order_id, SUM(pqd.picked_qt) AS tqty FROM `order_management` om, ` packed_quantity_data` pqd  WHERE " . $srcfrom . " AND om.is_delivered = 1 AND pqd.order_id = om.order_id";
    $result = mysqli_query($mycon, $sql_query);
    if (mysqli_num_rows($result) > 0) {
        while ($row = mysqli_fetch_assoc($result)) {
            $total = $row['tqty'];
        }
    } else { $total = 0; }

    return $total;
}
		
function get_total_confirmed_order_qty($mycon, $reportdate){
    $total = 0;
	$startHour = "00:00:00";
    $endHour = "23:55:55";
	$srcfrom = "om.created_on < '" . $reportdate . " $endHour'";
    $sql_query = "SELECT om.order_id, SUM(omm.qty) AS tqty FROM `order_management` om, `order_material` omm WHERE " . $srcfrom . " AND om.order_status = 2 AND omm.order_id = om.order_id";
    $result = mysqli_query($mycon, $sql_query);
    if (mysqli_num_rows($result) > 0) {
        while ($row = mysqli_fetch_assoc($result)) {
            $total = $row['tqty'];
        }
    } else { $total = 0; }

    return $total;
}

function get_total_confirmed_order($mycon, $reportdate){
    $total = 0;
	$startHour = "00:00:00";
    $endHour = "23:55:55";
	$srcfrom = "created_on < '" . $reportdate . " $endHour'";
    $sql_query = "SELECT ref_number FROM `order_management` WHERE " . $srcfrom . " AND order_status = 2";
    $result = mysqli_query($mycon, $sql_query);
    if (mysqli_num_rows($result) > 0) {
        $total = mysqli_num_rows($result);
    } else { $total = 0; }

    return $total;
}
		
function get_total_cancel_order_qty($mycon, $reportdate){
    $total = 0;
	$startHour = "00:00:00";
    $endHour = "23:55:55";
	$srcfrom = "om.created_on < '" . $reportdate . " $endHour'";
    $sql_query = "SELECT om.order_id, SUM(omm.qty) AS tqty FROM `order_management` om, `order_material` omm WHERE " . $srcfrom . " AND om.order_status = 1 AND omm.order_id = om.order_id";
    $result = mysqli_query($mycon, $sql_query);
    if (mysqli_num_rows($result) > 0) {
        while ($row = mysqli_fetch_assoc($result)) {
            $total = $row['tqty'];
        }
    } else { $total = 0; }

    return $total;
}

function get_total_cancel_order($mycon, $reportdate){
    $total = 0;
	$startHour = "00:00:00";
    $endHour = "23:55:55";
	$srcfrom = "created_on < '" . $reportdate . " $endHour'";
    $sql_query = "SELECT ref_number FROM `order_management` WHERE " . $srcfrom . " AND order_status = 1";
    $result = mysqli_query($mycon, $sql_query);
    if (mysqli_num_rows($result) > 0) {
        $total = mysqli_num_rows($result);
    } else { $total = 0; }

    return $total;
}
		
function get_total_order_qty($mycon, $reportdate){
    $total = 0;
	$startHour = "00:00:00";
    $endHour = "23:55:55";
	$srcfrom = "om.created_on < '" . $reportdate . " $endHour'";
    $sql_query = "SELECT om.order_id, SUM(omm.qty) AS tqty FROM `order_management` om, `order_material` omm WHERE " . $srcfrom . " AND omm.order_id = om.order_id";
    $result = mysqli_query($mycon, $sql_query);
    if (mysqli_num_rows($result) > 0) {
        while ($row = mysqli_fetch_assoc($result)) {
            $total = $row['tqty'];
        }
    } else { $total = 0; }

    return $total;
}

function get_total_order($mycon, $reportdate){
    $total = 0;
	$startHour = "00:00:00";
    $endHour = "23:55:55";
	$srcfrom = "created_on < '" . $reportdate . " $endHour'";
    $sql_query = "SELECT ref_number FROM `order_management` WHERE " . $srcfrom . " Group By ref_number";
    $result = mysqli_query($mycon, $sql_query);
    if (mysqli_num_rows($result) > 0) {
        $total = mysqli_num_rows($result);
    } else { $total = 0; }

    return $total;
}
		
function get_not_reversal_discrepancy($mycon, $reportdate){
    $total = 0;
	$startHour = "00:00:00";
    $endHour = "23:55:55";
	$srcfrom = "created_on < '" . $reportdate . " $endHour'";
    $sql_query = "SELECT SUM(settlement_qty) AS tqty FROM `reversal_refunding_discrepancy_product` WHERE " . $srcfrom . " AND product_issue_status = 2";
    $result = mysqli_query($mycon, $sql_query);
    if (mysqli_num_rows($result) > 0) {
        while ($row = mysqli_fetch_assoc($result)) {
            $total = $row['tqty'];
        }
    } else { $total = 0; }

    return $total;
}

function get_reversal_discrepancy($mycon, $reportdate){
    $total = 0;
	$startHour = "00:00:00";
    $endHour = "23:55:55";
	$srcfrom = "created_on < '" . $reportdate . " $endHour'";
    $sql_query = "SELECT SUM(settlement_qty) AS tqty FROM `reversal_refunding_discrepancy_product` WHERE " . $srcfrom . " AND product_issue_status = 1";
    $result = mysqli_query($mycon, $sql_query);
    if (mysqli_num_rows($result) > 0) {
        while ($row = mysqli_fetch_assoc($result)) {
            $total = $row['tqty'];
        }
    } else { $total = 0; }

    return $total;
}

function get_discrepancy($mycon, $reportdate){
    $total = 0;
	$startHour = "00:00:00";
    $endHour = "23:55:55";
	$srcfrom = "created_on < '" . $reportdate . " $endHour'";
    $sql_query = "SELECT SUM(issue_qty) AS tqty FROM `quality_check` WHERE " . $srcfrom . " AND product_issue_status = 0";
    $result = mysqli_query($mycon, $sql_query);
    if (mysqli_num_rows($result) > 0) {
        while ($row = mysqli_fetch_assoc($result)) {
            $total = $row['tqty'];
        }
    } else { $total = 0; }

    return $total;
}

function get_confired_grn($mycon, $reportdate){
    $total = 0;
	$startHour = "00:00:00";
    $endHour = "23:55:55";
	$srcfrom = "created_on < '" . $reportdate . " $endHour'";
    $sql_query = "SELECT SUM(qty) AS tqty FROM `upload_excel` WHERE " . $srcfrom . " AND is_comPw = 0 AND is_confirm = 1";
    $result = mysqli_query($mycon, $sql_query);
    if (mysqli_num_rows($result) > 0) {
        while ($row = mysqli_fetch_assoc($result)) {
            $total = $row['tqty'];
        }
    } else { $total = 0; }

    return $total;
}

function get_pending_grn($mycon, $reportdate){
    $total = 0;
	$startHour = "00:00:00";
    $endHour = "23:55:55";
	$srcfrom = "created_on < '" . $reportdate . " $endHour'";
    $sql_query = "SELECT SUM(qty) AS tqty FROM `upload_excel` WHERE " . $srcfrom . " AND is_comPw = 0 AND is_confirm = 0";
    $result = mysqli_query($mycon, $sql_query);
    if (mysqli_num_rows($result) > 0) {
        while ($row = mysqli_fetch_assoc($result)) {
            $total = $row['tqty'];
        }
    } else { $total = 0; }

    return $total;
}

// function for get the pending picklist
function get_pending_putaway($mycon, $reportdate){
    $total = 0;
    $startHour = "00:00:00";
    $endHour = "23:55:55";
	$srcfrom = "created_on < '" . $reportdate . " $endHour'";
    $sql_query = "SELECT SUM(packing_quantity) AS tqty FROM `packing_data` WHERE " . $srcfrom . " AND putway_status = 0";
    $result = mysqli_query($mycon, $sql_query);
    if (mysqli_num_rows($result) > 0) {
        while ($row = mysqli_fetch_assoc($result)) {
            $total = $row['tqty'];
        }
    } else { $total = 0; }

    return $total;
}

function get_confired_putaway($mycon, $reportdate){
    $total = 0;
	$startHour = "00:00:00";
    $endHour = "23:55:55";	
	$srcfrom = "created_on < '" . $reportdate . " $endHour'";
    $sql_query = "SELECT SUM(quantity) AS qty FROM `temp_split_quantity_putway` WHERE " . $srcfrom . "";
    $result = mysqli_query($mycon, $sql_query);
    if (mysqli_num_rows($result) > 0) {
        while ($row = mysqli_fetch_assoc($result)) {
            $total = $row['qty'];
        }
    } else { $total = 0; }
         return $total;
  }
  
  $dated = date("Y-m-d h-i-s");
  $fromdt = $_GET['fromdt'];
  $todt = $_GET['todt'];
  //Advance Search
  $startHour = "00:00:00";
  $endHour = "23:55:55";
  
 //if ($fromdt != '' && $todt != '') {
  //include('PHPExcel.php');
  require_once 'PHPExcel/Classes/PHPExcel.php';
  $objPHPExcel = new PHPExcel();

  $objPHPExcel->setActiveSheetIndex(0);
  
  $objPHPExcel->setActiveSheetIndex(0)->mergeCells('A1:I1');
  
  $reportname = "Stock Closing Report | From-" .$fromdt. "-To-" .$todt. " | Report Generated Date&Time : " .$dated. "";

  $objPHPExcel->getActiveSheet()->getCell('A1')->setValue($reportname);

  $objPHPExcel->getActiveSheet()
		  ->getStyle('A1')
		  ->getAlignment()
		  ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

  $objPHPExcel->getActiveSheet()
		  ->getStyle('A1:Z1')
		  ->getFill()
		  ->setFillType(PHPExcel_Style_Fill::FILL_SOLID)
		  ->getStartColor()
		  ->setARGB('F28A8C'); //FF3399 33F0FF F28A8C
	
	// Add function for color	  
   function cellColor($cells,$color){
    global $objPHPExcel;

    $objPHPExcel->getActiveSheet()->getStyle($cells)->getFill()->applyFromArray(array(
			'type' => PHPExcel_Style_Fill::FILL_SOLID,
			'startcolor' => array(
				 'rgb' => $color
			)
		));
	}

	//cellColor('B5', 'F28A8C');
	//cellColor('G5', 'EFA26E');
	cellColor('A2:Z2', 'D2C9C9');
	cellColor('A3:Z3', 'D2C9C9');
	cellColor('A4:Z4', 'D2C9C9');
    cellColor('A5:Z5', 'D2C9C9');
    cellColor('A6:Z6', 'D2C9C9');	
	
   // End function for color	
   
   //$objPHPExcel->getActiveSheet()->getStyle('A1')->getFill()->getStartColor()->setRGB('FF0000');
  

  $objPHPExcel->getDefaultStyle()
		  ->getBorders()
		  ->getTop()
		  ->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);
  $objPHPExcel->getDefaultStyle()
		  ->getBorders()
		  ->getBottom()
		  ->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);
  $objPHPExcel->getDefaultStyle()
		  ->getBorders()
		  ->getLeft()
		  ->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);
  $objPHPExcel->getDefaultStyle()
		  ->getBorders()
		  ->getRight()
		  ->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);
		  
  $styleArray_header = array(
	  'font' => array(
		  'bold' => true,
		  'color' => array('rgb' => '19194d'),
		  'size' => 12,
		  'name' => 'Verdana'
	  ),
	  'fill' => array(
		  'type' => PHPExcel_Style_Fill::FILL_SOLID,
		  'color' => array('rgb' => '9999ff'))
  );

  $objPHPExcel->getActiveSheet()->getStyle('A1:Z1')->applyFromArray($styleArray_header);

  $objPHPExcel->getActiveSheet()->setCellValue('A2', 'WH Code:'); 
  $objPHPExcel->getActiveSheet()->setCellValue('B2', $wmsData['warehouse_code']);
  $objPHPExcel->getActiveSheet()->setCellValue('A3', 'Associate Name:');
  $objPHPExcel->getActiveSheet()->setCellValue('B3', $wmsData['company_name']);
  $objPHPExcel->getActiveSheet()->setCellValue('A4', 'Email:'); 
  $objPHPExcel->getActiveSheet()->setCellValue('B4', $wmsData['email']);
  $objPHPExcel->getActiveSheet()->setCellValue('A5', 'City:');
  $objPHPExcel->getActiveSheet()->setCellValue('B5', $wmsData['city']);
  $objPHPExcel->getActiveSheet()->setCellValue('A6', 'Country:');
  $objPHPExcel->getActiveSheet()->setCellValue('B6', $wmsData['country']);
  
  
  $objPHPExcel->setActiveSheetIndex(0)->mergeCells('B2:C2');
  $objPHPExcel->setActiveSheetIndex(0)->mergeCells('B3:C3');
  $objPHPExcel->setActiveSheetIndex(0)->mergeCells('B4:C4');
  $objPHPExcel->setActiveSheetIndex(0)->mergeCells('B5:C5');
  $objPHPExcel->setActiveSheetIndex(0)->mergeCells('B6:C6'); 
  
  $objPHPExcel->getActiveSheet()->setCellValue('D2', 'Warehouse Name:');
  $objPHPExcel->getActiveSheet()->setCellValue('E2', $wmsData['warehouse_name']);
  $objPHPExcel->getActiveSheet()->setCellValue('D3', 'Phone:');
  $objPHPExcel->getActiveSheet()->setCellValue('E3', $wmsData['phone_no']);
  $objPHPExcel->getActiveSheet()->setCellValue('D4', 'Address:');
  $objPHPExcel->getActiveSheet()->setCellValue('E4', $wmsData['address']);
  $objPHPExcel->getActiveSheet()->setCellValue('D5', 'State:');
  $objPHPExcel->getActiveSheet()->setCellValue('E5', $wmsData['state']);
  $objPHPExcel->getActiveSheet()->setCellValue('D6', 'Pincode:');
  $objPHPExcel->getActiveSheet()->setCellValue('E6', $wmsData['pincode']);
  
  $objPHPExcel->setActiveSheetIndex(0)->mergeCells('E2:G2');
  $objPHPExcel->setActiveSheetIndex(0)->mergeCells('E3:G3');
  $objPHPExcel->setActiveSheetIndex(0)->mergeCells('E4:G4');
  $objPHPExcel->setActiveSheetIndex(0)->mergeCells('E5:G5');
  $objPHPExcel->setActiveSheetIndex(0)->mergeCells('E6:G6');
  
  $objPHPExcel->getActiveSheet()->setCellValue('A7', 'Date');
  $objPHPExcel->getActiveSheet()->setCellValue('B7', 'Opening Stock');
  $objPHPExcel->getActiveSheet()->setCellValue('C7', 'Total Qty Pending for confirmation GRN');
  $objPHPExcel->getActiveSheet()->setCellValue('D7', 'Total Confirmed GRN Qty');
  $objPHPExcel->getActiveSheet()->setCellValue('E7', 'Total GRN Qty');
  $objPHPExcel->getActiveSheet()->setCellValue('F7', 'Total Discrepancy Qty');
  $objPHPExcel->getActiveSheet()->setCellValue('G7', 'Total Reversal Discrepancy Qty');
  $objPHPExcel->getActiveSheet()->setCellValue('H7', 'Total Scrap Discrepancy Qty');
  $objPHPExcel->getActiveSheet()->setCellValue('I7', 'Total Qty Pending for confirmation Putaway');
  $objPHPExcel->getActiveSheet()->setCellValue('J7', 'Total Confirmed Putway Qty');
  $objPHPExcel->getActiveSheet()->setCellValue('K7', 'Total Putaway Qty');
  $objPHPExcel->getActiveSheet()->setCellValue('L7', 'Total Inward Inventory');
  $objPHPExcel->getActiveSheet()->setCellValue('M7', 'Total Order');
  $objPHPExcel->getActiveSheet()->setCellValue('N7', 'Total Order Qty');
  $objPHPExcel->getActiveSheet()->setCellValue('O7', 'Total Confirmed Order');
  $objPHPExcel->getActiveSheet()->setCellValue('P7', 'Total Confirmed Order Qty');
  $objPHPExcel->getActiveSheet()->setCellValue('Q7', 'Total Cancel Order');
  $objPHPExcel->getActiveSheet()->setCellValue('R7', 'Total Cancel Order Qty');
  $objPHPExcel->getActiveSheet()->setCellValue('S7', 'Total Picklist Qty');
  $objPHPExcel->getActiveSheet()->setCellValue('T7', 'Total Confirmed Picklist Qty');
  $objPHPExcel->getActiveSheet()->setCellValue('U7', 'Total Packing Qty');
  $objPHPExcel->getActiveSheet()->setCellValue('V7', 'Total QA Qty');
  $objPHPExcel->getActiveSheet()->setCellValue('W7', 'Total Dispatched Qty');
  $objPHPExcel->getActiveSheet()->setCellValue('X7', 'Total Delivered Qty');
  $objPHPExcel->getActiveSheet()->setCellValue('Y7', 'Total Outward Qty');
  $objPHPExcel->getActiveSheet()->setCellValue('Z7', 'Closing Stock');

  $rowCnt = 7;
  
  $style_cell12 = array(
	  'alignment' => array(
		  'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_LEFT,
		  'vertical' => PHPExcel_Style_Alignment::VERTICAL_TOP,
	  )
  );

    
  $objPHPExcel->getActiveSheet()->getStyle('A2:Z2')->applyFromArray($style_cell12);
  $objPHPExcel->getActiveSheet()->getStyle('A3:Z3')->applyFromArray($style_cell12);
  $objPHPExcel->getActiveSheet()->getStyle('A4:Z4')->applyFromArray($style_cell12);
  $objPHPExcel->getActiveSheet()->getStyle('A5:Z5')->applyFromArray($style_cell12);
  $objPHPExcel->getActiveSheet()->getStyle('A6:Z6')->applyFromArray($style_cell12);
  
  $style_cell = array(
	  'alignment' => array(
		  'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
		  'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER,
	  )
  );
  
  $styleArray = array(
	  'font' => array(
		  'bold' => true,
		  'color' => array('rgb' => '19194d'),
		  'size' => 10,
		  'name' => 'Verdana'
	  ),
	  'fill' => array(
		  'type' => PHPExcel_Style_Fill::FILL_SOLID,
		  'color' => array('rgb' => 'ccccff'))
  );
  
  $styleArray1 = array(
  'borders' => array(
	  'allborders' => array(
		  'style' => PHPExcel_Style_Border::BORDER_THIN
			  )
		  )
	  );
	
 //$objPHPExcel->getDefaultStyle()->applyFromArray($styleArray);
  $objPHPExcel->getActiveSheet()->getStyle('A1:Z1')->applyFromArray($styleArray1);
  $objPHPExcel->getActiveSheet()->getStyle('A7:Z7')->applyFromArray($styleArray1);
  $objPHPExcel->getActiveSheet()->getStyle('A7:Z7')->applyFromArray($styleArray);
  $objPHPExcel->getActiveSheet()->getStyle('A7:Z7')->applyFromArray($style_cell);
  $objPHPExcel->getActiveSheet()->getStyle('A7:Z7')->getAlignment()->setWrapText(true);
  $objPHPExcel->getActiveSheet()->getRowDimension(11)->setRowHeight(-1);

  //$objPHPExcel->getActiveSheet()->getColumnDimension('A7:Z7')->setAutoSize(true);
  
  $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(20);
  $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
  $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(20);
  $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(20);
  $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(20);
  $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(20);
  $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(20);
  $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(20);
  $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(20);
  $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(20);
  $objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(20);
  $objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(20);
  $objPHPExcel->getActiveSheet()->getColumnDimension('M')->setWidth(20);
  $objPHPExcel->getActiveSheet()->getColumnDimension('N')->setWidth(20);
  $objPHPExcel->getActiveSheet()->getColumnDimension('O')->setWidth(20);
  $objPHPExcel->getActiveSheet()->getColumnDimension('P')->setWidth(20);
  $objPHPExcel->getActiveSheet()->getColumnDimension('Q')->setWidth(20);
  $objPHPExcel->getActiveSheet()->getColumnDimension('R')->setWidth(20);
  $objPHPExcel->getActiveSheet()->getColumnDimension('S')->setWidth(20);
  $objPHPExcel->getActiveSheet()->getColumnDimension('T')->setWidth(20);
  $objPHPExcel->getActiveSheet()->getColumnDimension('U')->setWidth(20);
  $objPHPExcel->getActiveSheet()->getColumnDimension('V')->setWidth(20);
  $objPHPExcel->getActiveSheet()->getColumnDimension('W')->setWidth(20);
  $objPHPExcel->getActiveSheet()->getColumnDimension('X')->setWidth(20);
  $objPHPExcel->getActiveSheet()->getColumnDimension('Y')->setWidth(20);
  $objPHPExcel->getActiveSheet()->getColumnDimension('Z')->setWidth(20);
  
  $rowCount = 8;

      //$diff = strtotime($todt) - strtotime($fromdt);
	  //$no_of_days = abs(round($diff / 86400)); 
	  if ($fromdt != '' && $todt != '') {
	  $dates = displayDates($fromdt, $todt);
	  } else {
		$fromdt1 = date("Y-m-d");
		$todt1 = date("Y-m-d");
        $dates = displayDates($fromdt1, $todt1);		
	  }
	  //var_dump($dates); ; die('sgsffsfs');
	  foreach ($dates as $datevalue) {
        //echo $datevalue."<br />";		
		$showdate = $datevalue;
		
		$pending_grn = get_pending_grn($mycon, $showdate);
		if($pending_grn != ''){ $pending_grn = $pending_grn; } else { $pending_grn = 0; }
		$confired_grn = get_confired_grn($mycon, $showdate);
		if($confired_grn != ''){ $confired_grn = $confired_grn; } else { $confired_grn = 0; }
		$total_grn = $pending_grn + $confired_grn;
		$total_discrepancy= get_discrepancy($mycon, $showdate);
		if($total_discrepancy != ''){ $total_discrepancy = $total_discrepancy; } else { $total_discrepancy = 0; }
		$pending_putaway = get_pending_putaway($mycon, $showdate);
		if($pending_putaway != ''){ $pending_putaway = $pending_putaway; } else { $pending_putaway = 0; }
		$confired_putaway = get_confired_putaway($mycon, $showdate);
		if($confired_putaway != ''){ $confired_putaway = $confired_putaway; } else { $confired_putaway = 0; }
		$total_putaway = $pending_putaway + $confired_putaway ;
		$total_inventory = $total_grn + $total_discrepancy +  $total_putaway ;
		
		$not_reversal_discrepancy = get_not_reversal_discrepancy($mycon, $showdate);
		if($not_reversal_discrepancy != ''){ $not_reversal_discrepancy = $not_reversal_discrepancy; } else { $not_reversal_discrepancy = 0; }
		$reversal_discrepancy = get_reversal_discrepancy($mycon, $showdate);
		if($reversal_discrepancy != ''){ $reversal_discrepancy = $reversal_discrepancy; } else { $reversal_discrepancy = 0; }
		
		$total_order = get_total_order($mycon, $showdate);
		if($total_order != ''){ $total_order = $total_order; } else { $total_order = 0; }
		$total_order_qty = get_total_order_qty($mycon, $showdate);
		if($total_order_qty != ''){ $total_order_qty = $total_order_qty; } else { $total_order_qty = 0; }
		$total_cancel_order = get_total_cancel_order($mycon, $showdate);
		if($total_cancel_order != ''){ $total_cancel_order = $total_cancel_order; } else { $total_cancel_order = 0; }
		$total_cancel_order_qty = get_total_cancel_order_qty($mycon, $showdate);
		if($total_cancel_order_qty != ''){ $total_cancel_order_qty = $total_cancel_order_qty; } else { $total_cancel_order_qty = 0; }
		$total_confirmed_order = get_total_confirmed_order($mycon, $showdate);
		if($total_confirmed_order != ''){ $total_confirmed_order = $total_confirmed_order; } else { $total_confirmed_order = 0; }
		$total_confirmed_order_qty = get_total_confirmed_order_qty($mycon, $showdate);
		if($total_confirmed_order_qty != ''){ $total_confirmed_order_qty = $total_confirmed_order_qty; } else { $total_confirmed_order_qty = 0; }
		$total_picklist_qty = get_total_picklist_qty($mycon, $showdate);
		if($total_picklist_qty != ''){ $total_picklist_qty = $total_picklist_qty; } else { $total_picklist_qty = 0; }
		$total_confirmed_picklist_qty = get_total_confirmed_picklist_qty($mycon, $showdate);
		if($total_confirmed_picklist_qty != ''){ $total_confirmed_picklist_qty = $total_confirmed_picklist_qty; } else { $total_confirmed_picklist_qty = 0; }
		$total_packing_qty = get_total_packing_qty($mycon, $showdate);
		if($total_packing_qty != ''){ $total_packing_qty = $total_packing_qty; } else { $total_packing_qty = 0; }
		$total_picked_qt = get_total_picked_qt($mycon, $showdate);
		if($total_picked_qt != ''){ $total_picked_qt = $total_picked_qt; } else { $total_picked_qt = 0; }
		$total_dispatched_qty = get_total_dispatched_qty($mycon, $showdate);
		if($total_dispatched_qty != ''){ $total_dispatched_qty = $total_dispatched_qty; } else { $total_dispatched_qty = 0; }
		$total_delivered_qty = get_total_delivered_qty($mycon, $showdate);
		if($total_delivered_qty != ''){ $total_delivered_qty = $total_delivered_qty; } else { $total_delivered_qty = 0; }
		$total_outward_qty = $total_confirmed_picklist_qty;
				      
	  $objPHPExcel->getActiveSheet()->setCellValue('A' . $rowCount, $showdate);
	  $objPHPExcel->getActiveSheet()->setCellValue('B' . $rowCount, $Opening);
	  $objPHPExcel->getActiveSheet()->setCellValue('C' . $rowCount, $pending_grn);
	  $objPHPExcel->getActiveSheet()->setCellValue('D' . $rowCount, $confired_grn);
	  $objPHPExcel->getActiveSheet()->setCellValue('E' . $rowCount, $total_grn);
	  $objPHPExcel->getActiveSheet()->setCellValue('F' . $rowCount, $total_discrepancy);
	  $objPHPExcel->getActiveSheet()->setCellValue('G' . $rowCount, $reversal_discrepancy);
	  $objPHPExcel->getActiveSheet()->setCellValue('H' . $rowCount, $not_reversal_discrepancy);
	  $objPHPExcel->getActiveSheet()->setCellValue('I' . $rowCount, $pending_putaway);
	  $objPHPExcel->getActiveSheet()->setCellValue('J' . $rowCount, $confired_putaway);
	  $objPHPExcel->getActiveSheet()->setCellValue('K' . $rowCount, $total_putaway);
	  $objPHPExcel->getActiveSheet()->setCellValue('L' . $rowCount, $total_inventory);  
	  $objPHPExcel->getActiveSheet()->setCellValue('M' . $rowCount, $total_order);
	  $objPHPExcel->getActiveSheet()->setCellValue('N' . $rowCount, $total_order_qty);
	  $objPHPExcel->getActiveSheet()->setCellValue('O' . $rowCount, $total_confirmed_order);
	  $objPHPExcel->getActiveSheet()->setCellValue('P' . $rowCount, $total_confirmed_order_qty);
	  $objPHPExcel->getActiveSheet()->setCellValue('Q' . $rowCount, $total_cancel_order);
	  $objPHPExcel->getActiveSheet()->setCellValue('R' . $rowCount, $total_cancel_order_qty);
	  $objPHPExcel->getActiveSheet()->setCellValue('S' . $rowCount, $total_picklist_qty);
	  $objPHPExcel->getActiveSheet()->setCellValue('T' . $rowCount, $total_confirmed_picklist_qty);
	  $objPHPExcel->getActiveSheet()->setCellValue('U' . $rowCount, $total_packing_qty);
	  $objPHPExcel->getActiveSheet()->setCellValue('V' . $rowCount, $total_picked_qt);
	  $objPHPExcel->getActiveSheet()->setCellValue('W' . $rowCount, $total_dispatched_qty);
	  $objPHPExcel->getActiveSheet()->setCellValue('X' . $rowCount, $total_delivered_qty);
	  $objPHPExcel->getActiveSheet()->setCellValue('Y' . $rowCount, $total_outward_qty);	  
	  $objPHPExcel->getActiveSheet()->setCellValue('Z' . $rowCount, $total_inventory);
	  
	  
	  $styleArrayrows1 = array(
		  'borders' => array(
			  'allborders' => array(
				  'style' => PHPExcel_Style_Border::BORDER_THIN
					  )
				  )
			  );
	  $styleArrayrows2 = array(
			  'fill' => array(
				  'type' => PHPExcel_Style_Fill::FILL_SOLID)
		  );
		  
	  $objPHPExcel->getActiveSheet()->getStyle('A'. $rowCount.':Z'. $rowCount.'')->applyFromArray($styleArrayrows1);
	  $objPHPExcel->getActiveSheet()->getStyle('A'. $rowCount.':Z'. $rowCount.'')->applyFromArray($styleArrayrows2);
	  
	  $rowCount++;
	  
	}
	
	   
	  $styleArrayrows1 = array(
		  'borders' => array(
			  'allborders' => array(
				  'style' => PHPExcel_Style_Border::BORDER_THIN
					  )
				  )
			  );
	  $styleArrayrows2 = array(
			  'fill' => array(
				  'type' => PHPExcel_Style_Fill::FILL_SOLID)
		  );
		  
	  $objPHPExcel->getActiveSheet()->getStyle('A'. $rowCount.':Z'. $rowCount.'')->applyFromArray($styleArrayrows1);
	  $objPHPExcel->getActiveSheet()->getStyle('A'. $rowCount.':Z'. $rowCount.'')->applyFromArray($styleArrayrows2);
	  
	  $style_celltotal1 = array(
		  'font' => array(
			  'bold' => true,
			  'color' => array('rgb' => '19194d'),
			  'size' => 10,
			  'name' => 'Verdana'
		  ),
		  'fill' => array(
			  'type' => PHPExcel_Style_Fill::FILL_SOLID,
			  'color' => array('rgb' => 'ccccff'))
	  );
	  
	  $style_celltotal2 = array(
	  'borders' => array(
		  'allborders' => array(
			  'style' => PHPExcel_Style_Border::BORDER_THIN
				  )
			  )
		  );
	  $objPHPExcel->getActiveSheet()->getStyle('A'. $rowCount.':Z'. $rowCount.'')->applyFromArray($style_celltotal1);
      $objPHPExcel->getActiveSheet()->getStyle('A'. $rowCount.':Z'. $rowCount.'')->applyFromArray($style_celltotal2);
  
	  $objPHPExcel->getDefaultStyle()->applyFromArray(array(
				'borders' => array(
					'allborders' => array('style' => PHPExcel_Style_Border::BORDER_THIN,
										  'color' => array('rgb' => PHPExcel_Style_Color::COLOR_WHITE)
										  )
				)
			));

  
  $file = "Stock Closing Report- From-" .$fromdt. "-To-" .$todt. " dated-" .$dated. ".xlsx";

header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment;filename="'. $file .'"');
header('Cache-Control: max-age=0');
$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
ob_end_clean();
$objWriter->save('php://output');
exit;
//} 
?>