<?php
require_once '../init.php';

if (not_logged_in() === TRUE) {
    header('location: ../index.php');
    exit();
}

$po_id = isset($_POST['po_id']) ? $_POST['po_id'] : '';

$response = [
    'total_qty' => 0,
    'product_table' => '',
    'challan_no' => ''
];

// ✅ Function to get or create challan for this PO
function getOrCreateChallanNo($mycon, $po_id)
{
    $po_id = mysqli_real_escape_string($mycon, $po_id);
    $sql = "SELECT po_no FROM po_details WHERE id='$po_id' LIMIT 1";
    $res = mysqli_query($mycon, $sql);
    $row = mysqli_fetch_assoc($res);
    if (!$row) return null;
    $po_no = $row['po_no'];

    $sql2 = "SELECT challan_no FROM vendor_challan_tbl WHERE po_no='$po_no' ORDER BY id ASC LIMIT 1";
    $res2 = mysqli_query($mycon, $sql2);
    if ($res2 && mysqli_num_rows($res2) > 0) {
        $row2 = mysqli_fetch_assoc($res2);
        return $row2['challan_no'];
    }

    $year = date("Y");
    $random = str_pad(rand(1, 9999), 4, "0", STR_PAD_LEFT);
    return "CH-" . $year . "-" . $random;
}

// ✅ Function to get remaining qty (PO - issued)
function getRemainingQty($mycon, $po_id, $product_code)
{
    $po_id = mysqli_real_escape_string($mycon, $po_id);
    $product_code = mysqli_real_escape_string($mycon, $product_code);

    $sql_po = "SELECT qty FROM po_material WHERE po_id='$po_id' AND product_code='$product_code' LIMIT 1";
    $res_po = mysqli_query($mycon, $sql_po);
    $row_po = mysqli_fetch_assoc($res_po);
    $po_qty = $row_po ? (int)$row_po['qty'] : 0;

    $sql_ch = "SELECT SUM(qty) as issued 
               FROM vendor_challan_tbl 
               WHERE po_no = (SELECT po_no FROM po_details WHERE id='$po_id' LIMIT 1)
               AND product_code = '$product_code'";
    $res_ch = mysqli_query($mycon, $sql_ch);
    $row_ch = mysqli_fetch_assoc($res_ch);
    $issued = $row_ch && $row_ch['issued'] ? (int)$row_ch['issued'] : 0;

    $remaining = $po_qty - $issued;
    return max($remaining, 0);
}

if (!empty($po_id)) {
    $POQtySql = "SELECT SUM(qty) AS total_qty FROM po_material WHERE po_id = '" . mysqli_real_escape_string($mycon, $po_id) . "'";
    $result = mysqli_query($mycon, $POQtySql);
    $response['total_qty'] = ($result && $row = mysqli_fetch_assoc($result)) ? $row['total_qty'] : 0;

    $productHTML = '<div class="col-md-12">
    <div class="text-right mb-2" id="submitAllContainer" style="display:none;">
        <button type="button" id="submitAllBtn" class="btn btn-primary">Add All</button>
    </div>
    <table class="table table-bordered">
       <thead style="background:#1fac8b; color:white;">
            <tr>
                <th><input type="checkbox" id="checkAll"></th>
                <th>Product Code</th>
                <th>PO Qty</th>
                <th>Description</th>
                <th>UOM</th>
                <th>MOQ</th>
                <th>Color</th>
                <th>Qty</th>
                <th>Action</th>
            </tr>
        </thead>
        <tbody>';

    $GetPOWiseProd = "SELECT pm.product_code, pm.qty, mm.base_unit_of_measure, mm.`desc`, mm.moq, mm.color
                      FROM po_material pm
                      LEFT JOIN material_master mm ON pm.product_code = mm.part_no
                      WHERE pm.po_id = '" . mysqli_real_escape_string($mycon, $po_id) . "'";

    $ProdResult = mysqli_query($mycon, $GetPOWiseProd);

    if ($ProdResult && mysqli_num_rows($ProdResult) > 0) {
        $rowsAdded = false; // Track if any rows shown

        while ($ProdRows = mysqli_fetch_assoc($ProdResult)) {
            $remainingQty = getRemainingQty($mycon, $po_id, $ProdRows['product_code']);
            $poQty = (int)$ProdRows['qty'];

            // ✅ Skip this row if full PO Qty already issued
            if ($remainingQty <= 0) {
                continue;
            }

            $rowsAdded = true;
            $productHTML .= '<tr>
                <td><input type="checkbox" class="row-check"></td>
                <td class="product_code">' . htmlspecialchars($ProdRows['product_code']) . '</td>
                <td class="po_qty">' . $remainingQty . '</td>
                <td class="product_desc">' . htmlspecialchars($ProdRows['desc']) . '</td>
                <td class="uom">' . htmlspecialchars($ProdRows['base_unit_of_measure']) . '</td>
                <td class="moq">' . htmlspecialchars($ProdRows['moq']) . '</td>
                <td class="product_color">' . htmlspecialchars($ProdRows['color']) . '</td>
                <td><input type="number" class="qty form-control form-control-sm" value="' . $remainingQty . '" min="0" max="' . $remainingQty . '"></td>
                <td><button type="button" class="btn btn-success btn-sm submit-btn">Add</button></td>
            </tr>';
        }

        // ✅ Show message if no rows displayed (all fully issued)
        if (!$rowsAdded) {
            $productHTML .= '<tr><td colspan="9" class="text-center text-danger">All products for this PO are fully issued.</td></tr>';
        }

    } else {
        $productHTML .= '<tr><td colspan="9">No products found for this PO.</td></tr>';
    }

    $productHTML .= '</tbody></table></div>';

    $response['product_table'] = $productHTML;
    $response['challan_no'] = getOrCreateChallanNo($mycon, $po_id);
}

header('Content-Type: application/json');
echo json_encode($response);
exit();
?>
