<?php
if (!empty($_GET['crate_ids'])) {
    $ids = explode(',', $_GET['crate_ids']);
}
?>
<!DOCTYPE html>
<html>

<head>
    <title>Print Barcodes</title>
    <script src="https://cdn.jsdelivr.net/npm/jsbarcode@3.11.5/dist/JsBarcode.all.min.js"></script>
    <style>
        @page {
            size: 90mm 49mm;
            margin: 0;
        }

        body {
            margin: 0;
            padding: 0;
            text-align: center;
            font-family: Arial, sans-serif;
        }

        .label {
            width: 90mm;
            height: 49mm;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            page-break-after: always;
        }

        svg {
            width: 85mm;
            height: 35mm;
        }

        h3 {
            margin: 3mm 0 0;
            font-size: 6mm;
        }
    </style>
</head>

<body onload="printBarcodes()">
    <?php if (!empty($ids)): ?>
        <?php foreach ($ids as $id): ?>
            <div class="label">
                <svg id="barcode-<?php echo htmlspecialchars($id); ?>"></svg>
                
            </div>
        <?php endforeach; ?>
    <?php else: ?>
        <p>No crate IDs selected.</p>
    <?php endif; ?>

    <script>
        function printBarcodes() {
            <?php if (!empty($ids)): ?>
                <?php foreach ($ids as $id): ?>
                    JsBarcode("#barcode-<?php echo htmlspecialchars($id); ?>", "<?php echo htmlspecialchars($id); ?>", {
                        format: "CODE128",
                        displayValue: true,
                        width: 2,
                        height: 80,
                        margin: 0
                    });
                <?php endforeach; ?>
            <?php endif; ?>
            window.print();
        }
    </script>
</body>

</html>
